/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.TemplateType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DelcallAnnotationVisitor
extends AbstractSoyNodeVisitor<ImmutableSet<String>> {
    private final ImmutableSet.Builder<String> legacyNamespaces = ImmutableSet.builder();
    private final Map<VarDefn, ImmutableSet<String>> varToLegacyNamespacesMap = new HashMap<VarDefn, ImmutableSet<String>>();
    private final Map<VarDefn, ImmutableSet<VarDefn>> varToDepVarsMap = new HashMap<VarDefn, ImmutableSet<VarDefn>>();

    @Override
    public ImmutableSet<String> exec(SoyNode node) {
        this.visit(node);
        return this.legacyNamespaces.build();
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        FindModTemplatesAndVars visitor = new FindModTemplatesAndVars();
        visitor.exec(node.getExpr());
        this.varToLegacyNamespacesMap.put(node.getVar(), visitor.getLegacyNamespaces());
        this.varToDepVarsMap.put(node.getVar(), visitor.getReferencedVars());
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        this.findReferencesLegacyNamespaces(node.getCalleeExpr());
        this.visitChildren(node);
    }

    @Override
    protected void visitCallParamValueNode(CallParamValueNode node) {
        this.findReferencesLegacyNamespaces(node.getExpr());
    }

    private void findReferencesLegacyNamespaces(ExprNode exprNode) {
        FindModTemplatesAndVars visitor = new FindModTemplatesAndVars();
        visitor.exec(exprNode);
        this.legacyNamespaces.addAll(visitor.getLegacyNamespaces());
        visitor.getReferencedVars().forEach(this::collectVarTemplateRefs);
    }

    private void collectVarTemplateRefs(VarDefn varName) {
        this.collectVarTemplateRefs(varName, new HashSet<VarDefn>());
    }

    private void collectVarTemplateRefs(VarDefn varName, Set<VarDefn> visited) {
        if (!visited.add(varName)) {
            return;
        }
        if (this.varToLegacyNamespacesMap.containsKey(varName)) {
            this.legacyNamespaces.addAll((Iterable)this.varToLegacyNamespacesMap.get(varName));
        }
        if (this.varToDepVarsMap.containsKey(varName)) {
            this.varToDepVarsMap.get(varName).forEach(var -> this.collectVarTemplateRefs((VarDefn)var, visited));
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private static class FindModTemplatesAndVars
    extends AbstractExprNodeVisitor<Void> {
        private final ImmutableSet.Builder<String> legacyNamespaces = ImmutableSet.builder();
        private final ImmutableSet.Builder<VarDefn> referencedVars = ImmutableSet.builder();

        FindModTemplatesAndVars() {
        }

        ImmutableSet<String> getLegacyNamespaces() {
            return this.legacyNamespaces.build();
        }

        ImmutableSet<VarDefn> getReferencedVars() {
            return this.referencedVars.build();
        }

        @Override
        protected void visitTemplateLiteralNode(TemplateLiteralNode node) {
            String legacyDeltemplateNamespace;
            if (node.getType() instanceof TemplateType && ((TemplateType)node.getType()).isModifiable() && !(legacyDeltemplateNamespace = ((TemplateType)node.getType()).getLegacyDeltemplateNamespace()).isEmpty()) {
                this.legacyNamespaces.add((Object)legacyDeltemplateNamespace);
            }
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(1));
            this.visit(node.getChild(2));
        }

        @Override
        protected void visitVarRefNode(VarRefNode node) {
            this.referencedVars.add((Object)node.getDefnDecl());
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }
}

