/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AstEdits {
    final Set<SoyNode.StandaloneNode> toRemove = new LinkedHashSet<SoyNode.StandaloneNode>();
    final ListMultimap<SoyNode.StandaloneNode, SoyNode.StandaloneNode> replacements = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    final ListMultimap<SoyNode.ParentSoyNode<SoyNode.StandaloneNode>, SoyNode.StandaloneNode> newChildren = MultimapBuilder.linkedHashKeys().arrayListValues().build();

    public void apply() {
        for (SoyNode.StandaloneNode standaloneNode : this.toRemove) {
            ParentNode parent = standaloneNode.getParent();
            int index = parent.getChildIndex(standaloneNode);
            parent.removeChild(index);
            List children = this.replacements.get((Object)standaloneNode);
            if (children.isEmpty()) continue;
            parent.addChildren(index, children);
        }
        for (Map.Entry entry : Multimaps.asMap(this.newChildren).entrySet()) {
            ((SoyNode.ParentSoyNode)entry.getKey()).addChildren((List)entry.getValue());
        }
        this.clear();
    }

    public void remove(SoyNode.StandaloneNode node) {
        Preconditions.checkNotNull((Object)node);
        if (node.getParent() != null) {
            this.toRemove.add(node);
        }
    }

    public void addChildren(SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parent, Iterable<SoyNode.StandaloneNode> children) {
        Preconditions.checkNotNull(parent);
        this.newChildren.putAll(parent, children);
    }

    public void addChild(SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parent, SoyNode.StandaloneNode child) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkNotNull((Object)child);
        this.newChildren.put(parent, (Object)child);
    }

    public void replace(SoyNode.StandaloneNode oldNode, Iterable<SoyNode.StandaloneNode> newNodes) {
        Preconditions.checkState((oldNode.getParent() != null ? 1 : 0) != 0, (Object)"oldNode must be in the tree in order to replace it");
        this.remove(oldNode);
        this.replacements.putAll((Object)oldNode, newNodes);
    }

    public void replace(SoyNode.StandaloneNode oldNode, SoyNode.StandaloneNode newNode) {
        this.replace(oldNode, (Iterable<SoyNode.StandaloneNode>)ImmutableList.of((Object)newNode));
    }

    public void clear() {
        this.toRemove.clear();
        this.replacements.clear();
        this.newChildren.clear();
    }
}

