/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soyparse.SimpleCharStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

final class SoySimpleCharStream
extends SimpleCharStream {
    int[] lineLengths = new int[2048];

    @Override
    public char readChar() throws IOException {
        char c = super.readChar();
        this.updateLineLengthsForNewChar();
        return c;
    }

    private void updateLineLengthsForNewChar() {
        if (this.line >= this.lineLengths.length) {
            this.lineLengths = Arrays.copyOf(this.lineLengths, Math.max(this.lineLengths.length, this.line) + 2048);
        }
        this.lineLengths[this.line] = Math.max(this.lineLengths[this.line], this.column);
    }

    SourceLocation.Point getPointJustBeforeNextToken() {
        if (this.bufline[this.tokenBegin] <= 1 && this.bufcolumn[this.tokenBegin] <= 1) {
            throw new IllegalStateException("Can't get point before beginning of file");
        }
        if (this.tokenBegin > 0) {
            return SourceLocation.Point.create(this.bufline[this.tokenBegin - 1], this.bufcolumn[this.tokenBegin - 1]);
        }
        if (this.bufcolumn[this.tokenBegin] == 1) {
            return SourceLocation.Point.create(this.bufline[this.tokenBegin] - 1, this.lineLengths[this.bufline[this.tokenBegin] - 1]);
        }
        return SourceLocation.Point.create(this.bufline[this.tokenBegin], this.bufcolumn[this.tokenBegin] - 1);
    }

    public SoySimpleCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        super(dstream, startline, startcolumn, buffersize);
    }

    public SoySimpleCharStream(Reader dstream, int startline, int startcolumn) {
        this(dstream, startline, startcolumn, 4096);
    }

    public SoySimpleCharStream(Reader dstream) {
        this(dstream, 1, 1, 4096);
    }
}

