/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;

final class SoyParseUtils {
    private static final SoyErrorKind CALL_COLLIDES_WITH_NAMESPACE_ALIAS = SoyErrorKind.of("Call collides with namespace alias ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_UNICODE_SEQUENCE = SoyErrorKind.of("Invalid unicode sequence ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNKNOWN_ESCAPE_CODE = SoyErrorKind.of("Unknown escape code ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_CALLEE_NAMESPACE = SoyErrorKind.of("Callee ''{0}'' should be relative to a namespace. Did you mean ''.{0}''?", new SoyErrorKind.StyleAllowance[0]);

    SoyParseUtils() {
    }

    public static String unescapeString(String s, ErrorReporter errorReporter, SourceLocation loc) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                i = SoyParseUtils.doUnescape(s, i + 1, sb, errorReporter, loc);
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static int doUnescape(String s, int i, StringBuilder sb, ErrorReporter errorReporter, SourceLocation loc) {
        Preconditions.checkArgument((i < s.length() ? 1 : 0) != 0, (Object)"Found escape sequence at the end of a string.");
        char c = s.charAt(i++);
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'b': {
                sb.append('\b');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '\\': {
                sb.append(c);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int nOctalDigits;
                int digitLimit;
                --i;
                int n = digitLimit = c < '4' ? 3 : 2;
                for (nOctalDigits = 1; nOctalDigits < digitLimit && i + nOctalDigits < s.length() && SoyParseUtils.isOctal(s.charAt(i + nOctalDigits)); ++nOctalDigits) {
                }
                sb.append((char)Integer.parseInt(s.substring(i, i + nOctalDigits), 8));
                i += nOctalDigits;
                break;
            }
            case 'u': 
            case 'x': {
                int unicodeValue;
                String hexCode;
                int nHexDigits = c == 'u' ? 4 : 2;
                try {
                    hexCode = s.substring(i, i + nHexDigits);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    errorReporter.report(loc.offsetStartCol(i + 1), INVALID_UNICODE_SEQUENCE, s.substring(i));
                    return i + nHexDigits;
                }
                try {
                    unicodeValue = Integer.parseInt(hexCode, 16);
                }
                catch (NumberFormatException nfe) {
                    errorReporter.report(loc.offsetStartCol(i + 1), INVALID_UNICODE_SEQUENCE, hexCode);
                    return i + nHexDigits;
                }
                sb.append((char)unicodeValue);
                i += nHexDigits;
                break;
            }
            default: {
                errorReporter.report(loc.offsetStartCol(i), UNKNOWN_ESCAPE_CODE, Character.valueOf(c));
                return i;
            }
        }
        return i;
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    static String unescapeCommandAttributeValue(String s, QuoteStyle quoteStyle) {
        Preconditions.checkArgument((quoteStyle == QuoteStyle.SINGLE || quoteStyle == QuoteStyle.DOUBLE ? 1 : 0) != 0, (Object)"Quote style must be SINGLE or DOUBLE");
        int index = s.indexOf(quoteStyle == QuoteStyle.DOUBLE ? "\\\"" : "\\'");
        if (index == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        buf.append(s);
        boolean nextIsQ = buf.charAt(s.length() - 1) == quoteStyle.getQuoteChar();
        for (int i = s.length() - 2; i >= index; --i) {
            char c = buf.charAt(i);
            if (c == '\\' && nextIsQ) {
                buf.deleteCharAt(i);
            }
            nextIsQ = c == quoteStyle.getQuoteChar();
        }
        return buf.toString();
    }
}

