/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soyparse.Token;
import java.util.HashSet;
import java.util.List;

class CallArgs {
    final ImmutableList<Identifier> names;
    final ImmutableList<ExprNode> values;
    final ImmutableList<SourceLocation.Point> commas;
    final Token close;

    static CallArgs positional(ImmutableList<ExprNode> args, ImmutableList<SourceLocation.Point> commaPos, Token close) {
        return new CallArgs(null, args, commaPos, close);
    }

    static CallArgs named(ErrorReporter errorReporter, ImmutableList<Identifier> names, ImmutableList<ExprNode> values, Token close) {
        HashSet<String> paramNames = new HashSet<String>();
        for (Identifier name : names) {
            if (paramNames.add(name.identifier())) continue;
            errorReporter.report(name.location(), SoyFileParser.DUPLICATE_KEY_NAME, name.identifier());
        }
        return new CallArgs(names, values, null, close);
    }

    static CallArgs empty(Token close) {
        return new CallArgs(null, (ImmutableList<ExprNode>)ImmutableList.of(), (ImmutableList<SourceLocation.Point>)ImmutableList.of(), close);
    }

    private CallArgs(ImmutableList<Identifier> names, ImmutableList<ExprNode> values, ImmutableList<SourceLocation.Point> commas, Token close) {
        this.names = names;
        this.values = values;
        this.commas = commas;
        this.close = close;
    }

    public boolean isNamed() {
        return this.names != null;
    }

    public CallableExprBuilder toBuilder() {
        CallableExprBuilder cb = CallableExprBuilder.builder().setParamValues((List<ExprNode>)this.values).setCommaLocations((List<SourceLocation.Point>)this.commas);
        if (this.isNamed()) {
            cb.setParamNames((List<Identifier>)this.names);
        }
        return cb;
    }
}

