/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class RenderableThunk
implements SoyValueProvider {
    private String content;
    private SoyValue resolved;
    private final SanitizedContent.ContentKind kind;

    protected RenderableThunk(SanitizedContent.ContentKind kind) {
        this.kind = (SanitizedContent.ContentKind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
    }

    @Override
    public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable) throws IOException {
        if (this.content == null) {
            this.doResolveOnto(new TeeAppendable(appendable));
        } else {
            appendable.append(this.content);
        }
        return RenderResult.done();
    }

    @Override
    @Nonnull
    public SoyValue resolve() {
        if (this.resolved == null) {
            this.doResolveOnto(new StringBuilder());
        }
        return this.resolved;
    }

    @Override
    @Nonnull
    public RenderResult status() {
        this.resolve();
        return RenderResult.done();
    }

    void doResolveOnto(Appendable appendable) {
        this.doRender(appendable);
        this.content = appendable.toString();
        this.resolved = this.kind == SanitizedContent.ContentKind.TEXT ? StringData.forValue(this.content) : UnsafeSanitizedContentOrdainer.ordainAsSafe(this.content, this.kind);
    }

    protected abstract void doRender(Appendable var1);

    private static final class TeeAppendable
    implements Appendable {
        final StringBuilder buffer = new StringBuilder();
        final Appendable delegate;

        TeeAppendable(Appendable delegate) {
            this.delegate = delegate;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

