/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import com.ibm.icu.util.ULocale;
import javax.annotation.Nullable;

final class RenderVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private final RenderVisitor master;
    private final SoyMsgBundle msgBundle;

    RenderVisitorAssistantForMsgs(RenderVisitor master, SoyMsgBundle msgBundle) {
        this.master = master;
        this.msgBundle = msgBundle;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    void visitForUseByMaster(SoyNode node) {
        this.visit(node);
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        boolean foundTranslation = false;
        if (this.msgBundle != null) {
            for (MsgNode msg : node.getChildren()) {
                ImmutableList<SoyMsgPart> translation = this.msgBundle.getMsgParts(MsgUtils.computeMsgIdForDualFormat(msg));
                if (!translation.isEmpty()) {
                    this.renderMsgFromTranslation(msg, translation, this.msgBundle.getLocale());
                    foundTranslation = true;
                    break;
                }
                ImmutableList<SoyMsgPart> translationByAlternateId = msg.getAlternateId().isPresent() ? this.msgBundle.getMsgParts(msg.getAlternateId().getAsLong()) : ImmutableList.of();
                if (translationByAlternateId.isEmpty()) continue;
                this.renderMsgFromTranslation(msg, translationByAlternateId, this.msgBundle.getLocale());
                foundTranslation = true;
                break;
            }
        }
        if (!foundTranslation) {
            this.renderMsgFromSource((MsgNode)node.getChild(0));
        }
    }

    private void renderMsgFromTranslation(MsgNode msg, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale) {
        SoyMsgPart firstPart = (SoyMsgPart)msgParts.get(0);
        if (firstPart instanceof SoyMsgPluralPart) {
            new PlrselMsgPartsVisitor(msg, locale).visitPart((SoyMsgPluralPart)firstPart);
        } else if (firstPart instanceof SoyMsgSelectPart) {
            new PlrselMsgPartsVisitor(msg, locale).visitPart((SoyMsgSelectPart)firstPart);
        } else {
            for (SoyMsgPart msgPart : msgParts) {
                if (msgPart instanceof SoyMsgRawTextPart) {
                    String s = ((SoyMsgRawTextPart)msgPart).getRawText();
                    if (msg.getEscapingMode() == EscapingMode.ESCAPE_HTML) {
                        s = s.replace("<", "&lt;");
                    }
                    RenderVisitor.append(this.master.getCurrOutputBufForUseByAssistants(), s);
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                    this.visit(msg.getRepPlaceholderNode(placeholderName));
                    continue;
                }
                throw new AssertionError();
            }
        }
    }

    private void renderMsgFromSource(MsgNode msg) {
        this.visitChildren(msg);
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitMsgPluralNode(MsgPluralNode node) {
        double pluralValue;
        ExprRootNode pluralExpr = node.getExpr();
        try {
            pluralValue = this.master.evalForUseByAssistants(pluralExpr, node).numberValue();
        }
        catch (SoyDataException e) {
            throw RenderException.createWithSource(String.format("Plural expression \"%s\" doesn't evaluate to number.", pluralExpr.toSourceString()), e, node);
        }
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgPluralDefaultNode) {
                this.visitChildren(child);
                break;
            }
            if ((double)((MsgPluralCaseNode)child).getCaseNumber() != pluralValue) continue;
            this.visitChildren(child);
            break;
        }
    }

    @Override
    protected void visitMsgSelectNode(MsgSelectNode node) {
        String selectValue;
        ExprRootNode selectExpr = node.getExpr();
        try {
            selectValue = this.master.evalForUseByAssistants(selectExpr, node).coerceToString();
        }
        catch (SoyDataException e) {
            throw RenderException.createWithSource(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()), e, node);
        }
        for (CaseOrDefaultNode child : node.getChildren()) {
            if (child instanceof MsgSelectDefaultNode) {
                this.visitChildren(child);
                continue;
            }
            if (!((MsgSelectCaseNode)child).getCaseValue().equals(selectValue)) continue;
            this.visitChildren(child);
            return;
        }
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private class PlrselMsgPartsVisitor {
        private final MsgNode msgNode;
        private final ULocale locale;

        public PlrselMsgPartsVisitor(MsgNode msgNode, ULocale locale) {
            this.msgNode = msgNode;
            this.locale = locale;
        }

        private void visitPart(SoyMsgSelectPart selectPart) {
            String correctSelectValue;
            String selectVarName = selectPart.getSelectVarName();
            MsgSelectNode repSelectNode = this.msgNode.getRepSelectNode(selectVarName);
            ExprRootNode selectExpr = repSelectNode.getExpr();
            try {
                correctSelectValue = RenderVisitorAssistantForMsgs.this.master.evalForUseByAssistants(selectExpr, repSelectNode).stringValue();
            }
            catch (SoyDataException e) {
                throw RenderException.createWithSource(String.format("Select expression \"%s\" doesn't evaluate to string.", selectExpr.toSourceString()), e, repSelectNode);
            }
            ImmutableList<SoyMsgPart> caseParts = selectPart.lookupCase(correctSelectValue);
            if (caseParts != null) {
                for (SoyMsgPart casePart : caseParts) {
                    if (casePart instanceof SoyMsgSelectPart) {
                        this.visitPart((SoyMsgSelectPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPluralPart) {
                        this.visitPart((SoyMsgPluralPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgPlaceholderPart) {
                        this.visitPart((SoyMsgPlaceholderPart)casePart);
                        continue;
                    }
                    if (casePart instanceof SoyMsgRawTextPart) {
                        this.appendRawTextPart((SoyMsgRawTextPart)casePart);
                        continue;
                    }
                    throw RenderException.create("Unsupported part of type " + casePart.getClass().getName() + " under a select case.").addStackTraceElement(repSelectNode);
                }
            }
        }

        private void visitPart(SoyMsgPluralPart pluralPart) {
            double correctPluralValue;
            MsgPluralNode repPluralNode = this.msgNode.getRepPluralNode(pluralPart.getPluralVarName());
            ExprRootNode pluralExpr = repPluralNode.getExpr();
            try {
                correctPluralValue = RenderVisitorAssistantForMsgs.this.master.evalForUseByAssistants(pluralExpr, repPluralNode).numberValue();
            }
            catch (SoyDataException e) {
                throw RenderException.createWithSource(String.format("Plural expression \"%s\" doesn't evaluate to number.", pluralExpr.toSourceString()), e, repPluralNode);
            }
            ImmutableList<SoyMsgPart> caseParts = pluralPart.lookupCase(correctPluralValue, this.locale);
            for (SoyMsgPart casePart : caseParts) {
                if (casePart instanceof SoyMsgPlaceholderPart) {
                    this.visitPart((SoyMsgPlaceholderPart)casePart);
                    continue;
                }
                if (casePart instanceof SoyMsgRawTextPart) {
                    this.appendRawTextPart((SoyMsgRawTextPart)casePart);
                    continue;
                }
                if (casePart instanceof SoyMsgPluralRemainderPart) {
                    this.appendPluralRemainder(correctPluralValue - (double)pluralPart.getOffset());
                    continue;
                }
                throw RenderException.create("Unsupported part of type " + casePart.getClass().getName() + " under a plural case.").addStackTraceElement(repPluralNode);
            }
        }

        private void visitPart(SoyMsgPlaceholderPart msgPlaceholderPart) {
            RenderVisitorAssistantForMsgs.this.visit(this.msgNode.getRepPlaceholderNode(msgPlaceholderPart.getPlaceholderName()));
        }

        private void appendPluralRemainder(double currentPluralRemainderValue) {
            RenderVisitor.append(RenderVisitorAssistantForMsgs.this.master.getCurrOutputBufForUseByAssistants(), String.valueOf(currentPluralRemainderValue));
        }

        private void appendRawTextPart(SoyMsgRawTextPart rawTextPart) {
            RenderVisitor.append(RenderVisitorAssistantForMsgs.this.master.getCurrOutputBufForUseByAssistants(), rawTextPart.getRawText());
        }
    }
}

