/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.types.SoyType;
import java.util.List;

public final class SoySourceFunctionMethod
implements SoyMethod {
    private final SoySourceFunction impl;
    private final SoyType baseType;
    private final SoyType returnType;
    private final ImmutableList<SoyType> argTypes;
    private final String methodName;

    public SoySourceFunctionMethod(SoySourceFunction impl, SoyType baseType, SoyType returnType, ImmutableList<SoyType> argTypes, String methodName) {
        this.impl = impl;
        this.baseType = baseType;
        this.returnType = returnType;
        this.argTypes = argTypes;
        this.methodName = methodName;
    }

    @Override
    public int getNumArgs() {
        return this.argTypes.size();
    }

    @Override
    public boolean appliesToArgs(List<SoyType> argTypes) {
        Preconditions.checkArgument((argTypes.size() == this.argTypes.size() ? 1 : 0) != 0);
        for (int i = 0; i < argTypes.size(); ++i) {
            if (((SoyType)this.argTypes.get(i)).isAssignableFromStrict(argTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public SoySourceFunction getImpl() {
        return this.impl;
    }

    public SoyType getBaseType() {
        return this.baseType;
    }

    public SoyType getReturnType() {
        return this.returnType;
    }

    public ImmutableList<SoyType> getArgTypes() {
        return this.argTypes;
    }

    public boolean appliesToBase(SoyType baseType) {
        return this.baseType.isAssignableFromStrict(baseType);
    }

    public String getMethodName() {
        return this.methodName;
    }
}

