/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.ProtoExtensionImportType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateBindingUtil;
import com.google.template.soy.types.UndefinedType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public enum BuiltinMethod implements SoyMethod
{
    GET_EXTENSION("getExtension", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            return BuiltinMethod.isExtendableMessageType(baseType);
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            SoyProtoType protoType = (SoyProtoType)baseType;
            Optional<ProtoExtensionImportType> extType = BuiltinMethod.getExtensionType(protoType, (ExprNode)Iterables.getOnlyElement(params), errorReporter);
            if (extType.isEmpty()) {
                return UnknownType.getInstance();
            }
            return SoyTypes.tryRemoveNullish(protoType.getFieldType(extType.get().getFieldName()));
        }
    }
    ,
    GET_READONLY_EXTENSION("getReadonlyExtension", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            return BuiltinMethod.isExtendableMessageType(baseType);
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            SoyProtoType protoType = (SoyProtoType)baseType;
            Optional<ProtoExtensionImportType> extType = BuiltinMethod.getExtensionType(protoType, (ExprNode)Iterables.getOnlyElement(params), errorReporter);
            if (extType.isEmpty()) {
                return UnknownType.getInstance();
            }
            if (extType.get().getDescriptor().getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || extType.get().getDescriptor().isRepeated()) {
                errorReporter.report(params.get(0).getSourceLocation(), GET_READONLY_EXTENSION_MAY_ONLY_BE_CALLED_ON_MESSAGE_EXTENSIONS, new Object[0]);
            }
            return SoyTypes.tryRemoveNullish(protoType.getFieldType(extType.get().getFieldName()));
        }
    }
    ,
    HAS_EXTENSION("hasExtension", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            return BuiltinMethod.isExtendableMessageType(baseType);
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            SoyProtoType protoType = (SoyProtoType)baseType;
            Optional<ProtoExtensionImportType> extType = BuiltinMethod.getExtensionType(protoType, (ExprNode)Iterables.getOnlyElement(params), errorReporter);
            if (extType.isEmpty()) {
                return UnknownType.getInstance();
            }
            if (extType.get().getDescriptor().isRepeated()) {
                errorReporter.report(params.get(0).getSourceLocation(), HAS_EXTENSION_MAY_ONLY_BE_CALLED_ON_SINGULAR_EXTENSIONS, new Object[0]);
            }
            return BoolType.getInstance();
        }
    }
    ,
    HAS_PROTO_FIELD("has[X]", 0){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKind(baseType, SoyType.Kind.PROTO);
        }

        @Override
        public boolean appliesTo(String methodName, SoyType baseType) {
            Optional<String> fieldName = BuiltinMethod.getHasserFieldName(methodName);
            return fieldName.isPresent() && this.appliesToProto(fieldName.get(), baseType, this::acceptFieldDescriptor);
        }

        private boolean acceptFieldDescriptor(Descriptors.FieldDescriptor fd) {
            if (fd.isExtension()) {
                return false;
            }
            return fd.hasPresence();
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            return BoolType.getInstance();
        }

        @Override
        ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
            return this.expandMethodNamesForProto(baseType, this::acceptFieldDescriptor, x$0 -> BuiltinMethod.fieldToHasMethodName(x$0));
        }
    }
    ,
    GET_PROTO_FIELD("get[X]", 0){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKind(baseType, SoyType.Kind.PROTO);
        }

        @Override
        public boolean appliesTo(String methodName, SoyType baseType) {
            Optional<String> fieldName = BuiltinMethod.getGetterFieldName(methodName);
            return fieldName.isPresent() && this.appliesToProto(fieldName.get(), baseType, this::acceptFieldDescriptor);
        }

        private boolean acceptFieldDescriptor(Descriptors.FieldDescriptor fd) {
            if (fd.isExtension()) {
                return false;
            }
            if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return true;
            }
            return true;
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            String fieldName = BuiltinMethod.getGetterFieldName(methodName).get();
            return BuiltinMethod.computeTypeForProtoFieldName(baseType, fieldName, soyTypeRegistry);
        }

        @Override
        ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
            return this.expandMethodNamesForProto(baseType, this::acceptFieldDescriptor, BuiltinMethod::protoFieldToGetMethodName);
        }
    }
    ,
    GET_PROTO_FIELD_OR_UNDEFINED("get[X]OrUndefined", 0){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKind(baseType, SoyType.Kind.PROTO);
        }

        @Override
        public boolean appliesTo(String methodName, SoyType baseType) {
            Optional<String> fieldName = BuiltinMethod.getGetOrUndefinedFieldName(methodName);
            return fieldName.isPresent() && this.appliesToProto(fieldName.get(), baseType, this::acceptFieldDescriptor);
        }

        private boolean acceptFieldDescriptor(Descriptors.FieldDescriptor fd) {
            if (fd.isExtension() || fd.isRepeated()) {
                return false;
            }
            if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return false;
            }
            return fd.hasPresence();
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            return SoyTypes.makeUndefinable(BuiltinMethod.computeTypeForProtoFieldName(baseType, BuiltinMethod.getGetOrUndefinedFieldName(methodName).get(), soyTypeRegistry));
        }

        @Override
        ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
            return this.expandMethodNamesForProto(baseType, this::acceptFieldDescriptor, BuiltinMethod::fieldToGetOrUndefinedMethodName);
        }
    }
    ,
    GET_READONLY_PROTO_FIELD("getReadonly[X]", 0){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKind(baseType, SoyType.Kind.PROTO);
        }

        @Override
        public boolean appliesTo(String methodName, SoyType baseType) {
            Optional<String> fieldName = BuiltinMethod.getGetReadonlyFieldName(methodName);
            return fieldName.isPresent() && this.appliesToProto(fieldName.get(), baseType, this::acceptFieldDescriptor);
        }

        private boolean acceptFieldDescriptor(Descriptors.FieldDescriptor fd) {
            if (fd.isExtension() || fd.isRepeated()) {
                return false;
            }
            return fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            return SoyTypes.tryRemoveNullish(BuiltinMethod.computeTypeForProtoFieldName(baseType, BuiltinMethod.getGetReadonlyFieldName(methodName).get(), soyTypeRegistry));
        }

        @Override
        ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
            return this.expandMethodNamesForProto(baseType, this::acceptFieldDescriptor, BuiltinMethod::protoFieldToGetReadonlyMethodName);
        }
    }
    ,
    MAP_GET("get", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKind(baseType, SoyType.Kind.MAP);
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            SoyType keyType = SoyTypes.getMapKeysType(baseType);
            ExprNode arg = params.get(0);
            if (baseType.equals(MapType.EMPTY_MAP)) {
                errorReporter.report(arg.getParent().getSourceLocation(), EMPTY_MAP_ACCESS, new Object[0]);
            } else if (!keyType.isAssignableFromLoose(arg.getType())) {
                errorReporter.report(arg.getSourceLocation(), METHOD_INVALID_PARAM_TYPES, "get", arg.getType(), keyType);
            }
            if (baseType.equals(MapType.EMPTY_MAP)) {
                return UndefinedType.getInstance();
            }
            return SoyTypes.makeUndefinable(SoyTypes.getMapValuesType(baseType));
        }
    }
    ,
    BIND("bind", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKinds(baseType, (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)SoyType.Kind.TEMPLATE), (Object)((Object)SoyType.Kind.TEMPLATE_TYPE)));
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            Preconditions.checkArgument((params.size() == 1 ? 1 : 0) != 0);
            ExprNode param = params.get(0);
            if (param.getKind() != ExprNode.Kind.RECORD_LITERAL_NODE) {
                errorReporter.report(param.getSourceLocation(), BIND_PARAMETER_MUST_BE_RECORD_LITERAL, new Object[0]);
                return UnknownType.getInstance();
            }
            return TemplateBindingUtil.bindParameters(baseType, (RecordType)param.getType(), soyTypeRegistry, errorReporter.bind(param.getSourceLocation()));
        }
    };

    private static final SoyErrorKind GET_EXTENSION_BAD_ARG;
    private static final SoyErrorKind PROTO_EXTENSION_DOES_NOT_EXIST;
    private static final SoyErrorKind GET_READONLY_EXTENSION_MAY_ONLY_BE_CALLED_ON_MESSAGE_EXTENSIONS;
    private static final SoyErrorKind HAS_EXTENSION_MAY_ONLY_BE_CALLED_ON_SINGULAR_EXTENSIONS;
    private static final SoyErrorKind BIND_PARAMETER_MUST_BE_RECORD_LITERAL;
    public static final SoyErrorKind METHOD_INVALID_PARAM_TYPES;
    private static final SoyErrorKind EMPTY_MAP_ACCESS;
    public static final SoyMethod.Registry REGISTRY;
    private final String name;
    private final int argCount;

    public static String getProtoFieldNameFromMethodCall(MethodCallNode node) {
        String methodName = node.getMethodName().identifier();
        switch ((BuiltinMethod)node.getSoyMethod()) {
            case HAS_PROTO_FIELD: {
                return BuiltinMethod.getHasserFieldName(methodName).get();
            }
            case GET_PROTO_FIELD: {
                return BuiltinMethod.getGetterFieldName(methodName).get();
            }
            case GET_PROTO_FIELD_OR_UNDEFINED: {
                return BuiltinMethod.getGetOrUndefinedFieldName(methodName).get();
            }
            case GET_READONLY_PROTO_FIELD: {
                return BuiltinMethod.getGetReadonlyFieldName(methodName).get();
            }
        }
        throw new AssertionError((Object)("not a proto getter: " + String.valueOf(node.getSoyMethod())));
    }

    public static String getProtoArgNameFromMethodCall(MethodCallNode node) {
        SoyMethod method = node.getSoyMethod();
        return method == GET_EXTENSION || method == GET_READONLY_EXTENSION || method == HAS_EXTENSION ? BuiltinMethod.getProtoExtensionIdFromMethodCall(node) : BuiltinMethod.getProtoFieldNameFromMethodCall(node);
    }

    public static String getProtoExtensionIdFromMethodCall(MethodCallNode node) {
        ExprNode arg = node.getChild(1);
        return ((ProtoExtensionImportType)arg.getType()).getFieldName();
    }

    protected ImmutableCollection<String> expandMethodNamesForProto(SoyType baseType, Predicate<Descriptors.FieldDescriptor> acceptField, Function<String, String> fieldToMethodName) {
        if (!this.appliesToBase(baseType)) {
            return ImmutableList.of();
        }
        SoyProtoType protoType = (SoyProtoType)SoyTypes.expandUnions(baseType).get(0);
        return (ImmutableCollection)protoType.getFieldNames().stream().filter(name -> acceptField.test(protoType.getFieldDescriptor((String)name))).map(fieldToMethodName).collect(ImmutableSet.toImmutableSet());
    }

    protected boolean appliesToProto(String fieldName, SoyType baseType, Predicate<Descriptors.FieldDescriptor> acceptField) {
        if (!this.appliesToBase(baseType)) {
            return false;
        }
        for (SoyType type : SoyTypes.expandUnions(baseType)) {
            SoyProtoType protoType = (SoyProtoType)type;
            if (protoType.getFieldNames().contains((Object)fieldName) && acceptField.test(protoType.getFieldDescriptor(fieldName))) continue;
            return false;
        }
        return true;
    }

    private static String fieldToHasMethodName(String fieldName) {
        return "has" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
    }

    public static String protoFieldToGetMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
    }

    public static String protoFieldToGetAsStringMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + "_asString";
    }

    public static String protoFieldToGetAsLegacyNumberOrStringMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + "_asLegacyNumberOrString";
    }

    public static String protoFieldToGetReadonlyMethodName(String fieldName) {
        return "getReadonly" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
    }

    public static String fieldToGetOrUndefinedMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + "OrUndefined";
    }

    public static String fieldToGetOrUndefinedAsStringMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + "OrUndefined_asString";
    }

    public static String fieldToGetOrUndefinedAsLegacyNumberOrStringMethodName(String fieldName) {
        return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName) + "OrUndefined_asLegacyNumberOrString";
    }

    private BuiltinMethod(String name, int argCount) {
        this.name = name;
        this.argCount = argCount;
    }

    public String getMethodName() {
        return this.name;
    }

    public boolean appliesTo(String methodName, SoyType baseType) {
        return methodName.equals(this.name) && this.appliesToBase(baseType);
    }

    protected abstract boolean appliesToBase(SoyType var1);

    public abstract SoyType getReturnType(String var1, SoyType var2, List<ExprNode> var3, SoyTypeRegistry var4, ErrorReporter var5);

    public final SoyType getReturnType(MethodCallNode node, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
        String methodName = node.getMethodName().identifier();
        return this.getReturnType(methodName, node.getBaseType(true), node.getParams(), soyTypeRegistry, errorReporter);
    }

    @Override
    public int getNumArgs() {
        return this.argCount;
    }

    @Override
    public boolean appliesToArgs(List<SoyType> argTypes) {
        return argTypes.size() == this.getNumArgs();
    }

    ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
        return ImmutableList.of((Object)this.name);
    }

    public List<String> getProtoDependencyTypes(MethodCallNode methodNode) {
        switch (this) {
            case GET_EXTENSION: 
            case GET_READONLY_EXTENSION: 
            case HAS_EXTENSION: {
                return ImmutableList.of((Object)ProtoUtils.getQualifiedOuterClassname((Descriptors.GenericDescriptor)((SoyProtoType)SoyTypes.tryRemoveNullish(methodNode.getBaseExprChild().getType())).getFieldDescriptor(BuiltinMethod.getProtoExtensionIdFromMethodCall(methodNode))));
            }
            case HAS_PROTO_FIELD: 
            case GET_PROTO_FIELD: 
            case GET_PROTO_FIELD_OR_UNDEFINED: 
            case GET_READONLY_PROTO_FIELD: 
            case MAP_GET: 
            case BIND: {
                return ImmutableList.of();
            }
        }
        throw new AssertionError(this);
    }

    private static Optional<String> getGetReadonlyFieldName(String methodName) {
        if (!methodName.startsWith("getReadonly")) {
            return Optional.empty();
        }
        String suffix = methodName.substring("getReadonly".length());
        if (suffix.length() > 0 && !Ascii.isUpperCase((char)suffix.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, suffix));
    }

    private static Optional<String> getHasserFieldName(String methodName) {
        if (!methodName.startsWith("has")) {
            return Optional.empty();
        }
        String suffix = methodName.substring(3);
        if (suffix.length() > 0 && !Ascii.isUpperCase((char)suffix.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, suffix));
    }

    private static Optional<String> getGetterFieldName(String methodName) {
        if (methodName.length() <= 3) {
            return Optional.empty();
        }
        if (!methodName.startsWith("get") || methodName.endsWith("OrUndefined")) {
            return Optional.empty();
        }
        String suffix = methodName.substring(3);
        if (suffix.length() > 0 && !Ascii.isUpperCase((char)suffix.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, suffix));
    }

    private static Optional<String> getGetterAsStringFieldName(String methodName) {
        if (methodName.length() <= 3) {
            return Optional.empty();
        }
        if (!methodName.startsWith("get") || !methodName.endsWith("_asString") || methodName.endsWith("OrUndefined_asString")) {
            return Optional.empty();
        }
        String middle = methodName.substring(3, methodName.length() - "_asString".length());
        if (middle.length() > 0 && !Ascii.isUpperCase((char)middle.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, middle));
    }

    private static Optional<String> getGetterAsLegacyNumberOrStringFieldName(String methodName) {
        if (methodName.length() <= 3) {
            return Optional.empty();
        }
        if (!methodName.startsWith("get") || !methodName.endsWith("_asLegacyNumberOrString") || methodName.endsWith("OrUndefined_asLegacyNumberOrString")) {
            return Optional.empty();
        }
        String middle = methodName.substring(3, methodName.length() - "_asLegacyNumberOrString".length());
        if (middle.length() > 0 && !Ascii.isUpperCase((char)middle.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, middle));
    }

    private static Optional<String> getGetOrUndefinedFieldName(String methodName) {
        if (!methodName.startsWith("get") || !methodName.endsWith("OrUndefined")) {
            return Optional.empty();
        }
        String middle = methodName.substring(3, methodName.length() - "OrUndefined".length());
        if (middle.length() > 0 && !Ascii.isUpperCase((char)middle.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, middle));
    }

    private static Optional<String> getGetOrUndefinedAsStringFieldName(String methodName) {
        if (!methodName.startsWith("get") || !methodName.endsWith("OrUndefined_asString")) {
            return Optional.empty();
        }
        String middle = methodName.substring(3, methodName.length() - "OrUndefined_asString".length());
        if (middle.length() > 0 && !Ascii.isUpperCase((char)middle.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, middle));
    }

    private static Optional<String> getGetOrUndefinedAsLegacyNumberOrStringFieldName(String methodName) {
        if (!methodName.startsWith("get") || !methodName.endsWith("OrUndefined_asLegacyNumberOrString")) {
            return Optional.empty();
        }
        String middle = methodName.substring(3, methodName.length() - "OrUndefined_asLegacyNumberOrString".length());
        if (middle.length() > 0 && !Ascii.isUpperCase((char)middle.charAt(0))) {
            return Optional.empty();
        }
        return Optional.of(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, middle));
    }

    private static SoyType computeTypeForProtoFieldName(SoyType baseType, String fieldName, SoyTypeRegistry soyTypeRegistry) {
        return BuiltinMethod.computeTypeForProtoFieldName(baseType, fieldName, soyTypeRegistry, false);
    }

    private static SoyType computeTypeForProtoFieldName(SoyType baseType, String fieldName, SoyTypeRegistry soyTypeRegistry, boolean is64BitIntStringType) {
        ArrayList<SoyType> types = new ArrayList<SoyType>();
        for (SoyType type : SoyTypes.expandUnions(baseType)) {
            SoyType defaultType = ((SoyProtoType)type).getFieldType(fieldName);
            if (is64BitIntStringType) {
                defaultType = defaultType instanceof ListType ? soyTypeRegistry.getOrCreateListType(StringType.getInstance()) : StringType.getInstance();
            }
            types.add(defaultType);
        }
        return SoyTypes.computeLowestCommonType(soyTypeRegistry, types);
    }

    private static boolean isExtendableMessageType(SoyType baseType) {
        Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
        return baseType.getKind() == SoyType.Kind.PROTO && ((SoyProtoType)baseType).getDescriptor().isExtendable();
    }

    private static Optional<ProtoExtensionImportType> getExtensionType(SoyProtoType protoType, ExprNode param, ErrorReporter errorReporter) {
        String fieldName;
        if (param.getType().getKind() != SoyType.Kind.PROTO_EXTENSION) {
            if (param.getType().getKind() != SoyType.Kind.UNKNOWN) {
                errorReporter.report(param.getSourceLocation(), GET_EXTENSION_BAD_ARG, new Object[0]);
            }
            return Optional.empty();
        }
        ProtoExtensionImportType extType = (ProtoExtensionImportType)param.getType();
        ImmutableSet<String> fields = protoType.getExtensionFieldNames();
        if (!fields.contains((Object)(fieldName = extType.getFieldName()))) {
            String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, protoType.getDescriptor(), fieldName);
            errorReporter.report(param.getSourceLocation(), PROTO_EXTENSION_DOES_NOT_EXIST, fieldName, protoType.getDescriptor().getFullName(), extraErrorMessage);
            return Optional.empty();
        }
        return Optional.of(extType);
    }

    static {
        GET_EXTENSION_BAD_ARG = SoyErrorKind.of("The parameter of method ''getExtension'' must be an imported extension symbol.", new SoyErrorKind.StyleAllowance[0]);
        PROTO_EXTENSION_DOES_NOT_EXIST = SoyErrorKind.of("Proto extension ''{0}'' does not extend ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
        GET_READONLY_EXTENSION_MAY_ONLY_BE_CALLED_ON_MESSAGE_EXTENSIONS = SoyErrorKind.of("getReadonlyExtension may only be called on singular message extensions.", SoyErrorKind.StyleAllowance.NO_CAPS);
        HAS_EXTENSION_MAY_ONLY_BE_CALLED_ON_SINGULAR_EXTENSIONS = SoyErrorKind.of("hasExtension may only be called on singular extensions.", SoyErrorKind.StyleAllowance.NO_CAPS);
        BIND_PARAMETER_MUST_BE_RECORD_LITERAL = SoyErrorKind.of("Parameter to bind() must be a record literal.", new SoyErrorKind.StyleAllowance[0]);
        METHOD_INVALID_PARAM_TYPES = SoyErrorKind.of("Method ''{0}'' called with parameter types ({1}) but expected ({2}).", new SoyErrorKind.StyleAllowance[0]);
        EMPTY_MAP_ACCESS = SoyErrorKind.of("Accessing item in empty map.", new SoyErrorKind.StyleAllowance[0]);
        REGISTRY = new SoyMethod.Registry(){

            @Override
            public ImmutableList<? extends SoyMethod> matchForNameAndBase(String methodName, SoyType baseType) {
                return (ImmutableList)Arrays.stream(BuiltinMethod.values()).filter(m -> m.appliesTo(methodName, baseType)).collect(ImmutableList.toImmutableList());
            }

            public ImmutableListMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
                return (ImmutableListMultimap)Arrays.stream(BuiltinMethod.values()).filter(m -> m.appliesToBase(baseType) && m.appliesToArgs(argTypes)).collect(ImmutableListMultimap.flatteningToImmutableListMultimap(m -> m, m -> m.expandMethodNames(baseType, argTypes).stream()));
            }
        };
    }
}

