/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.passes.htmlmatcher.ActiveEdge;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HtmlMatcherAccumulatorNode
extends HtmlMatcherGraphNode {
    @Nullable
    private HtmlMatcherGraphNode nextNode = null;

    @Override
    public Optional<SoyNode> getSoyNode() {
        return Optional.empty();
    }

    @Override
    public Optional<HtmlMatcherGraphNode> getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        if (edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE) {
            return Optional.ofNullable(this.nextNode);
        }
        return Optional.empty();
    }

    @Override
    public void setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        throw new UnsupportedOperationException("Cannot set the edge kind of an Accumulator node.");
    }

    @Override
    public void linkEdgeToNode(HtmlMatcherGraphNode.EdgeKind edgeKind, HtmlMatcherGraphNode node) {
        Preconditions.checkState((edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE ? 1 : 0) != 0, (Object)"Accumulator nodes only have a true branch.");
        Preconditions.checkState((!this.equals(node) ? 1 : 0) != 0, (Object)"Can't link a node to itsself.");
        this.nextNode = node;
    }

    public void accumulateActiveEdges(ImmutableList<ActiveEdge> activeEdges) {
        for (ActiveEdge accEdge : activeEdges) {
            accEdge.getGraphNode().linkEdgeToNode(accEdge.getActiveEdge(), this);
        }
    }
}

