/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;

final class VeRewritePass
implements CompilerFilePass {
    VeRewritePass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (VeLogNode node : SoyTreeUtils.getAllNodesOfType(file, VeLogNode.class)) {
            this.maybeRewriteVeLogNode(node);
        }
        SoyTreeUtils.allFunctionInvocations(file, BuiltinFunction.VE_DATA).forEach(this::maybeRewriteVeDataNode);
    }

    private void maybeRewriteVeLogNode(VeLogNode node) {
        if (node.getVeDataExpression().getRoot().getKind() == ExprNode.Kind.GLOBAL_NODE) {
            GlobalNode veName = (GlobalNode)node.getVeDataExpression().getRoot();
            FunctionNode veData = FunctionNode.newPositional(Identifier.create(BuiltinFunction.VE_DATA.getName(), veName.getSourceLocation()), BuiltinFunction.VE_DATA, veName.getSourceLocation());
            veData.addChild(veName);
            node.getVeDataExpression().addChild(veData);
        }
    }

    private void maybeRewriteVeDataNode(FunctionNode node) {
        if (node.numParams() < 1 || node.numParams() > 2) {
            return;
        }
        if (node.numParams() < 2) {
            node.addChild(new NullNode(node.getSourceLocation().getEndLocation()));
        }
    }
}

