/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.primitives.Primitives;
import com.google.protobuf.Message;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.plugin.java.ReadMethodData;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.JavaImplNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@RunBefore(value={ResolveExpressionTypesPass.class})
class ValidateExternsPass
implements CompilerFilePass {
    private static final SoyErrorKind ATTRIBUTE_REQUIRED = SoyErrorKind.of("Attribute ''{0}'' is required.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNKNOWN_TYPE = SoyErrorKind.of("Type ''{0}'' not loaded.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ARITY_MISMATCH = SoyErrorKind.of("Implementation must match extern signature with {0} parameter(s).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_PARAM_TYPE = SoyErrorKind.of("Soy type ''{1}'' is not coercible to Java type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_RETURN_TYPE = SoyErrorKind.of("Java type ''{0}'' is not coercible to Soy type ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OVERLOAD_RETURN_CONFLICT = SoyErrorKind.of("Overloaded extern must have the same return type as the earlier extern defined on {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OVERLOAD_PARAM_CONFLICT = SoyErrorKind.of("Overloaded extern parameters are ambiguous with the earlier extern defined on {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind JS_IMPL_OVERLOADS_MUST_MATCH = SoyErrorKind.of("Overloads for the same extern symbol must have the same jsimpl.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_JAVA_CLASS = SoyErrorKind.of("Java implementation class not loaded.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_PUBLIC = SoyErrorKind.of("Both the Java class and method must be public.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_JAVA_METHOD_NAME = SoyErrorKind.of("No method ''{0}'' exists on implementation class.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind JAVA_METHOD_SIG_MISMATCH = SoyErrorKind.of("Method ''{0}'' of implementation class does not match the provided arguments. Available signatures: {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind JAVA_METHOD_TYPE_MISMATCH = SoyErrorKind.of("Attribute ''type'' should have value ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind JAVA_METHOD_RETURN_TYPE_MISMATCH = SoyErrorKind.of("Return type of method ''{0}'' must be one of [{1}].", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPLICIT_PARAM_ORDER = SoyErrorKind.of("Implicit Java parameter {0} must come at the end of the parameter list.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSetMultimap<String, String> ALLOWED_VE_EXTERNS = ImmutableSetMultimap.of();
    private final ErrorReporter errorReporter;
    private final MethodChecker checker;
    private final boolean validateJavaMethods;
    private static final ImmutableSet<String> IMPLICIT_PARAMS = ImmutableSet.of((Object)"com.google.template.soy.data.Dir", (Object)"com.google.template.soy.plugin.java.RenderCssHelper", (Object)"com.ibm.icu.util.ULocale");
    private static final ImmutableSet<SoyType.Kind> ALLOWED_PARAMETERIZED_TYPES = ImmutableSet.of((Object)((Object)SoyType.Kind.INT), (Object)((Object)SoyType.Kind.FLOAT), (Object)((Object)SoyType.Kind.STRING), (Object)((Object)SoyType.Kind.BOOL), (Object)((Object)SoyType.Kind.PROTO), (Object)((Object)SoyType.Kind.PROTO_ENUM), (Object[])new SoyType.Kind[0]);
    private static final ImmutableSet<SoyType.Kind> ALLOWED_UNION_MEMBERS = ImmutableSet.builder().addAll(ALLOWED_PARAMETERIZED_TYPES).add((Object)SoyType.Kind.HTML).add((Object)SoyType.Kind.TRUSTED_RESOURCE_URI).add((Object)SoyType.Kind.URI).build();
    private static final ImmutableSet<SoyType.Kind> ALLOWED_RECORD_MEMBERS = ImmutableSet.builder().addAll(ALLOWED_UNION_MEMBERS).add((Object)SoyType.Kind.CSS).add((Object)SoyType.Kind.ANY).add((Object)SoyType.Kind.UNKNOWN).build();

    ValidateExternsPass(ErrorReporter errorReporter, MethodChecker checker, boolean validateJavaMethods) {
        this.errorReporter = errorReporter;
        this.checker = checker;
        this.validateJavaMethods = validateJavaMethods;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        ListMultimap externIndex = (ListMultimap)file.getExterns().stream().collect(ImmutableListMultimap.toImmutableListMultimap(e -> e.getIdentifier().identifier(), e -> e));
        for (Map.Entry entry : externIndex.asMap().entrySet()) {
            this.validateNamedExterns((List)entry.getValue());
        }
    }

    private void validateNamedExterns(List<ExternNode> externs) {
        for (ExternNode extern : externs) {
            extern.getJavaImpl().ifPresent(java -> this.validateJava(extern, (JavaImplNode)java));
            extern.getJsImpl().ifPresent(this::validateJs);
        }
        for (int i = 1; i < externs.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                ExternNode first = externs.get(j);
                ExternNode second = externs.get(i);
                FunctionType type1 = first.getType();
                FunctionType type2 = second.getType();
                if (type1.getReturnType() != type2.getReturnType()) {
                    this.errorReporter.report(second.typeNode().sourceLocation(), OVERLOAD_RETURN_CONFLICT, first.getSourceLocation().toLineColumnString());
                } else if (type1.getParameters().size() == type2.getParameters().size() && (type1.isAssignableFromLoose(type2) || type2.isAssignableFromLoose(type1))) {
                    this.errorReporter.report(second.typeNode().sourceLocation(), OVERLOAD_PARAM_CONFLICT, first.getSourceLocation().toLineColumnString());
                }
                if (this.jsImplsEqual(first.getJsImpl(), second.getJsImpl())) continue;
                this.errorReporter.report(second.typeNode().sourceLocation(), JS_IMPL_OVERLOADS_MUST_MATCH, new Object[0]);
            }
        }
    }

    private boolean jsImplsEqual(Optional<JsImplNode> first, Optional<JsImplNode> second) {
        boolean moduleEquals = first.map(JsImplNode::module).equals(second.map(JsImplNode::module));
        boolean functionEquals = first.map(JsImplNode::function).equals(second.map(JsImplNode::function));
        return moduleEquals && functionEquals;
    }

    private void validateJava(ExternNode extern, JavaImplNode java) {
        int i;
        int requiredParamCount = extern.getType().getParameters().size();
        if (Strings.isNullOrEmpty((String)java.className())) {
            this.errorReporter.report(java.getSourceLocation(), ATTRIBUTE_REQUIRED, "class");
        }
        if (Strings.isNullOrEmpty((String)java.methodName())) {
            this.errorReporter.report(java.getSourceLocation(), ATTRIBUTE_REQUIRED, "method");
        }
        if (Strings.isNullOrEmpty((String)java.returnType())) {
            this.errorReporter.report(java.getSourceLocation(), ATTRIBUTE_REQUIRED, "return");
        } else {
            this.validateTypes(java.returnType(), extern.getType().getReturnType(), INCOMPATIBLE_RETURN_TYPE, () -> java.getAttributeValueLocation("return"), extern, Mode.EXTENDS);
        }
        ArrayList<String> paramTypes = new ArrayList<String>((Collection<String>)java.params());
        boolean inTail = true;
        for (i = paramTypes.size() - 1; i >= 0; --i) {
            if (IMPLICIT_PARAMS.contains(paramTypes.get(i))) {
                paramTypes.remove(i);
                if (inTail) continue;
                this.errorReporter.report(java.getAttributeValueLocation("params"), IMPLICIT_PARAM_ORDER, paramTypes.get(i));
                continue;
            }
            inTail = false;
        }
        if (paramTypes.size() != requiredParamCount) {
            this.errorReporter.report(java.getAttributeValueLocation("params"), ARITY_MISMATCH, requiredParamCount);
        } else {
            for (i = 0; i < paramTypes.size(); ++i) {
                String paramType = (String)paramTypes.get(i);
                this.validateTypes(paramType, ((FunctionType.Parameter)extern.getType().getParameters().get(i)).getType(), INCOMPATIBLE_PARAM_TYPE, () -> java.getAttributeValueLocation("params"), extern, Mode.SUPER);
            }
        }
        if (!this.validateJavaMethods) {
            return;
        }
        MethodChecker.Response response = this.checker.findMethod(java.className(), java.methodName(), java.returnType(), (List<String>)java.params());
        switch (response.getCode()) {
            case EXISTS: {
                ReadMethodData method = response.getMethod();
                if (method.instanceMethod() != java.isStatic() && method.classIsInterface() == java.isInterface()) break;
                String actualType = method.instanceMethod() ? (method.classIsInterface() ? "interface" : "instance") : (method.classIsInterface() ? "static_interface" : "static");
                SourceLocation loc = java.getAttributeValueLocation("type");
                if (loc.equals(SourceLocation.UNKNOWN)) {
                    loc = java.getSourceLocation();
                }
                this.errorReporter.report(loc, JAVA_METHOD_TYPE_MISMATCH, actualType);
                break;
            }
            case NO_SUCH_CLASS: {
                this.errorReporter.report(java.getAttributeValueLocation("class"), NO_SUCH_JAVA_CLASS, new Object[0]);
                break;
            }
            case NOT_PUBLIC: {
                this.errorReporter.report(java.getAttributeValueLocation("method"), NOT_PUBLIC, new Object[0]);
                break;
            }
            case NO_SUCH_METHOD_SIG: {
                this.errorReporter.report(java.getAttributeValueLocation("params"), JAVA_METHOD_SIG_MISMATCH, java.methodName(), String.join((CharSequence)", ", response.getSuggesions()));
                break;
            }
            case NO_SUCH_RETURN_TYPE: {
                this.errorReporter.report(java.getAttributeValueLocation("return"), JAVA_METHOD_RETURN_TYPE_MISMATCH, java.methodName(), String.join((CharSequence)", ", response.getSuggesions()));
                break;
            }
            case NO_SUCH_METHOD_NAME: {
                String didYouMean = SoyErrors.getDidYouMeanMessage(response.getSuggesions(), java.methodName());
                this.errorReporter.report(java.getAttributeValueLocation("method"), NO_SUCH_JAVA_METHOD_NAME, java.methodName(), didYouMean);
            }
        }
    }

    private void validateTypes(String javaTypeName, SoyType soyType, SoyErrorKind compatibleErrorKind, Supplier<SourceLocation> loc, ExternNode extern, Mode mode) {
        Class<?> javaType = ValidateExternsPass.getType(javaTypeName);
        if (javaType != null) {
            if (!ValidateExternsPass.typesAreCompatible(javaType, soyType, extern, mode)) {
                this.errorReporter.report(loc.get(), compatibleErrorKind, javaType.getName(), soyType);
            }
        } else if (!ValidateExternsPass.protoTypesAreCompatible(javaTypeName, soyType)) {
            this.errorReporter.report(loc.get(), UNKNOWN_TYPE, javaTypeName);
        }
    }

    private void validateJs(JsImplNode jsImplNode) {
    }

    @Nullable
    private static Class<?> getType(String typeName) {
        try {
            return MethodSignature.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean typesAreCompatible(Class<?> javaType, SoyType soyType, ExternNode extern, Mode mode) {
        boolean nullable = SoyTypes.isNullish(soyType);
        boolean isPrimitive = Primitives.allPrimitiveTypes().contains(javaType);
        if (nullable && isPrimitive) {
            return false;
        }
        soyType = SoyTypes.tryRemoveNullish(soyType);
        javaType = Primitives.wrap(javaType);
        switch (soyType.getKind()) {
            case INT: {
                return javaType == Integer.class || javaType == Long.class;
            }
            case FLOAT: {
                return javaType == Double.class || javaType == Float.class;
            }
            case STRING: {
                return javaType == String.class;
            }
            case BOOL: {
                return javaType == Boolean.class;
            }
            case UNION: {
                if (soyType.equals(SoyTypes.NUMBER_TYPE)) {
                    return javaType == Number.class || javaType == Double.class;
                }
                if (((UnionType)soyType).getMembers().stream().anyMatch(t -> !ALLOWED_UNION_MEMBERS.contains((Object)t.getKind()))) {
                    return false;
                }
            }
            case ANY: 
            case UNKNOWN: {
                return javaType == Object.class || javaType == SoyValue.class;
            }
            case LIST: {
                if (!ValidateExternsPass.isAllowedParameterizedType(((ListType)soyType).getElementType(), extern)) {
                    return false;
                }
                return mode == Mode.EXTENDS ? Iterable.class.isAssignableFrom(javaType) : !javaType.equals(Object.class) && javaType.isAssignableFrom(ImmutableList.class);
            }
            case MAP: {
                MapType mapType = (MapType)soyType;
                if (!ALLOWED_PARAMETERIZED_TYPES.contains((Object)mapType.getKeyType().getKind()) || !ALLOWED_PARAMETERIZED_TYPES.contains((Object)mapType.getValueType().getKind())) {
                    return false;
                }
                return mode == Mode.EXTENDS ? Map.class.isAssignableFrom(javaType) : javaType == Map.class || javaType == ImmutableMap.class;
            }
            case RECORD: {
                RecordType recordType = (RecordType)soyType;
                if (!recordType.getMembers().stream().map(m -> (m.optional() ? SoyTypes.tryRemoveNull(m.declaredType()) : m.declaredType()).getKind()).allMatch(arg_0 -> ALLOWED_RECORD_MEMBERS.contains(arg_0))) {
                    return false;
                }
                return mode == Mode.EXTENDS ? Map.class.isAssignableFrom(javaType) : javaType == Map.class || javaType == ImmutableMap.class;
            }
            case MESSAGE: {
                return mode == Mode.EXTENDS ? Message.class.isAssignableFrom(javaType) : javaType == Message.class;
            }
            case URI: {
                return javaType == SafeUrl.class || javaType == SafeUrlProto.class;
            }
            case TRUSTED_RESOURCE_URI: {
                return javaType == TrustedResourceUrl.class || javaType == TrustedResourceUrlProto.class;
            }
            case ATTRIBUTES: {
                return javaType == SanitizedContent.class;
            }
            case HTML: {
                return javaType == SafeHtml.class || javaType == SafeHtmlProto.class;
            }
            case PROTO: {
                SoyProtoType protoType = (SoyProtoType)soyType;
                return JavaQualifiedNames.getClassName(protoType.getDescriptor()).equals(javaType.getName());
            }
            case PROTO_ENUM: {
                SoyProtoEnumType protoEnumType = (SoyProtoEnumType)soyType;
                return JavaQualifiedNames.getClassName(protoEnumType.getDescriptor()).equals(javaType.getName());
            }
            case VE: {
                return ValidateExternsPass.isAllowedVeExtern(extern) && javaType == SoyVisualElement.class;
            }
        }
        return false;
    }

    private static boolean isAllowedParameterizedType(SoyType type, ExternNode extern) {
        return ALLOWED_PARAMETERIZED_TYPES.contains((Object)type.getKind()) || SoyTypes.NUMBER_TYPE.equals(type);
    }

    private static boolean isAllowedVeExtern(ExternNode extern) {
        return ALLOWED_VE_EXTERNS.containsEntry((Object)extern.getSourceLocation().getFilePath().path(), (Object)extern.getIdentifier().identifier());
    }

    private static boolean protoTypesAreCompatible(String javaType, SoyType soyType) {
        soyType = SoyTypes.tryRemoveNullish(soyType);
        switch (soyType.getKind()) {
            case PROTO: {
                SoyProtoType protoType = (SoyProtoType)soyType;
                return JavaQualifiedNames.getClassName(protoType.getDescriptor()).equals(javaType);
            }
            case PROTO_ENUM: {
                SoyProtoEnumType protoEnumType = (SoyProtoEnumType)soyType;
                return JavaQualifiedNames.getClassName(protoEnumType.getDescriptor()).equals(javaType);
            }
        }
        return false;
    }

    private static enum Mode {
        EXTENDS,
        SUPER;

    }
}

