/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import java.util.Map;
import javax.annotation.Nullable;

final class TypeSubstitutions {
    private final ExprEquivalence exprEquivalence;
    private Vector substitutions;

    public TypeSubstitutions(ExprEquivalence exprEquivalence) {
        this.exprEquivalence = exprEquivalence;
    }

    void addAll(Map<ExprEquivalence.Wrapper, SoyType> substitutionsToAdd) {
        for (Map.Entry<ExprEquivalence.Wrapper, SoyType> entry : substitutionsToAdd.entrySet()) {
            ExprNode expr = entry.getKey().get();
            SoyType previousType = expr.getType();
            Vector subst = this.substitutions;
            while (subst != null) {
                if (this.exprEquivalence.equivalent(subst.expression, expr)) {
                    previousType = subst.type;
                    break;
                }
                subst = subst.parent;
            }
            if (entry.getValue().equals(previousType)) continue;
            this.substitutions = new Vector(this.substitutions, expr, entry.getValue());
        }
    }

    @Nullable
    SoyType getTypeSubstitution(ExprNode expr) {
        Vector subst = this.substitutions;
        while (subst != null) {
            if (this.exprEquivalence.equivalent(subst.expression, expr)) {
                return subst.type;
            }
            subst = subst.parent;
        }
        return null;
    }

    Checkpoint checkpoint() {
        return new Checkpoint(this.substitutions);
    }

    void restore(Checkpoint checkpoint) {
        this.substitutions = checkpoint.vector;
    }

    private static final class Vector {
        @Nullable
        final Vector parent;
        final ExprNode expression;
        final SoyType type;

        Vector(@Nullable Vector parent, ExprNode expression, SoyType type) {
            this.parent = parent;
            this.expression = expression;
            this.type = type;
        }
    }

    static class Checkpoint {
        private final Vector vector;

        public Checkpoint(Vector vector) {
            this.vector = vector;
        }
    }
}

