/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

@RunBefore(value={CheckGlobalsPass.class})
final class RewriteGlobalsPass
implements CompilerFilePass {
    RewriteGlobalsPass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, GlobalNode.class).forEach(global -> this.resolveGlobal(file, (GlobalNode)global));
    }

    private void resolveGlobal(SoyFileNode file, GlobalNode global) {
        Identifier original = global.getIdentifier();
        Identifier alias = file.resolveAlias(global.getIdentifier());
        if (!alias.equals(original)) {
            global.resolve(alias.identifier());
        }
    }
}

