/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FileDependencyOrderPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.SoyFileNode;

@RunAfter(value={FileDependencyOrderPass.class})
class ModernFeatureInvariantsEnforcementPass
implements CompilerFileSetPass {
    private static final SoyErrorKind UNIQUE_NS_REQUIRED = SoyErrorKind.of("Feature {0} is only allowed in files with unique namespaces.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public ModernFeatureInvariantsEnforcementPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        boolean error = false;
        for (SoyFileNode file : sourceFiles) {
            ImmutableList<ExternNode> externs;
            if (!NamespaceExemptions.isKnownDuplicateNamespace(file.getNamespace())) continue;
            ImmutableList<ConstNode> constants = file.getConstants();
            if (!constants.isEmpty()) {
                error = true;
                constants.forEach(c -> this.errorReporter.report(c.getSourceLocation(), UNIQUE_NS_REQUIRED, "{const}"));
            }
            if ((externs = file.getExterns()).isEmpty()) continue;
            error = true;
            externs.forEach(c -> this.errorReporter.report(c.getSourceLocation(), UNIQUE_NS_REQUIRED, "{extern}"));
        }
        return error ? CompilerFileSetPass.Result.STOP : CompilerFileSetPass.Result.CONTINUE;
    }
}

