/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.SanitizedType;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;

final class IncrementalDomKeysPass
implements CompilerFilePass {
    private final boolean disableAllTypeChecking;

    public IncrementalDomKeysPass(boolean disableAllTypeChecking) {
        this.disableAllTypeChecking = disableAllTypeChecking;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new IncrementalDomKeysPassVisitor(this.disableAllTypeChecking).exec(file);
    }

    private static final class IncrementalDomKeysPassVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private ArrayDeque<AtomicInteger> keyCounterStack;
        private ArrayDeque<Boolean> htmlKeyStack;
        private TemplateNode template;
        private boolean mustEmitKeyNodes = false;
        private boolean templateContainsUnpredictableContent = false;
        private final boolean disableAllTypeChecking;

        public IncrementalDomKeysPassVisitor(boolean disableAllTypeChecking) {
            this.disableAllTypeChecking = disableAllTypeChecking;
        }

        @Override
        public void visitTemplateNode(TemplateNode templateNode) {
            this.htmlKeyStack = new ArrayDeque();
            this.keyCounterStack = new ArrayDeque();
            this.keyCounterStack.push(new AtomicInteger());
            this.template = templateNode;
            this.templateContainsUnpredictableContent = false;
            this.visitBlockNode(templateNode);
        }

        private void visitBlockNode(SoyNode.ParentSoyNode<?> node) {
            this.mustEmitKeyNodes = true;
            this.visitChildren(node);
        }

        @Override
        public void visitPrintNode(PrintNode node) {
            if (!this.disableAllTypeChecking && node.getExpr().getRoot().getType().isAssignableFromStrict(SanitizedType.HtmlType.getInstance())) {
                this.mustEmitKeyNodes = true;
                this.htmlKeyStack.push(true);
            }
        }

        @Override
        public void visitLetContentNode(LetContentNode node) {
            boolean oldMustEmitKeyNodes = this.mustEmitKeyNodes;
            this.mustEmitKeyNodes = true;
            this.visitChildren(node);
            this.mustEmitKeyNodes = oldMustEmitKeyNodes;
        }

        @Override
        public void visitSoyNode(SoyNode node) {
            boolean isHtmlContextBlock;
            boolean isTemplateNode = node instanceof TemplateNode || node instanceof VeLogNode;
            boolean bl = isHtmlContextBlock = node instanceof HtmlContext.HtmlContextHolder && node instanceof SoyNode.ParentSoyNode && (this.disableAllTypeChecking || ((HtmlContext.HtmlContextHolder)((Object)node)).getHtmlContext() == HtmlContext.HTML_PCDATA);
            if (isTemplateNode || isHtmlContextBlock) {
                this.visitBlockNode((SoyNode.ParentSoyNode)node);
                return;
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        public void visitHtmlOpenTagNode(HtmlOpenTagNode openTagNode) {
            KeyNode keyNode = openTagNode.getKeyNode();
            if (!openTagNode.isSelfClosing()) {
                boolean bl = this.templateContainsUnpredictableContent = this.templateContainsUnpredictableContent || openTagNode.hasUnpredictableTagLocation();
            }
            if (keyNode != null) {
                this.keyCounterStack.push(new AtomicInteger());
            } else {
                openTagNode.setIsDynamic(this.mustEmitKeyNodes || this.templateContainsUnpredictableContent || openTagNode.isSkipRoot());
                openTagNode.setKeyId(this.incrementKeyForTemplate(this.template, openTagNode.isElementRoot()));
            }
            this.visitChildren(openTagNode);
            this.htmlKeyStack.push(this.mustEmitKeyNodes);
            this.mustEmitKeyNodes = false;
        }

        @Override
        public void visitHtmlCloseTagNode(HtmlCloseTagNode closeTagNode) {
            if (closeTagNode.getTaggedPairs().size() == 1) {
                HtmlOpenTagNode openTag = (HtmlOpenTagNode)closeTagNode.getTaggedPairs().get(0);
                if (openTag.getKeyNode() != null && !(openTag.getParent() instanceof SkipNode)) {
                    this.keyCounterStack.pop();
                }
                if (!this.htmlKeyStack.isEmpty()) {
                    this.mustEmitKeyNodes = this.htmlKeyStack.pop();
                }
            }
        }

        private String incrementKeyForTemplate(TemplateNode template, boolean isElementRoot) {
            if (isElementRoot) {
                return template.getTemplateName() + "-root";
            }
            AtomicInteger keyCounter = this.keyCounterStack.peek();
            return template.getTemplateName() + "-" + keyCounter.getAndIncrement();
        }
    }
}

