/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.util.TopoSort;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@RunAfter(value={ImportsPass.class})
public class FileDependencyOrderPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CYCLE = SoyErrorKind.of("Dependency cycle between source files:\n{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;
    private final Consumer<ImmutableList<SoyFileNode>> stateSetter;

    public FileDependencyOrderPass(ErrorReporter errorReporter, Consumer<ImmutableList<SoyFileNode>> stateSetter) {
        this.errorReporter = errorReporter;
        this.stateSetter = stateSetter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> files, IdGenerator idGenerator) {
        if (files.size() < 2) {
            this.stateSetter.accept(files);
            return CompilerFileSetPass.Result.CONTINUE;
        }
        Map filesByPath = (Map)files.stream().collect(ImmutableMap.toImmutableMap(fn -> fn.getFilePath().path(), fn -> fn));
        TopoSort<SoyFileNode> sorter = new TopoSort<SoyFileNode>();
        try {
            ImmutableList<SoyFileNode> sorted = sorter.sort((Iterable<SoyFileNode>)files, (Function<SoyFileNode, Iterable<SoyFileNode>>)((Function<SoyFileNode, Iterable>)fn -> fn.getImports().stream().map(ImportNode::getPath).map(filesByPath::get).filter(Objects::nonNull).collect(Collectors.toSet())));
            this.stateSetter.accept(sorted);
            return CompilerFileSetPass.Result.CONTINUE;
        }
        catch (NoSuchElementException e) {
            String cycleText = sorter.getCyclicKeys().stream().map(fn -> fn.getFilePath().path()).collect(Collectors.joining("\n--> "));
            this.errorReporter.report(SourceLocation.UNKNOWN, CYCLE, cycleText);
            return CompilerFileSetPass.Result.STOP;
        }
    }
}

