/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basicfunctions.BasicFunctions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.MoreCallValidationsPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyElementCompositionPass;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.treebuilder.ExprNodes;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.ast.NamedTypeNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RunAfter(value={ResolveNamesPass.class, ResolveTemplateParamTypesPass.class, SoyElementPass.class})
@RunBefore(value={FinalizeTemplateRegistryPass.class, SoyElementCompositionPass.class, AutoescaperPass.class})
final class ElementAttributePass
implements CompilerFileSetPass {
    private static final SoyErrorKind DELTEMPLATE_USING_ELEMENT_CONTENT_KIND = SoyErrorKind.of("Deltemplates cannot set kind=\"html<...>\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNUSED_ATTRIBUTE = SoyErrorKind.of("Declared @attribute unused in template element.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_USED_OUTSIDE_OF_TAG = SoyErrorKind.of("Attributes may not be referenced explicitly.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNRECOGNIZED_ATTRIBUTE = SoyErrorKind.of("''{0}'' is not a declared @attribute of the template.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PLAIN_ATTRIBUTE = SoyErrorKind.of("HTML attribute masks Soy attribute. Did you mean ''{0}''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_NOT_REQUIRED = SoyErrorKind.of("@attribute ''{0}'' must be set as optional to be used here.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_PARAM_NOT_ALLOWED = SoyErrorKind.of("Attribute ''{0}'' can only be present on root elements of html<?> templates.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_ATTRIBUTE_TYPE = SoyErrorKind.of("Attributes must be of type string or a sanitized type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_TAG_KIND_MISMATCH = SoyErrorKind.of("Expected root tag to be {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELEGATE_KIND_MISMATCH = SoyErrorKind.of("Expected the called template to have root tag {0}, found {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_STAR_AND_EXPLICIT = SoyErrorKind.of("Cannot specify a param named ''{0}'' along with ''attribute *''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXTRA_ROOT_ELEMENT_ATTRIBUTES_TYPE = SoyErrorKind.of("Param ''{0}'' must be optional and of type 'attributes'.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> templateRegistryFromDeps;
    private final boolean desugarIdomPasses;
    private static final ImmutableSet<String> CONCATENATED_ATTRIBUTES = ImmutableSet.of((Object)"@class", (Object)"@style", (Object)"@jsdata", (Object)"@jsaction", (Object)"@jsmodel");

    ElementAttributePass(ErrorReporter errorReporter, Supplier<FileSetMetadata> templateRegistryFromDeps, boolean desugarIdomPasses) {
        this.errorReporter = errorReporter;
        this.templateRegistryFromDeps = templateRegistryFromDeps;
        this.desugarIdomPasses = desugarIdomPasses;
    }

    private static ExprNode buildNotNull(ExprNode node) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        OperatorNodes.NotEqualOpNode ne = new OperatorNodes.NotEqualOpNode(unknown, unknown);
        ne.addChild(node.copy(new CopyState()));
        ne.addChild(new NullNode(unknown));
        ne.setType(BoolType.getInstance());
        return ne;
    }

    private static IfNode buildPrintIfNotNull(ExprNode node, Supplier<Integer> id) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        IfNode ifNode = new IfNode(id.get(), unknown);
        IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull(node));
        ifCondNode.getExpr().setType(BoolType.getInstance());
        ifNode.addChild(ifCondNode);
        PrintNode printNode = new PrintNode(id.get(), unknown, true, node, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        printNode.getExpr().setType(node.getType());
        ifCondNode.addChild(printNode);
        return ifNode;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        ImmutableMap allAstElements = (ImmutableMap)sourceFiles.stream().flatMap(fn -> fn.getTemplates().stream()).filter(t -> !(t instanceof TemplateDelegateNode) && t.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind && t.getHtmlElementMetadata() != null).collect(ImmutableMap.toImmutableMap(TemplateNode::getTemplateName, t -> t));
        for (SoyFileNode file : sourceFiles) {
            this.run(file, (ImmutableMap<String, TemplateNode>)allAstElements, idGenerator);
        }
        this.checkRootElementTagNames((ImmutableCollection<TemplateNode>)allAstElements.values());
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void run(SoyFileNode file, ImmutableMap<String, TemplateNode> allAstElements, IdGenerator nodeIdGen) {
        this.checkAttributeTypes(file);
        ImmutableList.Builder delegatingElementsWithAllAttrs = ImmutableList.builder();
        file.getTemplates().stream().filter(t -> t.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind && t.getHtmlElementMetadata() != null).forEach(t -> {
            if (t instanceof TemplateDelegateNode) {
                this.errorReporter.report(t.getOpenTagLocation(), DELTEMPLATE_USING_ELEMENT_CONTENT_KIND, new Object[0]);
                return;
            }
            this.processTemplate((TemplateNode)t, nodeIdGen::genId, arg_0 -> ((ImmutableList.Builder)delegatingElementsWithAllAttrs).add(arg_0));
        });
        file.getTemplates().stream().filter(t -> t.getHtmlElementMetadata() != null && ElementAttributePass.getDelegateCall(t).isEmpty()).forEach(t -> SoyTreeUtils.allNodesOfType(t, HtmlAttributeNode.class).filter(HtmlAttributeNode::isSoyAttr).forEach(attr -> this.errorReporter.report(attr.getSourceLocation(), ATTRIBUTE_PARAM_NOT_ALLOWED, attr.getStaticKey())));
        this.updateReservedAttributesForDelegateCalls((ImmutableList<TemplateNode>)delegatingElementsWithAllAttrs.build(), allAstElements);
    }

    private void checkAttributeTypes(SoyFileNode file) {
        file.getTemplates().stream().flatMap(t -> t.getHeaderParams().stream()).filter(AttrParam.class::isInstance).map(AttrParam.class::cast).forEach(attr -> {
            SoyType type = SoyTypes.tryRemoveNullish(attr.type());
            if (!(type instanceof SanitizedType) && !(type instanceof StringType) || SanitizedType.HtmlType.getInstance().isAssignableFromStrict(type)) {
                this.errorReporter.report(attr.getSourceLocation(), BAD_ATTRIBUTE_TYPE, new Object[0]);
            }
        });
    }

    private void processTemplate(TemplateNode templateNode, Supplier<Integer> id, Consumer<TemplateNode> delegatingElementsWithAllAttrs) {
        ImmutableMap attrs = (ImmutableMap)templateNode.getAllParams().stream().filter(AttrParam.class::isInstance).map(AttrParam.class::cast).collect(ImmutableMap.toImmutableMap(AttrParam::getAttrName, Function.identity()));
        HashSet<AttrParam> unseenParams = new HashSet<AttrParam>((Collection<AttrParam>)attrs.values());
        this.checkAttributeRefs(templateNode, unseenParams);
        HtmlOpenTagNode openTagNode = ElementAttributePass.getElementOpen(templateNode);
        if (openTagNode == null) {
            return;
        }
        SourceLocation unknown = templateNode.getSourceLocation().clearRange();
        String delegateTemplateName = ElementAttributePass.getDelegateCall(templateNode);
        boolean iAmAnElementCallingAnElement = !delegateTemplateName.isEmpty();
        ImmutableSet.Builder foundNormalAttr = ImmutableSet.builder();
        SoyTreeUtils.allNodesOfType(openTagNode, HtmlAttributeNode.class).filter(attr -> attr.getStaticKey() != null).forEach(attrNode -> {
            String attrName;
            String attrKey = attrNode.getStaticKey();
            if (attrKey.equals("data-debug-soy")) {
                return;
            }
            boolean isSoyAttr = attrNode.isSoyAttr();
            String string = attrName = isSoyAttr ? attrKey.substring(1) : attrKey;
            if (!isSoyAttr) {
                foundNormalAttr.add((Object)attrName);
                if (attrs.containsKey((Object)attrName)) {
                    this.errorReporter.report(attrNode.getSourceLocation(), PLAIN_ATTRIBUTE, "@" + attrName);
                }
                return;
            }
            if (!attrs.containsKey((Object)attrName)) {
                String didYouMeanMessage = SoyErrors.getDidYouMeanMessage((Iterable<String>)attrs.keySet(), attrName);
                this.errorReporter.report(attrNode.getSourceLocation(), UNRECOGNIZED_ATTRIBUTE, attrName, didYouMeanMessage);
                return;
            }
            AttrParam attr = (AttrParam)attrs.get((Object)attrName);
            if (!TemplateType.Parameter.isValidAttrName(attrName)) {
                this.errorReporter.report(attr.getSourceLocation(), MoreCallValidationsPass.BAD_ATTRIBUTE_NAME, new Object[0]);
            }
            unseenParams.remove(attr);
            if (attrNode.hasValue() && attr.isRequired()) {
                this.errorReporter.report(attrNode.getSourceLocation(), ATTRIBUTE_NOT_REQUIRED, attr.getAttrName());
            }
            attrNode.getParent().replaceChild(attrNode, !this.isConcatenatedAttribute((HtmlAttributeNode)attrNode) || !attrNode.hasValue() ? this.noConcatRewrite((HtmlAttributeNode)attrNode, attr, id, unknown) : this.concatRewrite(openTagNode, (HtmlAttributeNode)attrNode, attr, id, unknown));
        });
        NamedTypeNode typeNode = NamedTypeNode.create(unknown, "string");
        typeNode.setResolvedType(StringType.getInstance());
        TemplateParam keyParam = new TemplateParam("ssk", unknown, unknown, typeNode, false, true, true, "Created by ElementAttributePass.", null);
        keyParam.setType(SoyTypes.makeUndefinable(StringType.getInstance()));
        templateNode.addParam(keyParam);
        if (this.desugarIdomPasses && openTagNode.getTagName().isStatic()) {
            ExprNode.ParentExprNode result;
            Object keyParamRef = new VarRefNode("$" + keyParam.name(), SourceLocation.UNKNOWN, keyParam);
            IfNode ifNode = new IfNode(id.get(), unknown);
            IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull((ExprNode)keyParamRef));
            ifCondNode.getExpr().setType(BoolType.getInstance());
            ifNode.addChild(ifCondNode);
            HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(id.get(), SourceLocation.UNKNOWN, SourceLocation.Point.UNKNOWN_POINT);
            htmlAttributeNode.addChild(new RawTextNode(id.get(), "ssk", SourceLocation.UNKNOWN));
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(id.get(), SourceLocation.UNKNOWN, HtmlAttributeValueNode.Quotes.SINGLE);
            String tplName = templateNode.getHtmlElementMetadata().getFinalCallee().isEmpty() ? templateNode.getTemplateName() : templateNode.getHtmlElementMetadata().getFinalCallee();
            FunctionNode wrappedFn = FunctionNode.newPositional(Identifier.create(BuiltinFunction.SOY_SERVER_KEY.getName(), SourceLocation.UNKNOWN), BuiltinFunction.SOY_SERVER_KEY, SourceLocation.UNKNOWN);
            wrappedFn.setType(StringType.getInstance());
            if (openTagNode.getKeyNode() == null) {
                FunctionNode funcNode = FunctionNode.newPositional(Identifier.create(BuiltinFunction.XID.getName(), SourceLocation.UNKNOWN), BuiltinFunction.XID, SourceLocation.UNKNOWN);
                funcNode.addChild(new StringNode(tplName + "-root", QuoteStyle.SINGLE, SourceLocation.UNKNOWN));
                funcNode.setType(StringType.getInstance());
                wrappedFn.addChild(funcNode);
                result = ExprNodes.plus(wrappedFn, (ExprNode)keyParamRef);
            } else {
                wrappedFn.addChild(openTagNode.getKeyNode().getExpr().getRoot().copy(new CopyState()));
                result = wrappedFn;
            }
            PrintNode printNode = new PrintNode(id.get(), unknown, true, result, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            printNode.getExpr().setType(wrappedFn.getType());
            valueNode.addChild(printNode);
            htmlAttributeNode.addChild(valueNode);
            ifCondNode.addChild(htmlAttributeNode);
            openTagNode.addChild(ifNode);
            if (openTagNode.getKeyNode() != null) {
                openTagNode.removeChild(openTagNode.getKeyNode());
            }
        }
        for (TemplateHeaderVarDefn param : templateNode.getHeaderParams()) {
            if (!param.name().equals("extraRootElementAttributes")) continue;
            if (templateNode.getAllowExtraAttributes()) {
                this.errorReporter.report(param.getSourceLocation(), ATTRIBUTE_STAR_AND_EXPLICIT, "extraRootElementAttributes");
            }
            if (SoyTypes.tryRemoveNullish(param.type()).equals(SanitizedType.AttributesType.getInstance()) && param.isExplicitlyOptional()) continue;
            this.errorReporter.report(param.getSourceLocation(), EXTRA_ROOT_ELEMENT_ATTRIBUTES_TYPE, "extraRootElementAttributes");
        }
        if (templateNode.getAllowExtraAttributes()) {
            SourceLocation loc = templateNode.getAllowExtraAttributesLoc();
            typeNode = NamedTypeNode.create(loc, "attributes");
            typeNode.setResolvedType(SanitizedType.AttributesType.getInstance());
            TemplateParam attrsParam = new TemplateParam("extraRootElementAttributes", loc, loc, typeNode, false, true, true, "Created by ElementAttributePass.", null);
            VarRefNode extraAttributesRef = new VarRefNode("$" + attrsParam.name(), loc, attrsParam);
            templateNode.addParam(attrsParam);
            attrsParam.setType(SoyTypes.makeUndefinable(SanitizedType.AttributesType.getInstance()));
            IfNode ifNode = new IfNode(id.get(), unknown);
            IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull(extraAttributesRef));
            ifCondNode.getExpr().setType(BoolType.getInstance());
            ifNode.addChild(ifCondNode);
            HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(id.get(), unknown, null);
            PrintNode printNode = new PrintNode(id.get(), unknown, true, extraAttributesRef, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            printNode.getExpr().setType(extraAttributesRef.getType());
            htmlAttributeNode.addChild(printNode);
            ifCondNode.addChild(htmlAttributeNode);
            openTagNode.addChild(ifNode);
            templateNode.setReservedAttributes((ImmutableSet<String>)foundNormalAttr.build());
            if (iAmAnElementCallingAnElement) {
                delegatingElementsWithAllAttrs.accept(templateNode);
            }
        }
        this.warnUnusedAttributes(unseenParams);
    }

    private SoyNode.StandaloneNode noConcatRewrite(HtmlAttributeNode attrNode, AttrParam attr, Supplier<Integer> id, SourceLocation unknown) {
        HtmlAttributeNode newAttrNode = new HtmlAttributeNode(id.get(), attrNode.getSourceLocation(), SourceLocation.Point.UNKNOWN_POINT);
        newAttrNode.addChild(((RawTextNode)attrNode.getChild(0)).substring(id.get(), 1));
        HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(id.get(), unknown, HtmlAttributeValueNode.Quotes.DOUBLE);
        newAttrNode.addChild(valueNode);
        VarRefNode attrExpr = new VarRefNode("$" + attr.name(), unknown, attr);
        PrintNode staticValuePrint = new PrintNode(id.get(), unknown, true, attrExpr, (Iterable<CommandTagAttribute>)ImmutableList.of(), this.errorReporter);
        staticValuePrint.getExpr().setType(attrExpr.getType());
        if (attr.isRequired()) {
            valueNode.addChild(staticValuePrint);
            return newAttrNode;
        }
        if (attrNode.hasValue()) {
            IfNode ifNode = ElementAttributePass.buildPrintIfNotNull(attrExpr, id);
            valueNode.addChild(ifNode);
            IfElseNode ifElseNode = new IfElseNode((int)id.get(), unknown, unknown);
            ifNode.addChild(ifElseNode);
            ElementAttributePass.copyChildren(attrNode, ifElseNode);
            return newAttrNode;
        }
        valueNode.addChild(staticValuePrint);
        IfNode ifNode = new IfNode(id.get(), unknown);
        IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", this.isConcatenatedAttribute(attrNode) ? attrExpr.copy(new CopyState()) : ElementAttributePass.buildNotNull(attrExpr));
        ifCondNode.getExpr().setType(BoolType.getInstance());
        ifCondNode.addChild(newAttrNode);
        ifNode.addChild(ifCondNode);
        return ifNode;
    }

    private SoyNode.StandaloneNode concatRewrite(HtmlOpenTagNode openTagNode, HtmlAttributeNode attrNode, AttrParam attr, Supplier<Integer> id, SourceLocation unknown) {
        FunctionNode func = FunctionNode.newPositional(Identifier.create("buildAttr", attrNode.getSourceLocation()), BasicFunctions.BUILD_ATTR_FUNCTION, attrNode.getSourceLocation());
        func.addChild(new StringNode(attrNode.getStaticKey().substring(1), QuoteStyle.DOUBLE, unknown, false));
        boolean isCss = SanitizedType.StyleType.getInstance().isAssignableFromStrict(SoyTypes.tryRemoveNullish(attr.type()));
        LetContentNode letContentNode = LetContentNode.forVariable(id.get(), unknown, "$__internal_soy_letContent_" + String.valueOf(id.get()), unknown, isCss ? SanitizedContentKind.CSS : SanitizedContentKind.TEXT);
        openTagNode.getParent().addChild(openTagNode.getParent().getChildIndex(openTagNode), letContentNode);
        ElementAttributePass.copyChildren(attrNode, letContentNode);
        VarRefNode letRef = new VarRefNode(letContentNode.getVarRefName(), SourceLocation.UNKNOWN, letContentNode.getVar());
        func.addChild(new VarRefNode("$" + attr.name(), unknown, attr));
        func.addChild(letRef);
        PrintNode printNode = new PrintNode(id.get(), unknown, true, func, (Iterable<CommandTagAttribute>)ImmutableList.of(), this.errorReporter);
        HtmlAttributeNode newAttrNode = new HtmlAttributeNode(id.get(), attrNode.getSourceLocation(), null);
        newAttrNode.addChild(printNode);
        return newAttrNode;
    }

    private void updateReservedAttributesForDelegateCalls(ImmutableList<TemplateNode> templates, ImmutableMap<String, TemplateNode> allAstElements) {
        Map<String, String> templateFqnCall = templates.stream().collect(Collectors.toMap(TemplateNode::getTemplateName, ElementAttributePass::getDelegateCall));
        while (!templateFqnCall.isEmpty()) {
            List leaves = templateFqnCall.entrySet().stream().filter(e -> !templateFqnCall.containsKey(e.getValue())).collect(Collectors.toList());
            if (leaves.isEmpty()) {
                throw new IllegalArgumentException("Cyclical graph: " + String.valueOf(templateFqnCall));
            }
            for (Map.Entry leaf : leaves) {
                TemplateNode callee = (TemplateNode)allAstElements.get(leaf.getValue());
                ImmutableSet<String> reservedAttr = callee != null ? callee.getReservedAttributes() : this.templateRegistryFromDeps.get().getBasicTemplateOrElement((String)leaf.getValue()).getTemplateType().getReservedAttributes();
                TemplateNode caller = (TemplateNode)allAstElements.get(leaf.getKey());
                caller.setReservedAttributes((ImmutableSet<String>)ImmutableSet.builder().addAll(caller.getReservedAttributes()).addAll(reservedAttr).build());
                templateFqnCall.remove(leaf.getKey());
            }
        }
    }

    private void checkRootElementTagNames(ImmutableCollection<TemplateNode> elements) {
        for (TemplateNode node : elements) {
            String tag;
            TemplateContentKind.ElementContentKind contentKind = (TemplateContentKind.ElementContentKind)node.getTemplateContentKind();
            String expectedTagName = contentKind.getTagName();
            if (expectedTagName.isEmpty() || "?".equals(tag = node.getHtmlElementMetadata().getTag()) || expectedTagName.equals(tag)) continue;
            HtmlOpenTagNode openTag = ElementAttributePass.getElementOpen(node);
            SourceLocation errorLoc = null;
            if (openTag != null) {
                errorLoc = openTag.getTagName().getTagLocation();
            } else if (node.getChildren().size() == 1 && ((SoyNode.StandaloneNode)node.getChild(0)).getKind() == SoyNode.Kind.CALL_BASIC_NODE) {
                errorLoc = ((CallBasicNode)node.getChild(0)).getOpenTagLocation();
            }
            if (errorLoc == null) continue;
            if (openTag != null && openTag.getTagName().isStatic()) {
                this.errorReporter.report(errorLoc, ROOT_TAG_KIND_MISMATCH, expectedTagName);
                continue;
            }
            this.errorReporter.report(errorLoc, DELEGATE_KIND_MISMATCH, expectedTagName, tag);
        }
    }

    private static String getDelegateCall(TemplateNode templateNode) {
        return templateNode.getHtmlElementMetadata().getDelegateElement();
    }

    static void copyChildren(HtmlAttributeNode from, SoyNode.ParentSoyNode<SoyNode.StandaloneNode> to) {
        Iterator i = from.getChildren().iterator();
        i.next();
        while (i.hasNext()) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)i.next();
            if (child instanceof HtmlAttributeValueNode) {
                for (SoyNode.StandaloneNode node : ((HtmlAttributeValueNode)child).getChildren()) {
                    to.addChild(node.copy(new CopyState()));
                }
                continue;
            }
            to.addChild(child.copy(new CopyState()));
        }
    }

    private void checkAttributeRefs(TemplateNode templateNode, Set<AttrParam> attrs) {
        SoyTreeUtils.allNodesOfType(templateNode, VarRefNode.class).filter(ref -> attrs.contains(ref.getDefnDecl())).forEach(attrRef -> this.errorReporter.report(attrRef.getSourceLocation(), ATTRIBUTE_USED_OUTSIDE_OF_TAG, new Object[0]));
    }

    private void warnUnusedAttributes(Iterable<AttrParam> unseenParams) {
        unseenParams.forEach(attrParam -> this.errorReporter.warn(attrParam.getSourceLocation(), UNUSED_ATTRIBUTE, new Object[0]));
    }

    @Nullable
    static HtmlOpenTagNode getElementOpen(TemplateNode node) {
        return SoyTreeUtils.allNodesOfType(node, HtmlOpenTagNode.class).filter(HtmlOpenTagNode::isElementRoot).findFirst().orElse(null);
    }

    @Nullable
    static String getMergingKey(HtmlAttributeNode node) {
        if (!(node.getChild(0) instanceof PrintNode)) {
            return null;
        }
        PrintNode printNode = (PrintNode)node.getChild(0);
        if (!(printNode.getExpr().getRoot() instanceof FunctionNode)) {
            return null;
        }
        FunctionNode func = (FunctionNode)printNode.getExpr().getRoot();
        if (func.hasStaticName() && func.getStaticFunctionName().equals("buildAttr") && func.getChild(0) instanceof StringNode) {
            return "@" + ((StringNode)func.getChild(0)).getValue();
        }
        return null;
    }

    @Nullable
    static String getStaticOrMergingKey(HtmlAttributeNode node) {
        return node.getStaticKey() != null ? node.getStaticKey() : ElementAttributePass.getMergingKey(node);
    }

    private boolean isConcatenatedAttribute(HtmlAttributeNode node) {
        return ElementAttributePass.getStaticOrMergingKey(node) != null && CONCATENATED_ATTRIBUTES.contains((Object)ElementAttributePass.getStaticOrMergingKey(node));
    }
}

