/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;

final class CheckGlobalsPass
implements CompilerFilePass {
    private static final SoyErrorKind UNBOUND_GLOBAL = SoyErrorKind.of("Undefined symbol ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    CheckGlobalsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new LocalVariablesNodeVisitor(new GlobalExprVisitor()).exec(file);
    }

    private final class GlobalExprVisitor
    extends LocalVariablesNodeVisitor.ExprVisitor {
        private GlobalExprVisitor() {
        }

        @Override
        protected void visitGlobalNode(GlobalNode global) {
            if (global.alreadyReportedError()) {
                return;
            }
            String sourceName = global.getIdentifier().originalName();
            String extraErrorMessage = SoyErrors.getDidYouMeanMessage(this.getLocalVariables().allVariablesInScope(), sourceName);
            CheckGlobalsPass.this.errorReporter.report(global.getSourceLocation(), UNBOUND_GLOBAL, sourceName, extraErrorMessage);
        }
    }
}

