/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.function.Supplier;

@RunAfter(value={FinalizeTemplateRegistryPass.class})
final class AutoescaperPass
implements CompilerFileSetPass {
    private final ErrorReporter errorReporter;
    private final ImmutableList<? extends SoyPrintDirective> printDirectives;
    private final boolean autoescaperEnabled;
    private final Supplier<FileSetMetadata> templateRegistryFull;

    AutoescaperPass(ErrorReporter errorReporter, ImmutableList<? extends SoyPrintDirective> printDirectives, boolean autoescaperEnabled, Supplier<FileSetMetadata> templateRegistryFull) {
        this.errorReporter = errorReporter;
        this.printDirectives = printDirectives;
        this.autoescaperEnabled = autoescaperEnabled;
        this.templateRegistryFull = templateRegistryFull;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        ContextualAutoescaper autoescaper = new ContextualAutoescaper(this.errorReporter, this.printDirectives, this.templateRegistryFull.get());
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        Inferences inferences = autoescaper.annotate(sourceFiles);
        if (inferences == null) {
            return CompilerFileSetPass.Result.STOP;
        }
        if (this.autoescaperEnabled) {
            autoescaper.rewrite(sourceFiles, idGenerator, inferences);
        }
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

