/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.List;

public class JsExprUtils {
    private static final JsExpr EMPTY_STRING = new JsExpr("''", Integer.MAX_VALUE);

    private JsExprUtils() {
    }

    public static JsExpr concatJsExprs(List<? extends JsExpr> jsExprs) {
        if (jsExprs.isEmpty()) {
            return EMPTY_STRING;
        }
        if (jsExprs.size() == 1) {
            return jsExprs.get(0);
        }
        int plusOpPrec = Precedence.forSoyOperator(Operator.PLUS).toInt();
        StringBuilder resultSb = new StringBuilder();
        boolean isFirst = true;
        for (JsExpr jsExpr : jsExprs) {
            boolean needsProtection;
            boolean bl = isFirst ? jsExpr.getPrecedence() < plusOpPrec : (needsProtection = jsExpr.getPrecedence() <= plusOpPrec);
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(" + ");
            }
            if (needsProtection) {
                resultSb.append('(').append(jsExpr.getText()).append(')');
                continue;
            }
            resultSb.append(jsExpr.getText());
        }
        return new JsExpr(resultSb.toString(), plusOpPrec);
    }

    public static boolean isStringLiteral(JsExpr jsExpr) {
        String jsExprText = jsExpr.getText();
        int jsExprTextLastIndex = jsExprText.length() - 1;
        if (jsExprTextLastIndex < 1 || jsExprText.charAt(0) != '\'' || jsExprText.charAt(jsExprTextLastIndex) != '\'') {
            return false;
        }
        for (int i = 1; i < jsExprTextLastIndex; ++i) {
            char c = jsExprText.charAt(i);
            if (c == '\'') {
                return false;
            }
            if (c != '\\') continue;
            ++i;
        }
        return true;
    }

    public static JsExpr toString(JsExpr expr) {
        if (JsExprUtils.isStringLiteral(expr)) {
            return expr;
        }
        return JsExprUtils.concatJsExprs((List<? extends JsExpr>)ImmutableList.of((Object)EMPTY_STRING, (Object)expr));
    }

    @VisibleForTesting
    static JsExpr wrapWithFunction(String functionExprText, JsExpr jsExpr) {
        Preconditions.checkNotNull((Object)functionExprText);
        return new JsExpr(functionExprText + "(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Deprecated
    public static JsExpr maybeWrapAsSanitizedContent(SanitizedContent.ContentKind contentKind, JsExpr jsExpr) {
        if (contentKind == SanitizedContent.ContentKind.TEXT) {
            return jsExpr;
        }
        return JsExprUtils.wrapWithFunction(NodeContentKinds.toJsSanitizedContentOrdainer(Converters.toSanitizedContentKind(contentKind)), jsExpr);
    }
}

