/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public final class JsCodeBuilder {
    private final StringBuilder code;
    private final OutputVarHandler outputVars;
    private final Map<String, GoogRequire> googRequires = new TreeMap<String, GoogRequire>();

    public JsCodeBuilder(OutputVarHandler outputVars) {
        this.code = new StringBuilder();
        this.outputVars = outputVars;
    }

    @CanIgnoreReturnValue
    public JsCodeBuilder pushOutputVar(String outputVarName) {
        this.outputVars.pushOutputVar(outputVarName);
        return this;
    }

    @CanIgnoreReturnValue
    public JsCodeBuilder popOutputVar() {
        this.outputVars.popOutputVar();
        return this;
    }

    @CanIgnoreReturnValue
    public JsCodeBuilder setOutputVarInited() {
        this.outputVars.setOutputVarInited();
        return this;
    }

    public JsCodeBuilder append(CodeChunk codeChunk) {
        codeChunk.collectRequires(this::addGoogRequire);
        return this.appendLine(codeChunk.getCode(FormatOptions.JSSRC));
    }

    public JsCodeBuilder appendNullable(@Nullable CodeChunk codeChunk) {
        if (codeChunk != null) {
            return this.append(codeChunk);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public JsCodeBuilder appendLine(String ... codeFragments) {
        for (String codeFragment : codeFragments) {
            this.code.append(codeFragment);
        }
        this.code.append("\n");
        return this;
    }

    public void addGoogRequire(GoogRequire require) {
        GoogRequire oldRequire = this.googRequires.put(require.symbol(), require);
        if (oldRequire != null) {
            this.googRequires.put(require.symbol(), require.merge(oldRequire));
        }
    }

    public void addGoogRequires(Iterable<GoogRequire> googRequires) {
        googRequires.forEach(this::addGoogRequire);
    }

    public void appendGoogRequiresTo(StringBuilder sb) {
        for (GoogRequire require : this.googRequires.values()) {
            require.writeTo(sb);
        }
    }

    public String getCode() {
        return this.code.toString();
    }

    void appendCodeTo(StringBuilder sb) {
        sb.append((CharSequence)this.code);
    }
}

