/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import java.util.HashMap;
import java.util.Map;

final class AliasUtils {
    private static final String MODULE_ALIAS_PREFIX = "$soy$";
    static final TemplateAliases IDENTITY_ALIASES = new TemplateAliases(){

        @Override
        public String get(String fullyQualifiedName) {
            return fullyQualifiedName;
        }

        @Override
        public String getNamespaceAlias(String namespace) {
            throw new UnsupportedOperationException();
        }
    };

    private AliasUtils() {
    }

    static boolean isExternalFunction(String alias) {
        return alias.startsWith(MODULE_ALIAS_PREFIX);
    }

    static TemplateAliases createTemplateAliases(SoyFileNode fileNode, FileSetMetadata fileSetMetadata) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashMap<String, String> foundNamespaces = new HashMap<String, String>();
        fileNode.getTemplates().stream().filter(t -> !(t instanceof TemplateDelegateNode)).forEach(templateNode -> {
            String alias = "$" + templateNode.getPartialTemplateName();
            aliasMap.put(templateNode.getTemplateName(), alias);
        });
        fileNode.getConstants().forEach(constNode -> aliasMap.put(constNode.getVar().name(), "$" + constNode.getVar().name()));
        fileNode.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.TEMPLATE).map(i -> fileSetMetadata.getNamespaceForPath(i.getSourceFilePath())).distinct().forEach(namespace -> {
            String alias = MODULE_ALIAS_PREFIX + namespace.replace('.', '$');
            foundNamespaces.put((String)namespace, alias);
        });
        return new Aliases(aliasMap, foundNamespaces);
    }

    private static final class Aliases
    implements TemplateAliases {
        final ImmutableMap<String, String> aliasMapping;
        final ImmutableMap<String, String> namespaceAliases;

        Aliases(Map<String, String> aliasMapping, Map<String, String> namespaceAliases) {
            this.aliasMapping = ImmutableMap.copyOf(aliasMapping);
            this.namespaceAliases = ImmutableMap.copyOf(namespaceAliases);
        }

        @Override
        public String get(String fullyQualifiedName) {
            String alias = (String)this.aliasMapping.get((Object)fullyQualifiedName);
            if (alias != null) {
                return alias;
            }
            int lastDotPosition = fullyQualifiedName.lastIndexOf(46);
            Preconditions.checkState((lastDotPosition != -1 ? 1 : 0) != 0);
            String namespace = fullyQualifiedName.substring(0, lastDotPosition);
            String relativeName = fullyQualifiedName.substring(lastDotPosition + 1);
            return this.getNamespaceAlias(namespace) + "." + relativeName;
        }

        @Override
        public String getNamespaceAlias(String namespace) {
            return (String)this.namespaceAliases.get((Object)namespace);
        }
    }
}

