/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_TsFunction;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.OperatorInterface;
import com.google.template.soy.jssrc.dsl.ParamDecls;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@AutoValue
abstract class TsFunction
extends Expression
implements Expression.InitialStatementsScope,
OperatorInterface {
    TsFunction() {
    }

    static TsFunction anonymous(ParamDecls params, Expression returnType, List<Statement> statements) {
        return new AutoValue_TsFunction(Format.ANONYMOUS, params, (Expression)Preconditions.checkNotNull((Object)returnType), (ImmutableList<Statement>)ImmutableList.copyOf(statements));
    }

    static TsFunction arrow(ParamDecls params, List<Statement> statements) {
        return new AutoValue_TsFunction(Format.ARROW, params, null, (ImmutableList<Statement>)ImmutableList.copyOf(statements));
    }

    static TsFunction arrow(ParamDecls params, Expression returnType, List<Statement> statements) {
        return new AutoValue_TsFunction(Format.ARROW, params, (Expression)Preconditions.checkNotNull((Object)returnType), (ImmutableList<Statement>)ImmutableList.copyOf(statements));
    }

    abstract Format format();

    abstract ParamDecls params();

    @Nullable
    abstract Expression returnType();

    abstract ImmutableList<Statement> bodyStmts();

    @Override
    public Precedence precedence() {
        return Precedence.P2;
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.Associativity.RIGHT;
    }

    @Nullable
    private Expression getSingleExpression() {
        if (this.bodyStmts().size() != 1 || !(this.bodyStmts().get(0) instanceof Return)) {
            return null;
        }
        Expression exprBody = ((Return)this.bodyStmts().get(0)).value();
        if (!exprBody.isRepresentableAsSingleExpression()) {
            return null;
        }
        if (exprBody.initialExpressionIsObjectLiteral()) {
            return Group.create(exprBody);
        }
        return exprBody;
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        boolean anon = this.format() == Format.ANONYMOUS;
        ctx.append(anon ? "function(" : "(").appendOutputExpression(this.params()).append(")");
        if (this.returnType() != null) {
            ctx.noBreak().append(": ");
            ctx.appendOutputExpression(this.returnType());
        }
        Expression singleExpression = null;
        if (!anon) {
            ctx.noBreak().append(" => ");
            singleExpression = this.getSingleExpression();
        }
        if (singleExpression != null) {
            ctx.appendOutputExpression(singleExpression);
        } else {
            ctx.enterBlock();
            for (CodeChunk stmt : this.bodyStmts()) {
                ctx.appendAll(stmt);
                ctx.endLine();
            }
            ctx.close();
        }
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        Stream<? extends CodeChunk> s = Stream.concat(this.bodyStmts().stream(), this.params().childrenStream());
        if (this.returnType() != null) {
            s = Stream.concat(s, Stream.of(this.returnType()));
        }
        return s;
    }

    public static enum Format {
        ANONYMOUS,
        ARROW;

    }
}

