/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Switch;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
abstract class Switch
extends Statement {
    Switch() {
    }

    abstract Expression switchOn();

    abstract ImmutableList<CaseClause> caseClauses();

    @Nullable
    abstract Statement defaultCaseBody();

    static Switch create(Expression switchOn, ImmutableList<CaseClause> caseClauses, @Nullable Statement defaultCaseBody) {
        return new AutoValue_Switch(switchOn, caseClauses, defaultCaseBody);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        block24: {
            ctx.appendInitialStatements(this.switchOn());
            for (CaseClause caseClause : this.caseClauses()) {
                for (Expression caseLabel : caseClause.caseLabels) {
                    ctx.appendInitialStatements(caseLabel);
                }
            }
            ctx.append("switch (").appendOutputExpression(this.switchOn()).append(") ");
            try (FormattingContext ignored = ctx.enterBlock();){
                for (CaseClause caseClause : this.caseClauses()) {
                    for (int i = 0; i < caseClause.caseLabels.size(); ++i) {
                        ctx.append("case ").appendOutputExpression((Expression)caseClause.caseLabels.get(i)).append(":");
                        if (i >= caseClause.caseLabels.size() - 1) continue;
                        ctx.endLine();
                    }
                    try (FormattingContext ignored2 = ctx.enterCaseBody();){
                        ctx.appendAll(caseClause.caseBody).endLine();
                        if (!caseClause.caseBody.isTerminal()) {
                            ctx.append("break;").endLine();
                        }
                    }
                    ctx.endLine();
                }
                if (this.defaultCaseBody() == null) break block24;
                ctx.append("default:");
                try (FormattingContext ignored2 = ctx.enterCaseBody();){
                    ctx.appendAll(this.defaultCaseBody());
                }
            }
        }
        ctx.endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(Stream.of(this.switchOn(), this.defaultCaseBody()).filter(Objects::nonNull), this.caseClauses().stream().flatMap(caseClause -> Stream.concat(caseClause.caseLabels.stream(), Stream.of(caseClause.caseBody))));
    }

    @Override
    public boolean isTerminal() {
        return this.defaultCaseBody() != null && this.defaultCaseBody().isTerminal() && this.caseClauses().stream().allMatch(c -> c.caseBody.isTerminal());
    }

    @Immutable
    static final class CaseClause {
        private final ImmutableList<Expression> caseLabels;
        private final Statement caseBody;

        CaseClause(ImmutableList<Expression> caseLabels, Statement caseBody) {
            this.caseLabels = caseLabels;
            this.caseBody = caseBody;
        }
    }
}

