/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.template.soy.exprtree.Operator;

public enum Precedence {
    P1,
    P2,
    P3,
    P4,
    P5,
    P6,
    P7,
    P8,
    P9,
    P10,
    P11,
    P12,
    P13,
    P14,
    P15,
    P16,
    P17,
    P18;


    public static Precedence forSoyOperator(Operator soyOperator) {
        switch (soyOperator) {
            case ASSERT_NON_NULL: {
                return P17;
            }
            case NEGATIVE: 
            case NOT: {
                return P14;
            }
            case TIMES: 
            case DIVIDE_BY: 
            case MOD: {
                return P12;
            }
            case PLUS: 
            case MINUS: {
                return P11;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                return P10;
            }
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                return P9;
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case TRIPLE_EQUAL: 
            case TRIPLE_NOT_EQUAL: {
                return P8;
            }
            case BITWISE_AND: {
                return P7;
            }
            case BITWISE_XOR: {
                return P6;
            }
            case BITWISE_OR: {
                return P5;
            }
            case AND: 
            case AMP_AMP: {
                return P4;
            }
            case OR: 
            case BAR_BAR: 
            case NULL_COALESCING: {
                return P3;
            }
            case CONDITIONAL: {
                return P2;
            }
        }
        throw new AssertionError();
    }

    public static Associativity getAssociativity(Operator soyOperator) {
        switch (soyOperator) {
            case CONDITIONAL: {
                return Associativity.RIGHT;
            }
        }
        return Associativity.LEFT;
    }

    public boolean greaterThan(Precedence other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean lessThan(Precedence other) {
        return this.ordinal() < other.ordinal();
    }

    public int toInt() {
        return this.ordinal() + 1;
    }

    public static enum Associativity {
        LEFT,
        RIGHT;

        public static final Associativity UNARY;

        static {
            UNARY = LEFT;
        }
    }
}

