/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_LineComment;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.SpecialToken;

@Immutable
@AutoValue
public abstract class LineComment
extends SpecialToken {
    abstract String source();

    public static LineComment create(String comment) {
        Preconditions.checkArgument((!((String)comment).contains("\n") ? 1 : 0) != 0);
        if (!((String)comment).startsWith("//")) {
            comment = "// " + (String)comment;
        }
        return new AutoValue_LineComment((String)comment);
    }

    public String content() {
        if (this.source().startsWith("// ")) {
            return this.source().substring(3);
        }
        return this.source().substring(2);
    }

    @Override
    void doFormatToken(FormattingContext ctx) {
        ctx.append(this.source());
        ctx.endLine();
    }
}

