/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Import;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Import
extends Statement {
    static final String STAR = "*";

    Import() {
    }

    abstract ImmutableSortedSet<String> symbols();

    abstract String path();

    static Import moduleImport(String alias, String path) {
        return new AutoValue_Import((ImmutableSortedSet<String>)ImmutableSortedSet.of((Comparable)((Object)("* as " + alias))), path);
    }

    static Import symbolImport(String symbol, String path) {
        return new AutoValue_Import((ImmutableSortedSet<String>)ImmutableSortedSet.of((Comparable)((Object)symbol)), path);
    }

    static Import symbolImport(String symbol, String alias, String path) {
        if (symbol.equals(alias)) {
            return Import.symbolImport(symbol, path);
        }
        return new AutoValue_Import((ImmutableSortedSet<String>)ImmutableSortedSet.of((Comparable)((Object)(symbol + " as " + alias))), path);
    }

    static Import symbolImport(Iterable<String> symbols, String path) {
        return new AutoValue_Import((ImmutableSortedSet<String>)ImmutableSortedSet.copyOf(symbols), path);
    }

    boolean isModuleImport() {
        return this.symbols().size() == 1 && ((String)this.symbols().iterator().next()).startsWith(STAR);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        StringBuilder singleLine = new StringBuilder();
        singleLine.append("import ");
        boolean isModule = this.isModuleImport();
        if (!isModule) {
            singleLine.append("{");
        }
        Joiner.on((String)", ").appendTo(singleLine, this.symbols());
        if (!isModule) {
            singleLine.append("}");
        }
        singleLine.append(" from '").append(this.path()).append("';");
        ctx.append(singleLine.toString());
        ctx.endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.empty();
    }
}

