/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_GoogRequire;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunks;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.Import;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.dsl.VariableReference;

@Immutable
@AutoValue
public abstract class GoogRequire
implements Comparable<GoogRequire> {
    private static final Expression GOOG_REQUIRE = Expressions.dottedIdNoRequire("goog.require");
    private static final Expression GOOG_REQUIRE_TYPE = Expressions.dottedIdNoRequire("goog.requireType");
    private static final Expression GOOG_MAYBE_REQUIRE = Expressions.dottedIdNoRequire("goog.maybeRequireFrameworkInternalOnlyDoNotCallOrElse");

    public static GoogRequire create(String symbol) {
        return new AutoValue_GoogRequire(symbol, symbol, GOOG_REQUIRE.call(Expressions.stringLiteral(symbol)), false, false);
    }

    public static GoogRequire createTypeRequire(String symbol) {
        return new AutoValue_GoogRequire(symbol, symbol, GOOG_REQUIRE_TYPE.call(Expressions.stringLiteral(symbol)), true, false);
    }

    public static GoogRequire createWithAlias(String symbol, String alias) {
        CodeChunks.checkId(alias);
        return new AutoValue_GoogRequire(symbol, alias, VariableDeclaration.builder(alias).setRhs(GOOG_REQUIRE.call(Expressions.stringLiteral(symbol))).build(), false, false);
    }

    public static GoogRequire createTypeRequireWithAlias(String symbol, String alias) {
        CodeChunks.checkId(alias);
        return new AutoValue_GoogRequire(symbol, alias, VariableDeclaration.builder(alias).setRhs(GOOG_REQUIRE_TYPE.call(Expressions.stringLiteral(symbol))).build(), true, false);
    }

    public static GoogRequire createMaybeRequire(String symbol) {
        return new AutoValue_GoogRequire(symbol, symbol, GOOG_MAYBE_REQUIRE.call(Expressions.stringLiteral(symbol)), false, true);
    }

    public static GoogRequire createImport(String symbol, String path) {
        return GoogRequire.createImport(symbol, symbol, path);
    }

    public static GoogRequire createImport(String symbol, String alias, String path) {
        return new AutoValue_GoogRequire(symbol, alias, Import.symbolImport(symbol, alias, path), false, false);
    }

    public abstract String symbol();

    public abstract String alias();

    abstract CodeChunk chunk();

    abstract boolean isTypeRequire();

    public GoogRequire toRequireType() {
        if (this.isTypeRequire()) {
            return this;
        }
        return new AutoValue_GoogRequire(this.symbol(), this.alias(), this.chunk(), true, false);
    }

    abstract boolean isMaybeRequire();

    public Expression reference() {
        if (this.chunk() instanceof VariableDeclaration) {
            return Expressions.id(((VariableDeclaration)this.chunk()).varName(), (Iterable<GoogRequire>)ImmutableSet.of((Object)this));
        }
        return Expressions.dottedIdWithRequires(this.symbol(), (Iterable<GoogRequire>)ImmutableSet.of((Object)this));
    }

    public Expression googModuleGet() {
        if (this.chunk() instanceof VariableDeclaration) {
            throw new IllegalStateException("requires with aliases shouldn't use goog.module.get");
        }
        return Expressions.dottedIdWithRequires("goog.module.get", (Iterable<GoogRequire>)ImmutableSet.of((Object)this)).call(Expressions.stringLiteral(this.symbol()));
    }

    public Expression dotAccess(String ident) {
        return this.reference().dotAccess(ident);
    }

    public void writeTo(StringBuilder sb) {
        sb.append(this.chunk().getCode(FormatOptions.JSSRC)).append('\n');
    }

    public GoogRequire merge(GoogRequire other) {
        Preconditions.checkArgument((boolean)other.symbol().equals(this.symbol()));
        if (other.equals(this)) {
            return this;
        }
        if (other.chunk() instanceof VariableDeclaration && this.chunk() instanceof VariableDeclaration && ((VariableDeclaration)this.chunk()).varName().equals(((VariableDeclaration)other.chunk()).varName()) || !(this.chunk() instanceof VariableReference) && !(other.chunk() instanceof VariableDeclaration)) {
            if (other.isTypeRequire()) {
                return this;
            }
            return other;
        }
        if (other.isTypeRequire() && !(other.chunk() instanceof VariableDeclaration)) {
            return this;
        }
        if (this.isTypeRequire() && !(this.chunk() instanceof VariableDeclaration)) {
            return other;
        }
        throw new IllegalArgumentException("Found the same namespace added as a require in multiple incompatible ways: " + String.valueOf(other) + " vs. " + String.valueOf(this));
    }

    @Override
    public final int compareTo(GoogRequire o) {
        return this.symbol().compareTo(o.symbol());
    }
}

