/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.ArrayList;
import java.util.stream.Stream;

@AutoValue
public abstract class FunctionDeclaration
extends Expression
implements Expression.InitialStatementsScope {
    static String generateParamList(JsDoc jsDoc, boolean addInlineTypeAnnotations) {
        ImmutableList<JsDoc.Param> params = jsDoc.params();
        ArrayList<String> functionParameters = new ArrayList<String>();
        for (JsDoc.Param param : params) {
            if (!param.annotationType().equals("param")) continue;
            if (addInlineTypeAnnotations) {
                functionParameters.add(String.format("/* %s */ %s", param.type(), param.paramTypeName()));
                continue;
            }
            functionParameters.add(param.paramTypeName());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < functionParameters.size(); ++i) {
            sb.append((String)functionParameters.get(i));
            if (i + 1 >= functionParameters.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    abstract JsDoc jsDoc();

    abstract Statement body();

    public static FunctionDeclaration create(JsDoc jsDoc, Statement body) {
        return new AutoValue_FunctionDeclaration(jsDoc, body);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.body(), this.jsDoc());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append("function(");
        ctx.append(FunctionDeclaration.generateParamList(this.jsDoc(), false));
        ctx.append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.body());
        }
    }
}

