/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.KytheMode;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.javagencode.KytheHelper;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Base64;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;

class FormattingContext
implements AutoCloseable {
    private static final int MAX_LINE_LENGTH = 80;
    private final StringBuilder buf;
    private final int initialSize;
    private final FormatOptions formatOptions;
    @Nullable
    private KytheHelper kytheHelper;
    private Scope curScope = new Scope(null, false);
    private String curIndent;
    private boolean nextAppendShouldStartNewLine = false;
    private boolean nextAppendShouldNeverStartNewLine = false;
    private final ArrayDeque<LexicalState> lexicalStateStack;
    private int currentByteOffset = 0;

    FormattingContext(FormatOptions formatOptions) {
        this.formatOptions = formatOptions;
        this.curIndent = "";
        this.buf = new StringBuilder();
        this.initialSize = 0;
        this.lexicalStateStack = new ArrayDeque();
        this.lexicalStateStack.push(LexicalState.JS);
    }

    public void setKytheHelper(@Nullable KytheHelper kytheHelper) {
        this.kytheHelper = kytheHelper;
    }

    FormattingContext buffer() {
        final FormattingContext parent = this;
        FormatOptions bufferOptions = this.formatOptions.toBuilder().setUseTsxLineBreaks(false).setKytheMode(KytheMode.DISABLED).build();
        FormattingContext context = new FormattingContext(this, bufferOptions){

            @Override
            public void close() {
                String buffer = this.toString();
                parent.append(buffer);
            }
        };
        context.setKytheHelper(this.kytheHelper);
        context.lexicalStateStack.push(this.lexicalStateStack.peek());
        return context;
    }

    void pushLexicalState(LexicalState lexicalState) {
        this.lexicalStateStack.push(lexicalState);
    }

    void popLexicalState() {
        this.lexicalStateStack.pop();
    }

    LexicalState getCurrentLexicalState() {
        return this.lexicalStateStack.peek();
    }

    @CanIgnoreReturnValue
    public FormattingContext appendQuotedString(String s, QuoteStyle style) {
        switch (this.getCurrentLexicalState()) {
            case TSX_ATTR: {
                style = style.escaped();
            }
            case JS: {
                return this.append(FormattingContext.escapeCloseScript(BaseUtils.escapeToWrappedSoyString(s, this.formatOptions.htmlEscapeStrings(), style)));
            }
            case TTL: {
                String content = BaseUtils.escapeToSoyString(s, this.formatOptions.htmlEscapeStrings(), QuoteStyle.BACKTICK);
                if (content.contains("\n")) {
                    return this.noBreak().append(content);
                }
                return this.append(content);
            }
            case TSX: {
                return this.append(s.replace(">", "&gt;"));
            }
        }
        return this.append(s);
    }

    private static String escapeCloseScript(String s) {
        return s.replace("</script", "<\\/script");
    }

    String getInterpolationOpenString() {
        switch (this.getCurrentLexicalState()) {
            case JS: {
                return "";
            }
            case TSX_ATTR: 
            case TSX: {
                return "{";
            }
            case TTL: {
                return "${";
            }
            case RANGE_COMMENT: {
                throw new IllegalStateException();
            }
        }
        throw new AssertionError();
    }

    String getInterpolationCloseString() {
        switch (this.getCurrentLexicalState()) {
            case JS: {
                return "";
            }
            case TSX_ATTR: 
            case TTL: 
            case TSX: {
                return "}";
            }
            case RANGE_COMMENT: {
                throw new IllegalStateException();
            }
        }
        throw new AssertionError();
    }

    String getConcatenationOperator() {
        switch (this.getCurrentLexicalState()) {
            case JS: {
                return " + ";
            }
            case TSX_ATTR: 
            case TTL: 
            case TSX: {
                return "";
            }
            case RANGE_COMMENT: {
                throw new IllegalStateException();
            }
        }
        throw new AssertionError();
    }

    boolean whitespaceIsSignificant() {
        switch (this.getCurrentLexicalState()) {
            case TTL: {
                return true;
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    public FormattingContext noBreak() {
        this.nextAppendShouldNeverStartNewLine = true;
        return this;
    }

    public boolean commaAfterFirst(boolean first) {
        if (!first) {
            this.noBreak().append(", ");
        }
        return false;
    }

    @CanIgnoreReturnValue
    FormattingContext appendImputee(String stuff, @Nullable SourceLocation.ByteSpan soyOffsetSpan) {
        if (soyOffsetSpan == null || this.kytheHelper == null) {
            this.append(stuff);
            return this;
        }
        int targetStart = this.currentByteOffset;
        this.append(stuff);
        int targetEnd = this.currentByteOffset;
        this.kytheHelper.addKytheLinkTo(soyOffsetSpan.getStart(), soyOffsetSpan.getEnd(), targetStart, targetEnd);
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext append(String stuff) {
        if (!this.whitespaceIsSignificant()) {
            this.maybeBreakLineInsideTsxElement(stuff);
            this.maybeIndent(stuff.isEmpty() ? (char)'\u0000' : stuff.charAt(0));
        }
        this.appendToBuffer(stuff);
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext append(char c) {
        if (!this.whitespaceIsSignificant()) {
            this.maybeBreakLineInsideTsxElement(Character.toString(c));
            this.maybeIndent(c);
        }
        this.appendToBuffer(c);
        return this;
    }

    private void appendToBuffer(String stuff) {
        this.buf.append(stuff);
        this.currentByteOffset += Utf8.encodedLength((CharSequence)stuff);
    }

    private void appendToBuffer(char c) {
        this.buf.append(c);
        this.currentByteOffset += Utf8.encodedLength((CharSequence)String.valueOf(c));
    }

    @CanIgnoreReturnValue
    FormattingContext enterGroup() {
        if (this.lexicalStateStack.peek() == LexicalState.JS) {
            this.append('(');
        }
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext exitGroup() {
        if (this.lexicalStateStack.peek() == LexicalState.JS) {
            this.append(')');
        }
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext appendUnlessEmpty(String stuff) {
        if (stuff != null && !stuff.isEmpty()) {
            this.append(stuff);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext appendForeignCode(String stuff) {
        stuff = stuff.replace("\n", "\n" + this.curIndent);
        return this.append(stuff);
    }

    void appendBlankLine() {
        this.endLine();
        this.append("\n");
        this.endLine();
    }

    @CanIgnoreReturnValue
    FormattingContext appendInitialStatements(CodeChunk chunk) {
        if (this.shouldAppend(chunk)) {
            chunk.doFormatInitialStatements(this);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext appendOutputExpression(Expression value) {
        value.doFormatOutputExpr(this);
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext appendAll(CodeChunk chunk) {
        this.appendInitialStatements(chunk);
        if (chunk instanceof Expression) {
            this.appendOutputExpression((Expression)chunk);
            if (this.getCurrentLexicalState() == LexicalState.JS) {
                this.append(";");
                this.endLine();
            }
        } else if (chunk instanceof SpecialToken) {
            ((SpecialToken)chunk).doFormatToken(this);
        }
        return this;
    }

    private boolean shouldAppend(CodeChunk chunk) {
        return this.curScope.append(chunk);
    }

    @CanIgnoreReturnValue
    FormattingContext enterBlock() {
        this.maybeIndent('{');
        this.appendToBuffer('{');
        this.increaseIndent();
        this.endLine();
        this.curScope = new Scope(this.curScope, true);
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext enterCaseBody() {
        this.maybeIndent('\u0000');
        this.increaseIndent();
        this.endLine();
        this.curScope = new Scope(this.curScope, false);
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext endLine() {
        this.nextAppendShouldStartNewLine = true;
        this.nextAppendShouldNeverStartNewLine = false;
        return this;
    }

    char getLastChar() {
        return this.buf.length() == 0 ? (char)'\u0000' : this.buf.charAt(this.buf.length() - 1);
    }

    private void maybeBreakLineInsideTsxElement(String nextAppendContent) {
        boolean defer = this.nextAppendShouldNeverStartNewLine;
        this.nextAppendShouldNeverStartNewLine = false;
        if (!this.formatOptions.useTsxLineBreaks() || this.buf.length() == 0 || nextAppendContent.isEmpty()) {
            return;
        }
        if (this.lexicalStateStack.peek() == LexicalState.RANGE_COMMENT) {
            return;
        }
        boolean endLine = false;
        char lastChar = this.getLastChar();
        char nextChar = nextAppendContent.charAt(0);
        if (this.getCurrentLexicalState() == LexicalState.TSX && lastChar == '>' && nextChar == '<') {
            endLine = true;
        } else if (lastChar == '}' && nextChar == '{') {
            endLine = true;
        } else if (!this.fitsOnCurrentLine(nextAppendContent)) {
            endLine = true;
        }
        if (endLine && !defer) {
            this.endLine();
        }
    }

    private boolean fitsOnCurrentLine(String stuff) {
        int lastNewLine = this.buf.lastIndexOf("\n");
        int currentLineLength = lastNewLine < 0 ? this.buf.length() : (lastNewLine == this.buf.length() - 1 ? 0 : this.buf.length() - lastNewLine);
        return currentLineLength + stuff.length() < 80;
    }

    private void maybeIndent(char nextChar) {
        char lastChar = this.getLastChar();
        LexicalState current = this.lexicalStateStack.peek();
        if (current != LexicalState.RANGE_COMMENT && this.formatOptions.useTsxLineBreaks() && (nextChar == ' ' || lastChar == ' ')) {
            this.nextAppendShouldStartNewLine = false;
        }
        if (this.nextAppendShouldStartNewLine) {
            if (lastChar != '\n') {
                this.appendToBuffer('\n');
            }
            if (nextChar != '\n') {
                this.appendToBuffer(this.curIndent);
            }
            this.nextAppendShouldStartNewLine = false;
        }
    }

    @CanIgnoreReturnValue
    FormattingContext increaseIndent() {
        this.curIndent = this.curIndent + "  ";
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext decreaseIndent() {
        Preconditions.checkState((!this.curIndent.isEmpty() ? 1 : 0) != 0);
        return this.decreaseIndentLenient();
    }

    @CanIgnoreReturnValue
    FormattingContext decreaseIndentLenient() {
        if (this.curIndent.length() > 1) {
            this.curIndent = this.curIndent.substring(2);
        }
        return this;
    }

    @CanIgnoreReturnValue
    FormattingContext clearIndent() {
        this.curIndent = "";
        return this;
    }

    public String toString() {
        return this.isEmpty() ? "" : this.buf.toString() + this.getMetadataSuffix();
    }

    private String getMetadataSuffix() {
        if (this.kytheHelper != null) {
            if (this.formatOptions.kytheMode() == KytheMode.TEXT) {
                String genCodeInfoMessage = TextFormat.printer().printToString((MessageOrBuilder)this.kytheHelper.getGeneratedCodeInfo());
                return "\n/**\nKythe inline metadata pretty printed for testing:\n\n" + genCodeInfoMessage + "\n*/";
            }
            if (this.formatOptions.kytheMode() == KytheMode.BASE64) {
                return "\n// kythe-inline-metadata:" + new String(Base64.getEncoder().encode(this.kytheHelper.getGeneratedCodeInfo().toByteArray()), StandardCharsets.UTF_8) + "\n";
            }
        }
        return "";
    }

    boolean isEmpty() {
        return this.buf.length() == this.initialSize;
    }

    @Override
    public void close() {
        boolean emitClosingBrace = this.curScope.emitClosingBrace;
        this.curScope = (Scope)Preconditions.checkNotNull((Object)this.curScope.parent);
        this.decreaseIndentLenient();
        this.endLine();
        if (emitClosingBrace) {
            this.append('}');
        }
    }

    private static final class Scope {
        private final Set<CodeChunk> appendedChunks = Collections.newSetFromMap(new IdentityHashMap());
        @Nullable
        final Scope parent;
        final boolean emitClosingBrace;

        Scope(@Nullable Scope parent, boolean emitClosingBrace) {
            this.parent = parent;
            this.emitClosingBrace = emitClosingBrace;
        }

        boolean append(CodeChunk chunk) {
            if (!this.alreadyAppended(chunk)) {
                this.appendedChunks.add(chunk);
                return true;
            }
            return false;
        }

        private boolean alreadyAppended(CodeChunk chunk) {
            return this.appendedChunks.contains(chunk) || this.parent != null && this.parent.alreadyAppended(chunk);
        }
    }

    public static enum LexicalState {
        JS,
        TSX,
        TSX_ATTR,
        TTL,
        RANGE_COMMENT;

    }
}

