/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_For;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.Objects;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class For
extends Statement {
    For() {
    }

    abstract String localVar();

    abstract Expression initial();

    abstract Expression limit();

    abstract Expression increment();

    abstract Statement body();

    static For create(String localVar, Expression initial, Expression limit, Expression increment, Statement body) {
        return new AutoValue_For(localVar, initial, limit, increment, body);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.initial(), this.limit(), this.increment(), this.body());
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        ctx.appendInitialStatements(this.initial()).appendInitialStatements(this.limit()).appendInitialStatements(this.increment());
        ctx.append("for (let " + this.localVar() + " = ").appendOutputExpression(this.initial()).append("; " + this.localVar() + " < ").appendOutputExpression(this.limit()).append("; ");
        if (Objects.equals(Expressions.getLeafText(this.increment()), "1")) {
            ctx.append(this.localVar() + "++");
        } else {
            ctx.append(this.localVar() + " += ").appendOutputExpression(this.increment());
        }
        ctx.append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.body());
        }
        ctx.endLine();
    }
}

