/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.util.TreeStreams;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.Bracket;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.Cast;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.Dot;
import com.google.template.soy.jssrc.dsl.ExpressionStatement;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.ParamDecls;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.TsCast;
import com.google.template.soy.jssrc.dsl.UnaryOperation;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

@Immutable
public abstract class Expression
extends CodeChunk {
    Expression() {
    }

    boolean initialExpressionIsObjectLiteral() {
        return false;
    }

    public boolean isDefinitelyNotNull() {
        return false;
    }

    public JsExpr singleExprOrName(FormatOptions formatOptions) {
        FormattingContext ctx = new FormattingContext(formatOptions);
        this.doFormatOutputExpr(ctx);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    abstract void doFormatOutputExpr(FormattingContext var1);

    public boolean isCheap() {
        return false;
    }

    public Optional<String> asStringLiteral() {
        return Optional.empty();
    }

    @Override
    abstract Stream<? extends CodeChunk> childrenStream();

    public Expression append(List<SpecialToken> tokens) {
        return Expressions.DecoratedExpression.create(this, (List<SpecialToken>)ImmutableList.of(), tokens);
    }

    public Expression prepend(List<SpecialToken> tokens) {
        return Expressions.DecoratedExpression.create(this, tokens, (List<SpecialToken>)ImmutableList.of());
    }

    public final Expression prepend(SpecialToken ... tokens) {
        return this.prepend((List<SpecialToken>)ImmutableList.copyOf((Object[])tokens));
    }

    public final Expression asInlineExpr() {
        if (!this.hasInitialStatements()) {
            return this;
        }
        return Expressions.tsArrowFunction(ParamDecls.EMPTY, this);
    }

    @Override
    public final Statement asStatement() {
        return ExpressionStatement.of(this);
    }

    public final Statement asStatement(JsDoc jsDoc) {
        return ExpressionStatement.of(this, jsDoc);
    }

    public final Expression plus(Expression rhs) {
        return BinaryOperation.create(Operator.PLUS, this, rhs);
    }

    public final Expression minus(Expression rhs) {
        return BinaryOperation.create(Operator.MINUS, this, rhs);
    }

    public final Expression plusEquals(Expression rhs) {
        return BinaryOperation.create("+=", Precedence.P2, Precedence.Associativity.RIGHT, this, rhs);
    }

    public final Expression doubleEquals(Expression rhs) {
        return BinaryOperation.create(Operator.EQUAL, this, rhs);
    }

    public final Expression doubleNotEquals(Expression rhs) {
        return BinaryOperation.create(Operator.NOT_EQUAL, this, rhs);
    }

    public final Expression nullishCoalesce(Expression rhs, CodeChunk.Generator codeGenerator) {
        return this.shortCircuiting(rhs, codeGenerator, Operator.NULL_COALESCING, Expression::doubleEqualsNull);
    }

    public final Expression tripleEquals(Expression rhs) {
        return BinaryOperation.create("===", Precedence.forSoyOperator(Operator.EQUAL), Precedence.getAssociativity(Operator.EQUAL), this, rhs);
    }

    public final Expression tripleNotEquals(Expression rhs) {
        return BinaryOperation.create("!==", Precedence.forSoyOperator(Operator.EQUAL), Precedence.getAssociativity(Operator.EQUAL), this, rhs);
    }

    public final Expression doubleEqualsNull() {
        return this.doubleEquals(Expressions.LITERAL_NULL);
    }

    public final Expression times(Expression rhs) {
        return BinaryOperation.create(Operator.TIMES, this, rhs);
    }

    public final Expression divideBy(Expression rhs) {
        return BinaryOperation.create(Operator.DIVIDE_BY, this, rhs);
    }

    public final Expression and(Expression rhs, CodeChunk.Generator codeGenerator) {
        return this.shortCircuiting(rhs, codeGenerator, Operator.AND, e -> e);
    }

    public final Expression or(Expression rhs, CodeChunk.Generator codeGenerator) {
        return this.shortCircuiting(rhs, codeGenerator, Operator.OR, Expressions::not);
    }

    private Expression shortCircuiting(Expression rhs, CodeChunk.Generator codeGenerator, Operator nativeOp, Function<Expression, Expression> lhsTest) {
        if (this.hasEquivalentInitialStatements(rhs)) {
            return BinaryOperation.create(nativeOp, this, rhs);
        }
        Expression tmp = codeGenerator.declarationBuilder().setMutable().setRhs(this).build().ref();
        return Composite.create((ImmutableList<Statement>)ImmutableList.of((Object)Statements.ifStatement(lhsTest.apply(tmp), tmp.assign(rhs).asStatement()).build()), tmp);
    }

    public final Expression op(Operator op, Expression rhs) {
        return Expressions.operation(op, (List<Expression>)ImmutableList.of((Object)this, (Object)rhs));
    }

    public final Expression dotAccess(String identifier) {
        return this.dotAccess(identifier, false);
    }

    public Expression dotAccess(String identifier, boolean nullSafe) {
        return nullSafe ? Dot.createNullSafe(this, Expressions.id(identifier)) : Dot.create(this, Expressions.id(identifier));
    }

    public final Expression bracketAccess(Expression arg) {
        return this.bracketAccess(arg, false);
    }

    public Expression bracketAccess(Expression arg, boolean nullSafe) {
        return nullSafe ? Bracket.createNullSafe(this, arg) : Bracket.create(this, arg);
    }

    public final Expression call(Expression ... args) {
        return this.call(Arrays.asList(args));
    }

    public final Expression call(Iterable<? extends Expression> args) {
        return Call.create(this, (ImmutableList<Expression>)ImmutableList.copyOf(args));
    }

    public final boolean hasOuterCast() {
        return this instanceof Cast;
    }

    public final Expression castAsUnknown() {
        return Cast.create(this, "?");
    }

    public final Expression castAsNoRequire(String typeExpression) {
        return Cast.create(this, typeExpression);
    }

    public final Expression castAs(String typeExpression, ImmutableSet<GoogRequire> googRequires) {
        return Cast.create(this, typeExpression, googRequires);
    }

    public final Expression tsCast(Expression type) {
        return TsCast.create(this, type);
    }

    public final Expression instanceOf(Expression identifier) {
        return BinaryOperation.create("instanceof", Precedence.P9, Precedence.Associativity.LEFT, this, identifier);
    }

    public final Expression typeOf() {
        return UnaryOperation.create("typeof ", Precedence.P14, this, true);
    }

    public Expression assign(Expression rhs) {
        return BinaryOperation.create("=", Precedence.P2, Precedence.Associativity.RIGHT, this, rhs);
    }

    public final Expression withInitialStatements(Iterable<? extends Statement> initialStatements) {
        if (Iterables.isEmpty(initialStatements)) {
            return this;
        }
        return Composite.create((ImmutableList<Statement>)ImmutableList.copyOf(initialStatements), this);
    }

    public final Expression withInitialStatement(Statement initialStatement) {
        return this.withInitialStatements((Iterable<? extends Statement>)ImmutableList.of((Object)initialStatement));
    }

    final boolean isRepresentableAsSingleExpression() {
        return !this.hasInitialStatements();
    }

    @Override
    final void doFormatInitialStatements(FormattingContext ctx) {
        if (this instanceof HasInitialStatements) {
            ((HasInitialStatements)((Object)this)).initialStatements().forEach(ctx::appendInitialStatements);
        }
        if (this instanceof InitialStatementsScope) {
            return;
        }
        this.childrenStream().filter(c -> !(c instanceof Statement)).forEach(ctx::appendInitialStatements);
    }

    private Stream<Statement> initialStatementsStream() {
        return TreeStreams.breadthFirstWithStream(this, c -> {
            if (c instanceof Expression && !(c instanceof InitialStatementsScope)) {
                return c.childrenStream();
            }
            return Stream.of(new CodeChunk[0]);
        }).filter(HasInitialStatements.class::isInstance).map(HasInitialStatements.class::cast).flatMap(e -> e.initialStatements().stream());
    }

    private boolean hasInitialStatements() {
        return this.initialStatementsStream().iterator().hasNext();
    }

    public final boolean hasEquivalentInitialStatements(Expression other) {
        ImmutableList<Statement> s1 = this.allInitialStatementsInTopScope();
        ImmutableList<Statement> s2 = other.allInitialStatementsInTopScope();
        return s1.containsAll(s2);
    }

    public final ImmutableList<Statement> allInitialStatementsInTopScope() {
        return (ImmutableList)this.initialStatementsStream().collect(ImmutableList.toImmutableList());
    }

    static interface InitialStatementsScope {
    }

    static interface HasInitialStatements {
        public ImmutableList<Statement> initialStatements();
    }
}

