/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Concatenation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class Concatenation
extends Operation {
    static Expression create(Iterable<? extends Expression> parts) {
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        for (Expression expression : parts) {
            if (expression instanceof Concatenation) {
                partsBuilder.addAll(((Concatenation)expression).parts());
                continue;
            }
            if (expression.equals(TsxPrintNode.NIL)) continue;
            partsBuilder.add((Object)expression);
        }
        ImmutableList list = partsBuilder.build();
        if (list.size() == 1) {
            return (Expression)list.get(0);
        }
        return new AutoValue_Concatenation((ImmutableList<Expression>)list);
    }

    abstract ImmutableList<Expression> parts();

    public Expression map1to1(Function<Expression, Expression> mapper) {
        boolean diff = false;
        ArrayList<Expression> mappedParts = new ArrayList<Expression>(this.parts().size());
        for (Expression part : this.parts()) {
            Expression mapped = mapper.apply(part);
            if (mapped != part) {
                diff = true;
            }
            mappedParts.add(mapped);
        }
        return diff ? Concatenation.create(mappedParts) : this;
    }

    public Expression map1toN(Function<Expression, Stream<CodeChunk>> mapper) {
        boolean diff = false;
        ArrayList<Expression> mappedParts = new ArrayList<Expression>(this.parts().size());
        for (Expression part : this.parts()) {
            List chunks = mapper.apply(part).collect(Collectors.toList());
            if (chunks.size() != 1 || chunks.get(0) != part) {
                diff = true;
            }
            for (CodeChunk chunk : chunks) {
                mappedParts.add((Expression)chunk);
            }
        }
        return diff ? Concatenation.create(mappedParts) : this;
    }

    @Override
    public Precedence precedence() {
        return Precedence.P11;
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.getAssociativity(Operator.PLUS);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.parts().stream();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.parts().isEmpty()) {
            ctx.append("''");
        } else if (this.parts().size() == 1) {
            ctx.appendOutputExpression((Expression)this.parts().get(0));
        } else {
            this.formatOperand((Expression)this.parts().get(0), OperandPosition.LEFT, ctx);
            for (int i = 1; i < this.parts().size(); ++i) {
                ctx.appendUnlessEmpty(ctx.getConcatenationOperator());
                this.formatOperand((Expression)this.parts().get(i), OperandPosition.RIGHT, ctx);
            }
        }
    }
}

