/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jssrc.dsl.CodeChunks;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

@Immutable
public abstract class CodeChunk {
    abstract Stream<? extends CodeChunk> childrenStream();

    public final void appendDebug(StringBuilder sb, String prefix) {
        String simpleName = this.getClass().getSimpleName().replace("AutoValue_", "");
        String isScope = this instanceof Expression.InitialStatementsScope ? " *" : "";
        String initialStatements = this instanceof Expression.HasInitialStatements && !((Expression.HasInitialStatements)((Object)this)).initialStatements().isEmpty() ? " (" + ((Expression.HasInitialStatements)((Object)this)).initialStatements().size() + ")" : "";
        sb.append(prefix).append(simpleName).append(isScope).append(initialStatements).append("\n");
        String indent = prefix + "  ";
        this.childrenStream().forEach(c -> c.appendDebug(sb, indent));
    }

    public final void collectRequires(Consumer<GoogRequire> collector) {
        if (this instanceof HasRequires) {
            ((HasRequires)((Object)this)).googRequires().forEach(collector);
        }
        Iterator i = this.childrenStream().iterator();
        while (i.hasNext()) {
            ((CodeChunk)i.next()).collectRequires(collector);
        }
    }

    abstract void doFormatInitialStatements(FormattingContext var1);

    public abstract Statement asStatement();

    public final String getCode(FormatOptions formatOptions) {
        return CodeChunks.getCode(this, formatOptions);
    }

    public final JsExpr assertExpr() {
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        JsExpr expr = this.assertExprAndCollectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        ImmutableSet requires = requiresBuilder.build();
        if (!requires.isEmpty()) {
            throw new IllegalStateException("calling assertExpr() would drop requires!: " + String.valueOf(requires));
        }
        return expr;
    }

    public final JsExpr assertExprAndCollectRequires(Consumer<GoogRequire> collector) {
        Expression expression = (Expression)this;
        if (!expression.isRepresentableAsSingleExpression()) {
            throw new IllegalStateException(String.format("Not an expr:\n%s", this.getCode(FormatOptions.JSSRC)));
        }
        this.collectRequires(collector);
        return expression.singleExprOrName(FormatOptions.JSSRC);
    }

    CodeChunk() {
    }

    public static final class Generator {
        private final UniqueNameGenerator nameGenerator;

        private Generator(UniqueNameGenerator nameGenerator) {
            this.nameGenerator = nameGenerator;
        }

        public static Generator create(UniqueNameGenerator nameGenerator) {
            return new Generator(nameGenerator);
        }

        private String newVarName(String prefix) {
            return this.nameGenerator.generate(prefix);
        }

        private String newVarName() {
            return this.newVarName("$tmp");
        }

        public VariableDeclaration.Builder declarationBuilder() {
            return VariableDeclaration.builder(this.newVarName());
        }

        public VariableDeclaration.Builder declarationBuilder(String prefix) {
            return VariableDeclaration.builder(this.newVarName(prefix));
        }

        public Expression conditionalExpression(Expression predicate, Expression consequent, Expression alternate) {
            return Expressions.ifExpression(predicate, consequent).setElse(alternate).build(this);
        }
    }

    static interface HasRequires {
        public ImmutableSet<GoogRequire> googRequires();
    }
}

