/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Cast;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.OperatorInterface;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Cast
extends Expression
implements CodeChunk.HasRequires,
OperatorInterface {
    Cast() {
    }

    abstract Expression expr();

    abstract String typeExpr();

    @Override
    public abstract ImmutableSet<GoogRequire> googRequires();

    static Cast create(Expression expr, String typeExpr) {
        return new AutoValue_Cast(expr, typeExpr, (ImmutableSet<GoogRequire>)ImmutableSet.of());
    }

    static Cast create(Expression expr, String typeExpr, ImmutableSet<GoogRequire> googRequires) {
        return new AutoValue_Cast(expr, typeExpr, googRequires);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.expr());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append("/** @type {" + this.typeExpr() + "} */ (").appendOutputExpression(this.expr()).append(')');
    }

    @Override
    public boolean isCheap() {
        return this.expr().isCheap();
    }

    @Override
    public Precedence precedence() {
        return Precedence.P9;
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.Associativity.UNARY;
    }
}

