/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class Call
extends Operation {
    public abstract Expression receiver();

    public abstract ImmutableList<Expression> args();

    public static Call create(Expression receiver, ImmutableList<Expression> args) {
        return new AutoValue_Call(receiver, args);
    }

    @Override
    public Precedence precedence() {
        return Precedence.P17;
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.Associativity.UNARY;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(Stream.of(this.receiver()), this.args().stream());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.noBreak().append('(');
        boolean first = true;
        for (Expression arg : this.args()) {
            first = ctx.commaAfterFirst(first);
            ctx.appendOutputExpression(arg);
        }
        ctx.append(')');
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return this.receiver().initialExpressionIsObjectLiteral();
    }
}

