/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_BinaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunks;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class BinaryOperation
extends Operation {
    public abstract String operator();

    public abstract Expression arg1();

    public abstract Expression arg2();

    static Expression create(Operator operator, Expression arg1, Expression arg2) {
        return BinaryOperation.create(Operation.getOperatorToken(operator), Precedence.forSoyOperator(operator), Precedence.getAssociativity(operator), arg1, arg2);
    }

    static BinaryOperation create(String operator, Precedence precedence, Precedence.Associativity associativity, Expression arg1, Expression arg2) {
        return new AutoValue_BinaryOperation(precedence, associativity, operator, arg1, arg2);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.arg1(), this.arg2());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.arg1(), OperandPosition.LEFT, ctx);
        ctx.noBreak().append(' ').noBreak().append(this.operator()).append(' ');
        this.formatOperand(this.arg2(), OperandPosition.RIGHT, ctx);
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return this.arg1().initialExpressionIsObjectLiteral();
    }

    @Override
    protected boolean shouldProtect(Expression operand, OperandPosition operandPosition) {
        boolean specialRequired = false;
        if (this.operator().equals("??")) {
            specialRequired = CodeChunks.breadthFirst(operand).anyMatch(chunk -> {
                if (chunk instanceof BinaryOperation) {
                    String thatOp = ((BinaryOperation)chunk).operator();
                    return thatOp.equals("&&") || thatOp.equals("||");
                }
                return false;
            });
        } else if (this.operator().equals("||")) {
            specialRequired = CodeChunks.breadthFirst(operand).anyMatch(chunk -> {
                if (chunk instanceof BinaryOperation) {
                    String thatOp = ((BinaryOperation)chunk).operator();
                    return thatOp.equals("??");
                }
                return false;
            });
        }
        if (specialRequired) {
            return true;
        }
        return super.shouldProtect(operand, operandPosition);
    }
}

