/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Assignment;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
abstract class Assignment
extends Statement {
    Assignment() {
    }

    abstract Expression lhs();

    abstract Expression rhs();

    @Nullable
    abstract JsDoc jsDoc();

    static Assignment create(Expression lhs, Expression rhs, JsDoc jsDoc) {
        return new AutoValue_Assignment(lhs, rhs, jsDoc);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.lhs(), this.rhs(), this.jsDoc()).filter(Objects::nonNull);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        ctx.appendInitialStatements(this.lhs()).appendInitialStatements(this.rhs());
        if (this.jsDoc() != null) {
            ctx.appendAll(this.jsDoc()).endLine();
        }
        ctx.appendOutputExpression(this.lhs()).noBreak().append(" = ").appendOutputExpression(this.rhs()).noBreak().append(";").endLine();
    }
}

