/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jbcsrc.shared.AutoValue_SaveStateMetaFactory_FrameKey;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class SaveStateMetaFactory {
    private static final ConcurrentMap<FrameKey, Class<? extends StackFrame>> frameCache = new ConcurrentHashMap<FrameKey, Class<? extends StackFrame>>();
    private static final Type STACK_FRAME_TYPE = Type.getType(StackFrame.class);
    private static final String GENERATED_CLASS_NAME_PREFIX = StackFrame.class.getPackage().getName() + ".StackFrame";
    private static final String GENERATED_CLASS_NAME_INTERNAL_PREFIX = GENERATED_CLASS_NAME_PREFIX.replace('.', '/');
    private static final MethodType STACK_FRAME_CTOR_TYPE = MethodType.methodType(Void.TYPE, Integer.TYPE);
    private static final MethodHandle RENDER_CONTEXT_PUSH_FRAME;

    private static Class<?> simplifyType(Class<?> paramType) {
        if (paramType.isPrimitive()) {
            return paramType;
        }
        return Object.class;
    }

    private static FrameKey frameKeyFromSaveMethodType(MethodType type) {
        ImmutableList fieldTypes = (ImmutableList)type.parameterList().stream().skip(2L).map(SaveStateMetaFactory::simplifyType).collect(ImmutableList.toImmutableList());
        return FrameKey.create(fieldTypes);
    }

    public static CallSite bootstrapSaveState(MethodHandles.Lookup lookup, String name, MethodType type) {
        MethodHandle ctorHandle;
        FrameKey frameKey = SaveStateMetaFactory.frameKeyFromSaveMethodType(type);
        Class<? extends StackFrame> frameClass = SaveStateMetaFactory.getStackFrameClass(frameKey);
        try {
            ctorHandle = lookup.findConstructor(frameClass, STACK_FRAME_CTOR_TYPE.appendParameterTypes((List<Class<?>>)frameKey.fieldTypes()));
        }
        catch (ReflectiveOperationException nsme) {
            throw new LinkageError(nsme.getMessage(), nsme);
        }
        MethodHandle stackFrameConstructionHandle = ctorHandle.asType(ctorHandle.type().changeReturnType(StackFrame.class));
        MethodHandle saveStateHandle = MethodHandles.collectArguments(RENDER_CONTEXT_PUSH_FRAME, 1, stackFrameConstructionHandle);
        return new ConstantCallSite(saveStateHandle.asType(type));
    }

    private static Class<? extends StackFrame> getStackFrameClass(FrameKey key) {
        return frameCache.computeIfAbsent(key, SaveStateMetaFactory::generateStackFrameClass);
    }

    private static Class<? extends StackFrame> generateStackFrameClass(FrameKey key) {
        if (key.fieldTypes().isEmpty()) {
            return StackFrame.class;
        }
        ClassWriter cw = new ClassWriter(3);
        String className = GENERATED_CLASS_NAME_INTERNAL_PREFIX + key.symbol();
        cw.visit(52, 4145, className, null, STACK_FRAME_TYPE.getInternalName(), null);
        int counter = 0;
        ArrayList<Type> argTypes = new ArrayList<Type>(key.fieldTypes().size());
        for (Class fieldType : key.fieldTypes()) {
            Type asmType = Type.getType((Class)fieldType);
            argTypes.add(asmType);
            FieldVisitor fv = cw.visitField(17, "f_" + counter, asmType.getDescriptor(), null, null);
            fv.visitEnd();
            ++counter;
        }
        Type generatedType = Type.getObjectType((String)className);
        MethodType ctorMethodType = MethodType.methodType(Void.TYPE, key.fieldTypes()).insertParameterTypes(0, Integer.TYPE);
        MethodVisitor constructor = cw.visitMethod(1, "<init>", ctorMethodType.toMethodDescriptorString(), null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(21, 1);
        constructor.visitMethodInsn(183, STACK_FRAME_TYPE.getInternalName(), "<init>", STACK_FRAME_CTOR_TYPE.toMethodDescriptorString(), false);
        int argPosition = 2;
        for (int i = 0; i < argTypes.size(); ++i) {
            Type argType = (Type)argTypes.get(i);
            constructor.visitVarInsn(25, 0);
            constructor.visitVarInsn(argType.getOpcode(21), argPosition);
            argPosition += argType.getSize();
            constructor.visitFieldInsn(181, generatedType.getInternalName(), "f_" + i, argType.getDescriptor());
        }
        constructor.visitInsn(177);
        constructor.visitMaxs(-1, -1);
        constructor.visitEnd();
        cw.visitEnd();
        try {
            return MethodHandles.lookup().defineClass(cw.toByteArray()).asSubclass(StackFrame.class);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
    }

    public static CallSite bootstrapRestoreState(MethodHandles.Lookup lookup, String name, MethodType type, MethodType frameType, int slot) {
        MethodHandle fieldGetter;
        Field slotField;
        FrameKey key = SaveStateMetaFactory.frameKeyFromSaveMethodType(frameType);
        Class<? extends StackFrame> implClass = SaveStateMetaFactory.getStackFrameClass(key);
        try {
            slotField = implClass.getField("f_" + slot);
        }
        catch (NoSuchFieldException nsfe) {
            throw new AssertionError((Object)nsfe);
        }
        try {
            fieldGetter = lookup.unreflectGetter(slotField);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
        return new ConstantCallSite(fieldGetter.asType(type));
    }

    private SaveStateMetaFactory() {
    }

    static {
        try {
            RENDER_CONTEXT_PUSH_FRAME = MethodHandles.publicLookup().findVirtual(RenderContext.class, "pushFrame", MethodType.methodType(Void.TYPE, StackFrame.class));
        }
        catch (ReflectiveOperationException nsme) {
            throw new LinkageError(nsme.getMessage(), nsme);
        }
    }

    @AutoValue
    static abstract class FrameKey {
        FrameKey() {
        }

        static FrameKey create(ImmutableList<Class<?>> fieldTypes) {
            return new AutoValue_SaveStateMetaFactory_FrameKey(fieldTypes);
        }

        abstract ImmutableList<Class<?>> fieldTypes();

        private static String charFromClass(Class<?> cls) {
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Object.class) {
                return "A";
            }
            throw new AssertionError((Object)("unexpected class: " + String.valueOf(cls)));
        }

        @Memoized
        String symbol() {
            return this.fieldTypes().stream().map(FrameKey::charFromClass).collect(Collectors.joining());
        }
    }
}

