/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

public final class ClassLoaderFallbackCallFactory {
    private static final boolean FORCE_SLOWPATH = Boolean.getBoolean("soy_jbcsrc_take_classloader_fallback_slowpath");

    private ClassLoaderFallbackCallFactory() {
    }

    public static CallSite bootstrapTemplateLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) throws NoSuchMethodException, IllegalAccessException {
        Optional<Class<?>> templateClass;
        if (!FORCE_SLOWPATH && (templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName)).isPresent()) {
            CompiledTemplate template = ClassLoaderFallbackCallFactory.getTemplate(lookup, templateClass.get(), templateName);
            MethodHandle getter = MethodHandles.constant(CompiledTemplate.class, template);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            return new ConstantCallSite(getter);
        }
        MethodHandle slowPath = SlowPathHandles.SLOWPATH_TEMPLATE;
        slowPath = MethodHandles.insertArguments(slowPath, 1, templateName);
        return new SoyCallSite(type, slowPath);
    }

    public static CallSite bootstrapTemplateValueLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) throws NoSuchMethodException, IllegalAccessException {
        Optional<Class<?>> templateClass;
        if (!FORCE_SLOWPATH && (templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName)).isPresent()) {
            CompiledTemplate template = ClassLoaderFallbackCallFactory.getTemplate(lookup, templateClass.get(), templateName);
            TemplateValue value = TemplateValue.create(templateName, template);
            MethodHandle getter = MethodHandles.constant(TemplateValue.class, value);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            return new ConstantCallSite(getter);
        }
        MethodHandle slowPath = SlowPathHandles.SLOWPATH_TEMPLATE_VALUE;
        slowPath = MethodHandles.insertArguments(slowPath, 1, templateName);
        return new SoyCallSite(type, slowPath);
    }

    private static CompiledTemplate getTemplate(MethodHandles.Lookup lookup, Class<?> templateClass, String templateName) throws NoSuchMethodException, IllegalAccessException {
        String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
        MethodHandle templateAccessor = lookup.findStatic(templateClass, methodName, SlowPathHandles.TEMPLATE_ACCESSOR_TYPE);
        try {
            return templateAccessor.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public static CallSite bootstrapCall(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) throws IllegalAccessException, NoSuchMethodException {
        if (!FORCE_SLOWPATH) {
            Optional<Class<?>> templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName);
            String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
            if (templateClass.isPresent()) {
                return new ConstantCallSite(lookup.findStatic(templateClass.get(), methodName, type));
            }
        }
        MethodHandle slowPathRenderHandle = type.equals((Object)SlowPathHandles.RENDER_TYPE) ? SlowPathHandles.SLOWPATH_RENDER_RECORD : SlowPathHandles.SLOWPATH_RENDER_POSITIONAL;
        slowPathRenderHandle = MethodHandles.insertArguments(slowPathRenderHandle, 1, templateName);
        if (!type.equals((Object)SlowPathHandles.RENDER_TYPE)) {
            int numParams = type.parameterCount();
            int numPositionalParams = numParams - 2;
            slowPathRenderHandle = slowPathRenderHandle.asCollector(1, SoyValueProvider[].class, numPositionalParams);
        }
        return new SoyCallSite(type, slowPathRenderHandle);
    }

    public static CallSite bootstrapConstLookup(MethodHandles.Lookup lookup, String name, MethodType type, String constClassName, String constName) throws NoSuchMethodException, IllegalAccessException {
        if (!FORCE_SLOWPATH) {
            ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
            try {
                Class<?> constClass = callerClassLoader.loadClass(constClassName);
                MethodHandle handle = lookup.findStatic(constClass, constName, MethodType.methodType(type.returnType(), RenderContext.class));
                return new ConstantCallSite(handle);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        MethodHandle slowPath = SlowPathHandles.SLOWPATH_CONST;
        slowPath = MethodHandles.insertArguments(slowPath, 1, constClassName + "#" + constName + "#" + type.toMethodDescriptorString());
        return new SoyCallSite(type, slowPath.asType(slowPath.type().changeReturnType((Class<?>)type.returnType())));
    }

    public static CallSite bootstrapExternCall(MethodHandles.Lookup lookup, String name, MethodType type, String externClassName, String externName) throws NoSuchMethodException, IllegalAccessException {
        if (!FORCE_SLOWPATH) {
            ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
            try {
                Class<?> constClass = callerClassLoader.loadClass(externClassName);
                MethodHandle handle = lookup.findStatic(constClass, externName, type);
                return new ConstantCallSite(handle);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        MethodHandle slowPath = SlowPathHandles.SLOWPATH_EXTERN;
        slowPath = MethodHandles.insertArguments(slowPath, 1, externClassName + "#" + externName + "#" + type.toMethodDescriptorString());
        slowPath = slowPath.asCollector(Object[].class, type.parameterCount() - 1);
        return new SoyCallSite(type, slowPath.asType(type.insertParameterTypes(0, SoyCallSite.class)));
    }

    public static Object slowPathConst(SoyCallSite callSite, String constantFqn, RenderContext context) throws Throwable {
        CompiledTemplates templates = context.getTemplates();
        MethodHandle constMethod = templates.getConstOrExternMethod(constantFqn);
        callSite.update(templates, constMethod);
        return constMethod.invoke(context);
    }

    public static Object slowPathExtern(SoyCallSite callSite, String externFqn, RenderContext context, Object[] args) throws Throwable {
        CompiledTemplates templates = context.getTemplates();
        MethodHandle externMethod = templates.getConstOrExternMethod(externFqn);
        callSite.update(templates, externMethod);
        return externMethod.invokeWithArguments(ObjectArrays.concat((Object)context, (Object[])args));
    }

    private static Optional<Class<?>> findTemplateClass(MethodHandles.Lookup lookup, String templateName) throws NoSuchMethodException {
        Method method;
        Class<?> clazz;
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            clazz = callerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
        if (clazz.getClassLoader() instanceof AlwaysSlowPath && Modifier.isPublic((method = clazz.getDeclaredMethod(Names.renderMethodNameFromSoyTemplateName(templateName), new Class[0])).getModifiers())) {
            return Optional.empty();
        }
        return Optional.of(clazz);
    }

    public static CompiledTemplate slowPathTemplate(SoyCallSite callSite, String templateName, RenderContext context) {
        CompiledTemplates templates = context.getTemplates();
        CompiledTemplate template = templates.getTemplate(templateName);
        callSite.updateWithConstant(templates, CompiledTemplate.class, template);
        return template;
    }

    public static TemplateValue slowPathTemplateValue(SoyCallSite callSite, String templateName, RenderContext context) {
        CompiledTemplates templates = context.getTemplates();
        TemplateValue value = templates.getTemplateValue(templateName);
        callSite.updateWithConstant(templates, TemplateValue.class, value);
        return value;
    }

    public static RenderResult slowPathRenderPositional(SoyCallSite callSite, String templateName, SoyValueProvider[] params, LoggingAdvisingAppendable appendable, RenderContext context) throws Throwable {
        CompiledTemplates templates = context.getTemplates();
        MethodHandle renderMethod = templates.getPositionalRenderMethod(templateName, params.length);
        callSite.update(templates, renderMethod);
        Object[] args = ObjectArrays.concat((Object[])params, (Object[])new Object[]{appendable, context}, Object.class);
        return (RenderResult)renderMethod.invokeWithArguments(args);
    }

    public static RenderResult slowPathRenderRecord(SoyCallSite callSite, String templateName, ParamStore params, LoggingAdvisingAppendable appendable, RenderContext context) throws Throwable {
        CompiledTemplates templates = context.getTemplates();
        MethodHandle renderMethod = templates.getRenderMethod(templateName);
        callSite.update(templates, renderMethod);
        return renderMethod.invoke(params, appendable, context);
    }

    public static boolean isCacheValid(int currentTemplatesId, RenderContext context) {
        return currentTemplatesId == context.getTemplates().getId();
    }

    private static final class SoyCallSite
    extends MutableCallSite {
        private final MethodHandle test;
        private final MethodHandle slowPath;

        SoyCallSite(MethodType type, MethodHandle slowPath) {
            super(type);
            Preconditions.checkState((boolean)slowPath.type().parameterType(0).equals(SoyCallSite.class));
            slowPath = MethodHandles.insertArguments(slowPath, 0, this);
            int renderContextIndex = slowPath.type().parameterList().indexOf(RenderContext.class);
            Preconditions.checkState((renderContextIndex != -1 ? 1 : 0) != 0);
            this.slowPath = slowPath;
            this.test = MethodHandles.dropArgumentsToMatch(SlowPathHandles.IS_CACHE_VALID, 1, type.parameterList(), renderContextIndex);
            this.setTarget(slowPath);
        }

        void update(CompiledTemplates newTemplates, MethodHandle newTarget) {
            newTarget = MethodHandles.foldArguments(MethodHandles.exactInvoker(newTarget.type()), SlowPathHandles.WEAK_REF_GET.bindTo(new WeakReference<MethodHandle>(newTarget)).asType(SlowPathHandles.METHOD_HANDLE_TYPE));
            this.setTarget(MethodHandles.guardWithTest(MethodHandles.insertArguments(this.test, 0, newTemplates.getId()), newTarget, this.slowPath));
        }

        void updateWithConstant(CompiledTemplates newTemplates, Class<?> type, Object value) {
            MethodHandle fastPathHandle = MethodHandles.dropArgumentsToMatch(SlowPathHandles.WEAK_REF_GET.bindTo(new WeakReference<Object>(value)).asType(MethodType.methodType(type)), 0, this.type().parameterList(), 0);
            this.setTarget(MethodHandles.guardWithTest(MethodHandles.insertArguments(this.test, 0, newTemplates.getId()), fastPathHandle, this.slowPath));
        }
    }

    private static final class SlowPathHandles {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        private static final MethodHandle SLOWPATH_RENDER_RECORD = SlowPathHandles.findLocalStaticOrDie("slowPathRenderRecord", MethodType.methodType(RenderResult.class, SoyCallSite.class, String.class, ParamStore.class, LoggingAdvisingAppendable.class, RenderContext.class));
        private static final MethodHandle SLOWPATH_RENDER_POSITIONAL = SlowPathHandles.findLocalStaticOrDie("slowPathRenderPositional", MethodType.methodType(RenderResult.class, SoyCallSite.class, String.class, SoyValueProvider[].class, LoggingAdvisingAppendable.class, RenderContext.class));
        private static final MethodHandle SLOWPATH_TEMPLATE = SlowPathHandles.findLocalStaticOrDie("slowPathTemplate", MethodType.methodType(CompiledTemplate.class, SoyCallSite.class, String.class, RenderContext.class));
        private static final MethodHandle SLOWPATH_TEMPLATE_VALUE = SlowPathHandles.findLocalStaticOrDie("slowPathTemplateValue", MethodType.methodType(TemplateValue.class, SoyCallSite.class, String.class, RenderContext.class));
        private static final MethodHandle SLOWPATH_CONST = SlowPathHandles.findLocalStaticOrDie("slowPathConst", MethodType.methodType(Object.class, SoyCallSite.class, String.class, RenderContext.class));
        private static final MethodHandle SLOWPATH_EXTERN = SlowPathHandles.findLocalStaticOrDie("slowPathExtern", MethodType.methodType(Object.class, SoyCallSite.class, String.class, RenderContext.class, Object[].class));
        private static final MethodHandle IS_CACHE_VALID = SlowPathHandles.findLocalStaticOrDie("isCacheValid", MethodType.methodType(Boolean.TYPE, Integer.TYPE, RenderContext.class));
        private static final MethodType RENDER_TYPE = MethodType.methodType(RenderResult.class, ParamStore.class, LoggingAdvisingAppendable.class, RenderContext.class);
        private static final MethodType TEMPLATE_ACCESSOR_TYPE = MethodType.methodType(CompiledTemplate.class);
        private static final MethodType METHOD_HANDLE_TYPE = MethodType.methodType(MethodHandle.class);
        private static final MethodHandle WEAK_REF_GET;

        private static MethodHandle findLocalStaticOrDie(String name, MethodType type) {
            try {
                return LOOKUP.findStatic(ClassLoaderFallbackCallFactory.class, name, type);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }

        private SlowPathHandles() {
        }

        static {
            try {
                WEAK_REF_GET = LOOKUP.findVirtual(WeakReference.class, "get", MethodType.methodType(Object.class));
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
    }

    @VisibleForTesting
    public static interface AlwaysSlowPath {
    }
}

