/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.restricted.AutoValue_MethodRef;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
public abstract class MethodRef {
    private static final Handle INVOKE_HANDLE = MethodRef.createPure(ConstantBootstraps.class, "invoke", MethodHandles.Lookup.class, String.class, Class.class, MethodHandle.class, Object[].class).asHandle();
    public static final Type[] NO_METHOD_ARGS = new Type[0];

    public static MethodRef createNonPure(Class<?> clazz, String methodName, Class<?> ... params) {
        return MethodRef.create(MethodRef.getMethodUnchecked(clazz, methodName, params), MethodPureness.NON_PURE);
    }

    public static MethodRef createPure(Class<?> clazz, String methodName, Class<?> ... params) {
        return MethodRef.create(MethodRef.getMethodUnchecked(clazz, methodName, params), MethodPureness.PURE);
    }

    private static java.lang.reflect.Method getMethodUnchecked(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new VerifyException("Couldn't find the expected method among: " + Arrays.toString(clazz.getMethods()), (Throwable)e);
        }
    }

    public static MethodRef createNonPureConstructor(Class<?> clazz, Class<?> ... params) {
        return MethodRef.create(MethodRef.getConstructorUnchecked(clazz, params), MethodPureness.NON_PURE);
    }

    public static MethodRef createPureConstructor(Class<?> clazz, Class<?> ... params) {
        return MethodRef.create(MethodRef.getConstructorUnchecked(clazz, params), MethodPureness.PURE);
    }

    private static <T> Constructor<? extends T> getConstructorUnchecked(Class<T> clazz, Class<?> ... params) {
        try {
            return clazz.getConstructor(params);
        }
        catch (Exception e) {
            throw new VerifyException("Couldn't find the expected method among: " + Arrays.toString(clazz.getMethods()), (Throwable)e);
        }
    }

    public static MethodRef create(Executable method, MethodPureness pureness) {
        Class<?> clazz = method.getDeclaringClass();
        TypeInfo ownerType = TypeInfo.create(clazz);
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        boolean isConstructor = method instanceof Constructor;
        Method asmMethod = isConstructor ? Method.getMethod((Constructor)((Constructor)method)) : Method.getMethod((java.lang.reflect.Method)((java.lang.reflect.Method)method));
        ImmutableList argTypes = isStatic || isConstructor ? ImmutableList.copyOf((Object[])asmMethod.getArgumentTypes()) : ImmutableList.builder().add((Object)ownerType.type()).add((Object[])asmMethod.getArgumentTypes()).build();
        return new AutoValue_MethodRef(method instanceof Constructor ? 183 : (clazz.isInterface() ? 185 : (isStatic ? 184 : 182)), ownerType, method instanceof java.lang.reflect.Method ? Method.getMethod((java.lang.reflect.Method)((java.lang.reflect.Method)method)) : Method.getMethod((Constructor)((Constructor)method)), isConstructor ? ownerType.type() : asmMethod.getReturnType(), (ImmutableList<Type>)argTypes, MethodRef.featuresForMethod(method), pureness);
    }

    public static MethodRef createInterfaceMethod(TypeInfo owner, Method method, MethodPureness pureness) {
        Preconditions.checkArgument((boolean)owner.isInterface());
        return new AutoValue_MethodRef(185, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of(), pureness);
    }

    public static MethodRef createInstanceMethod(TypeInfo owner, Method method, MethodPureness pureness) {
        Preconditions.checkArgument((!owner.isInterface() ? 1 : 0) != 0);
        return new AutoValue_MethodRef(182, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of(), pureness);
    }

    public static MethodRef createStaticMethod(TypeInfo owner, Method method, MethodPureness pureness) {
        return new AutoValue_MethodRef(184, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object[])method.getArgumentTypes()).build(), Expression.Features.of(), pureness);
    }

    public static MethodRef createConstructorMethod(TypeInfo owner, MethodPureness pureness, Iterable<Type> argTypes) {
        Preconditions.checkState((!owner.isInterface() ? 1 : 0) != 0, (Object)"Constructors are not supported on interfaces.");
        ImmutableList argTypesList = ImmutableList.copyOf(argTypes);
        Method method = new Method("<init>", Type.VOID_TYPE, (Type[])argTypesList.toArray((Object[])new Type[0]));
        return new AutoValue_MethodRef(183, owner, method, owner.type(), (ImmutableList<Type>)argTypesList, Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, new Expression.Feature[0]), pureness);
    }

    private static Expression.Features featuresForMethod(Executable method) {
        boolean nonnull = method instanceof Constructor || method.isAnnotationPresent(Nonnull.class);
        return nonnull ? Expression.Features.of(Expression.Feature.NON_JAVA_NULLABLE, new Expression.Feature[0]) : Expression.Features.of();
    }

    abstract int opcode();

    public abstract TypeInfo owner();

    public abstract Method method();

    public abstract Type returnType();

    public abstract ImmutableList<Type> argTypes();

    public abstract Expression.Features features();

    public abstract MethodPureness pureness();

    public Handle asHandle() {
        int tag;
        switch (this.opcode()) {
            case 184: {
                tag = 6;
                break;
            }
            case 185: {
                tag = 9;
                break;
            }
            case 182: {
                tag = 5;
                break;
            }
            case 183: {
                Preconditions.checkState((boolean)this.method().getName().equals("<init>"));
                tag = 8;
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported opcode: " + this.opcode()));
            }
        }
        return new Handle(tag, this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.owner().isInterface());
    }

    boolean isInterfaceMethod() {
        return this.owner().isInterface() && this.opcode() == 185;
    }

    public Statement invokeVoid(Expression ... args) {
        return this.invokeVoid(Arrays.asList(args));
    }

    public Statement invokeVoid(final Iterable<? extends Expression> args) {
        Preconditions.checkState((boolean)Type.VOID_TYPE.equals((Object)this.returnType()), (Object)"Method return type is not void.");
        Expression.checkTypes(this.argTypes(), args);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                MethodRef.this.doInvoke(adapter, args);
            }
        };
    }

    public Expression invoke(Expression ... args) {
        return this.invoke(Arrays.asList(args));
    }

    public Expression invoke(final Iterable<? extends Expression> args) {
        Preconditions.checkState((!Type.VOID_TYPE.equals((Object)this.returnType()) ? 1 : 0) != 0, (Object)"Cannot produce an expression from a void method.");
        Expression.checkTypes(this.argTypes(), args);
        Expression.Features features = this.features();
        if (!Expression.areAllCheap(args)) {
            features = features.minus(Expression.Feature.CHEAP);
        }
        if (this.pureness() == MethodPureness.PURE && Expression.areAllConstant(args)) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.asHandle());
            SourceLocation loc = SourceLocation.UNKNOWN;
            for (Expression expression : args) {
                params.add(expression.constantBytecodeValue());
                SourceLocation argLoc = expression.location();
                if (!argLoc.isKnown()) continue;
                loc = loc.isKnown() ? loc.createSuperRangeWith(argLoc) : argLoc;
            }
            String name = this.method().getName();
            if (name.equals("<init>")) {
                name = "new";
            }
            return new Expression(this.returnType(), features, loc, Optional.of(Expression.ConstantValue.dynamic(new ConstantDynamic(name, this.returnType().getDescriptor(), INVOKE_HANDLE, params.toArray(new Object[0])), this.returnType(), false))){

                @Override
                protected void doGen(CodeBuilder mv) {
                    MethodRef.this.doInvoke(mv, args);
                }
            };
        }
        return new Expression(this.returnType(), features){

            @Override
            protected void doGen(CodeBuilder mv) {
                MethodRef.this.doInvoke(mv, args);
            }
        };
    }

    public MethodRef asCheap() {
        return this.withFeature(Expression.Feature.CHEAP);
    }

    public MethodRef asNonJavaNullable() {
        return this.withFeature(Expression.Feature.NON_JAVA_NULLABLE);
    }

    private MethodRef withFeature(Expression.Feature feature) {
        if (this.features().has(feature)) {
            return this;
        }
        return new AutoValue_MethodRef(this.opcode(), this.owner(), this.method(), this.returnType(), this.argTypes(), this.features().plus(feature), this.pureness());
    }

    public void invokeUnchecked(CodeBuilder cb) {
        cb.visitMethodInsn(this.opcode(), this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.owner().isInterface());
    }

    private void doInvoke(CodeBuilder mv, Iterable<? extends Expression> args) {
        if (this.method().getName().equals("<init>")) {
            mv.newInstance(this.returnType());
            mv.dup();
        }
        for (Expression expression : args) {
            expression.gen(mv);
        }
        this.invokeUnchecked(mv);
    }

    public static enum MethodPureness {
        PURE,
        NON_PURE;

    }
}

