/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.restricted.AutoValue_FieldRef;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

@AutoValue
public abstract class FieldRef {
    private static final Handle ENUM_CONSTANT_HANDLE = MethodRef.createPure(ConstantBootstraps.class, "enumConstant", MethodHandles.Lookup.class, String.class, Class.class).asHandle();
    private static final Handle GET_STATIC_FIELD_HANDLE = MethodRef.createPure(ConstantBootstraps.class, "getStaticFinal", MethodHandles.Lookup.class, String.class, Class.class, Class.class).asHandle();
    public static final FieldRef NULL_DATA = FieldRef.staticFieldReference(NullData.class, "INSTANCE").asNonJavaNullable();
    public static final FieldRef UNDEFINED_DATA = FieldRef.staticFieldReference(UndefinedData.class, "INSTANCE").asNonJavaNullable();
    public static final FieldRef EMPTY_STRING_DATA = FieldRef.staticFieldReference(StringData.class, "EMPTY_STRING").asNonJavaNullable();
    public static final FieldRef EMPTY_PARAMS = FieldRef.staticFieldReference(ParamStore.class, "EMPTY_INSTANCE").asNonJavaNullable();
    public static final FieldRef BOOLEAN_DATA_FALSE = FieldRef.staticFieldReference(BooleanData.class, "FALSE").asNonJavaNullable();
    public static final FieldRef BOOLEAN_DATA_TRUE = FieldRef.staticFieldReference(BooleanData.class, "TRUE").asNonJavaNullable();
    public static final FieldRef STACK_FRAME_STATE_NUMBER = FieldRef.instanceFieldReference(StackFrame.class, "stateNumber");
    private int accessFlags;
    private boolean isNullable;
    private static final int VISIBILITY_MASK = 7;

    public static FieldRef create(TypeInfo owner, String name, Type type, int modifiers, boolean isNullable) {
        if ((Modifier.fieldModifiers() & modifiers) != modifiers) {
            throw new IllegalArgumentException("invalid modifiers, expected: " + Modifier.toString(Modifier.fieldModifiers()) + " (" + Modifier.fieldModifiers() + ") got: " + Modifier.toString(modifiers) + " (" + modifiers + ")");
        }
        AutoValue_FieldRef ref = new AutoValue_FieldRef(owner, name, type);
        ref.accessFlags = modifiers;
        ref.isNullable = isNullable;
        return ref;
    }

    public static FieldRef create(TypeInfo owner, String name, Type fieldType, int modifiers) {
        return FieldRef.create(owner, name, fieldType, modifiers, !BytecodeUtils.isPrimitive(fieldType));
    }

    public static FieldRef instanceFieldReference(Class<?> owner, String name) {
        Class<?> fieldType;
        int modifiers = 0;
        try {
            Field declaredField = owner.getDeclaredField(name);
            modifiers = declaredField.getModifiers() & Modifier.fieldModifiers();
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalStateException("Field: " + String.valueOf(declaredField) + " is static");
            }
            fieldType = declaredField.getType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return FieldRef.create(TypeInfo.create(owner), name, Type.getType(fieldType), modifiers, !fieldType.isPrimitive());
    }

    public static FieldRef staticFieldReference(Class<?> owner, String name) {
        Field declaredField;
        try {
            declaredField = owner.getDeclaredField(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return FieldRef.staticFieldReference(declaredField);
    }

    public static FieldRef staticFieldReference(Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException("Field: " + String.valueOf(field) + " is not static");
        }
        return FieldRef.create(TypeInfo.create(field.getDeclaringClass()), field.getName(), Type.getType(field.getType()), field.getModifiers() & Modifier.fieldModifiers(), false);
    }

    public static <T extends Enum<T>> FieldRef enumReference(T enumInstance) {
        return FieldRef.staticFieldReference(enumInstance.getDeclaringClass(), enumInstance.name());
    }

    public static FieldRef createPublicStaticField(TypeInfo owner, String name, Type type) {
        return FieldRef.create(owner, name, type, 25, !BytecodeUtils.isPrimitive(type));
    }

    public abstract TypeInfo owner();

    public abstract String name();

    public abstract Type type();

    public final boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    @CanIgnoreReturnValue
    public final FieldRef setVisibility(int visibility) {
        Preconditions.checkArgument((visibility % 7 == visibility ? 1 : 0) != 0);
        this.accessFlags = this.accessFlags & 0xFFFFFFF8 | visibility;
        return this;
    }

    public void defineField(ClassVisitor cv) {
        cv.visitField(this.accessFlags, this.name(), this.type().getDescriptor(), null, null);
    }

    @CanIgnoreReturnValue
    public FieldRef asNonJavaNullable() {
        this.isNullable = false;
        return this;
    }

    public Expression accessor(final Expression owner) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)owner.resultType().equals((Object)this.owner().type()), (String)"Unexpected type: %s expected %s", (Object)owner.resultType(), (Object)this.owner().type());
        Expression.Features features = Expression.Features.of();
        if (owner.isCheap()) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (!this.isNullable) {
            features = features.plus(Expression.Feature.NON_JAVA_NULLABLE);
        }
        return new Expression(this.type(), features){

            @Override
            protected void doGen(CodeBuilder mv) {
                owner.gen(mv);
                mv.getField(FieldRef.this.owner().type(), FieldRef.this.name(), this.resultType());
            }
        };
    }

    public Expression accessor() {
        Preconditions.checkState((boolean)this.isStatic());
        Expression.Features features = Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]);
        if (!this.isNullable) {
            features = features.plus(Expression.Feature.NON_JAVA_NULLABLE);
        }
        if (this.isFinal()) {
            ConstantDynamic constant = this.owner().classOptional().map(Class::isEnum).orElse(false) != false ? new ConstantDynamic(this.name(), this.type().getDescriptor(), ENUM_CONSTANT_HANDLE, new Object[0]) : new ConstantDynamic(this.name(), this.type().getDescriptor(), GET_STATIC_FIELD_HANDLE, new Object[]{this.owner().type()});
            return new Expression(this.type(), Expression.ConstantValue.dynamic(constant, this.type(), true), features){

                @Override
                protected void doGen(CodeBuilder mv) {
                    FieldRef.this.accessStaticUnchecked(mv);
                }
            };
        }
        return new Expression(this.type(), features){

            @Override
            protected void doGen(CodeBuilder mv) {
                FieldRef.this.accessStaticUnchecked(mv);
            }
        };
    }

    void accessStaticUnchecked(CodeBuilder mv) {
        Preconditions.checkState((boolean)this.isStatic());
        mv.getStatic(this.owner().type(), this.name(), this.type());
    }

    public Statement putInstanceField(final Expression instance, final Expression value) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (Object)"This field is static!");
        instance.checkAssignableTo(this.owner().type());
        value.checkAssignableTo(this.type());
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                instance.gen(adapter);
                value.gen(adapter);
                FieldRef.this.putUnchecked(adapter);
            }
        };
    }

    public Statement putStaticField(final Expression value) {
        Preconditions.checkState((boolean)this.isStatic(), (Object)"This field is not static!");
        value.checkAssignableTo(this.type());
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                value.gen(adapter);
                adapter.putStatic(FieldRef.this.owner().type(), FieldRef.this.name(), FieldRef.this.type());
            }
        };
    }

    public void putUnchecked(CodeBuilder adapter) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (Object)"This field is static!");
        adapter.putField(this.owner().type(), this.name(), this.type());
    }
}

