/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;

public final class Branch {
    private final Expression.Features features;
    private final boolean isNegated;
    private final Brancher brancher;
    private final Supplier<String> debugPrinter;
    private final Optional<Label> startLabel;
    private static final Brancher NEVER = (adapter, ifTrue, negate) -> {
        if (negate) {
            adapter.goTo(ifTrue);
        }
    };

    private Branch(Expression.Features features, Brancher brancher, Supplier<String> debugPrinter) {
        this(false, features, brancher, debugPrinter, Optional.empty());
    }

    private Branch(boolean isNegated, Expression.Features features, Brancher brancher, Supplier<String> debugPrinter, Optional<Label> startLlabel) {
        this.isNegated = isNegated;
        this.features = features;
        this.brancher = brancher;
        this.debugPrinter = debugPrinter;
        this.startLabel = startLlabel;
    }

    public void branchTo(CodeBuilder adapter, Label ifTrue) {
        if (this.startLabel.isPresent()) {
            adapter.mark(this.startLabel.get());
        }
        this.brancher.gen(adapter, ifTrue, this.isNegated);
    }

    public Branch labelStart(Label label) {
        Preconditions.checkState((boolean)this.startLabel.isEmpty());
        return new Branch(this.isNegated, this.features, this.brancher, this.debugPrinter, Optional.of(label));
    }

    public Branch negate() {
        return new Branch(!this.isNegated, this.features, this.brancher, this.debugPrinter, this.startLabel);
    }

    public Expression asBoolean() {
        if (this.brancher instanceof BooleanBrancher && !this.isNegated) {
            return ((BooleanBrancher)this.brancher).booleanExpression;
        }
        return new BranchToBoolean(this.features, this, SourceLocation.UNKNOWN);
    }

    public static Branch and(Branch ... options) {
        return Branch.makeComposedBranch((List<Branch>)ImmutableList.copyOf((Object[])options), CompositionMode.AND);
    }

    public static Branch or(Branch ... options) {
        return Branch.makeComposedBranch((List<Branch>)ImmutableList.copyOf((Object[])options), CompositionMode.OR);
    }

    public static Branch or(List<Branch> options) {
        return Branch.makeComposedBranch(options, CompositionMode.OR);
    }

    private static Branch makeComposedBranch(List<Branch> branches, CompositionMode mode) {
        if (branches.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (branches.size() == 1) {
            return branches.get(0);
        }
        Expression.Features features = branches.get((int)0).features;
        for (int i = 1; i < branches.size(); ++i) {
            features = features.intersect(branches.get((int)i).features);
        }
        return new Branch(features, new ComposedBrancher((ImmutableList<Branch>)ImmutableList.copyOf(branches), mode), () -> String.valueOf((Object)mode) + "(" + String.valueOf(branches) + ")");
    }

    public Expression ternary(Type resultType, final Expression ifTrue, final Expression ifFalse) {
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(resultType, ifTrue.resultType()), (String)"expected %s to be assignable to %s", (Object)ifTrue.resultType(), (Object)resultType);
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(resultType, ifFalse.resultType()), (String)"expected %s to be assignable to %s", (Object)ifFalse.resultType(), (Object)resultType);
        if (this.isNegated) {
            return this.negate().ternary(resultType, ifFalse, ifTrue);
        }
        Expression.Features features = Expression.Features.of();
        if (features.has(Expression.Feature.CHEAP) && ifTrue.isCheap() && ifFalse.isCheap()) {
            features = features.plus(Expression.Feature.CHEAP);
        }
        if (ifTrue.isNonJavaNullable() && ifFalse.isNonJavaNullable()) {
            features = features.plus(Expression.Feature.NON_JAVA_NULLABLE);
        }
        if (ifTrue.isNonSoyNullish() && ifFalse.isNonSoyNullish()) {
            features = features.plus(Expression.Feature.NON_SOY_NULLISH);
        }
        if (resultType.equals((Object)Type.BOOLEAN_TYPE)) {
            Branch ifTrueBranch = Branch.ifTrue(ifTrue);
            Branch ifFalseBranch = Branch.ifTrue(ifFalse);
            Branch ternary = this;
            return new Branch(features, (adapter, ifTrueLabel, negate) -> {
                Label ifTernaryTrue = new Label();
                Label end = new Label();
                ternary.branchTo(adapter, ifTernaryTrue);
                (negate ? ifFalseBranch.negate() : ifFalseBranch).branchTo(adapter, ifTrueLabel);
                adapter.goTo(end);
                adapter.mark(ifTernaryTrue);
                (negate ? ifTrueBranch.negate() : ifTrueBranch).branchTo(adapter, ifTrueLabel);
                adapter.mark(end);
            }, () -> "ternary(" + String.valueOf(this) + ", " + String.valueOf(ifTrueBranch) + ", " + String.valueOf(ifFalseBranch) + ")").asBoolean();
        }
        return new Expression(resultType, features){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label ifTrueLabel = new Label();
                Label end = new Label();
                Branch.this.branchTo(adapter, ifTrueLabel);
                ifFalse.gen(adapter);
                adapter.goTo(end);
                adapter.mark(ifTrueLabel);
                ifTrue.gen(adapter);
                adapter.mark(end);
            }
        };
    }

    public static Branch ifTrue(Expression expression) {
        if (expression instanceof SoyExpression) {
            return Branch.ifTrue(((SoyExpression)expression).delegate);
        }
        Preconditions.checkState((boolean)expression.resultType().equals((Object)Type.BOOLEAN_TYPE));
        if (expression instanceof BranchToBoolean) {
            return ((BranchToBoolean)expression).branch;
        }
        return new Branch(expression.features(), new BooleanBrancher(expression), () -> "ifTrue (" + String.valueOf(expression) + ")");
    }

    public static Branch ifNonSoyNullish(Expression expression) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, expression.resultType())) {
            if (expression.isNonSoyNullish()) {
                return Branch.always();
            }
            if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, expression.resultType())) {
                return new Branch(expression.features(), new BooleanBrancher(MethodRefs.SOY_VALUE_IS_NULLISH.invoke(expression)), () -> "ifSoyNullish{" + String.valueOf(expression) + "}").negate();
            }
            return new Branch(expression.features(), new BooleanBrancher(MethodRefs.IS_SOY_NON_NULLISH.invoke(expression)), () -> "ifSoyNullish{" + String.valueOf(expression) + "}");
        }
        if (expression.isNonJavaNullable()) {
            return Branch.always();
        }
        return Branch.ifNonJavaNull(expression);
    }

    public static Branch ifNonSoyNull(Expression expression) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, expression.resultType())) {
            if (expression.isNonSoyNullish()) {
                return Branch.always();
            }
            return new Branch(expression.features(), new BooleanBrancher(MethodRefs.SOY_VALUE_IS_NULL.invoke(expression)), () -> "ifSoyNull{" + String.valueOf(expression) + "}").negate();
        }
        if (expression.isNonJavaNullable()) {
            return Branch.always();
        }
        return Branch.ifNonJavaNull(expression);
    }

    public static Branch ifNonSoyUndefined(Expression expression) {
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, expression.resultType())) {
            if (expression.isNonSoyNullish()) {
                return Branch.always();
            }
            return new Branch(expression.features(), new BooleanBrancher(MethodRefs.SOY_VALUE_IS_UNDEFINED.invoke(expression)), () -> "ifSoyUndefined{" + String.valueOf(expression) + "}").negate();
        }
        return Branch.always();
    }

    public static Branch ifNonJavaNull(Expression expression) {
        Preconditions.checkState((!BytecodeUtils.isPrimitive(expression.resultType()) ? 1 : 0) != 0);
        return new Branch(expression.features(), (adapter, ifTrue, negate) -> {
            expression.gen(adapter);
            if (negate) {
                adapter.ifNull(ifTrue);
            } else {
                adapter.ifNonNull(ifTrue);
            }
        }, () -> "ifNonNull{" + String.valueOf(expression) + "}");
    }

    public static Branch never() {
        return new Branch(Expression.Features.of(Expression.Feature.CHEAP, new Expression.Feature[0]), NEVER, () -> "never");
    }

    public static Branch always() {
        return Branch.never().negate();
    }

    public static Branch ifNotZero(Expression expression) {
        Preconditions.checkState((boolean)expression.resultType().equals((Object)Type.LONG_TYPE));
        return Branch.compare(154, expression, BytecodeUtils.constant(0L));
    }

    public static Branch ifEqual(Expression left, Expression right) {
        return Branch.compare(153, left, right);
    }

    public static Branch compare(int comparisonOpcode, Expression left, Expression right) {
        Preconditions.checkState((boolean)left.resultType().equals((Object)right.resultType()));
        Preconditions.checkState((boolean)BytecodeUtils.isPrimitive(left.resultType()));
        Branch.checkIntComparisonOpcode(left.resultType(), comparisonOpcode);
        return new Branch(left.features().intersect(right.features()), (adapter, ifTrue, negate) -> {
            int cmp;
            left.gen(adapter);
            right.gen(adapter);
            int n = cmp = negate ? Branch.negateComparisonOpcode(comparisonOpcode) : comparisonOpcode;
            if (Branch.isOrderingOpcode(cmp) && negate && (left.resultType().getSort() == 6 || left.resultType().getSort() == 8)) {
                boolean isGreaterThanIsh;
                boolean isFloat = left.resultType().getSort() == 6;
                boolean bl = isGreaterThanIsh = cmp == 156 || cmp == 157;
                if (isFloat) {
                    adapter.visitInsn(isGreaterThanIsh ? 150 : 149);
                } else {
                    adapter.visitInsn(isGreaterThanIsh ? 152 : 151);
                }
                adapter.visitJumpInsn(cmp, ifTrue);
            } else {
                adapter.ifCmp(right.resultType(), cmp, ifTrue);
            }
        }, () -> "compare" + Printer.OPCODES[comparisonOpcode] + "(" + String.valueOf(left) + ", " + String.valueOf(right) + ")");
    }

    private static boolean isOrderingOpcode(int opcode) {
        switch (opcode) {
            case 153: 
            case 154: {
                return false;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode: " + Printer.OPCODES[opcode]);
    }

    private static int negateComparisonOpcode(int opcode) {
        switch (opcode) {
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 157: {
                return 158;
            }
            case 156: {
                return 155;
            }
            case 155: {
                return 156;
            }
            case 158: {
                return 157;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + Printer.OPCODES[opcode]);
    }

    private static void checkIntComparisonOpcode(Type comparisonType, int opcode) {
        switch (opcode) {
            case 153: 
            case 154: {
                return;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (comparisonType.getSort() == 9 || comparisonType.getSort() == 10) {
                    throw new IllegalArgumentException("Type: " + String.valueOf(comparisonType) + " cannot be compared via " + Printer.OPCODES[opcode]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported opcode for comparison operation: " + Printer.OPCODES[opcode]);
    }

    public String toString() {
        return "Branch{negate: " + this.isNegated + "," + this.debugPrinter.get() + "}";
    }

    private static final class ComposedBrancher
    implements Brancher {
        final ImmutableList<Branch> branches;
        final CompositionMode mode;

        ComposedBrancher(ImmutableList<Branch> branches, CompositionMode mode) {
            this.branches = branches;
            this.mode = mode;
        }

        @Override
        public void gen(CodeBuilder adapter, Label ifTrue, boolean negate) {
            CompositionMode mode = this.mode;
            ImmutableList branches = this.branches;
            if (negate) {
                mode = mode == CompositionMode.AND ? CompositionMode.OR : CompositionMode.AND;
                branches = (ImmutableList)branches.stream().map(Branch::negate).collect(ImmutableList.toImmutableList());
            }
            if (mode == CompositionMode.AND) {
                Label ifFalse = new Label();
                for (int i = 0; i < branches.size() - 1; ++i) {
                    ((Branch)branches.get(i)).negate().branchTo(adapter, ifFalse);
                }
                ((Branch)Iterables.getLast((Iterable)branches)).branchTo(adapter, ifTrue);
                adapter.mark(ifFalse);
            } else {
                for (Branch branch : branches) {
                    branch.branchTo(adapter, ifTrue);
                }
            }
        }

        boolean maybeDirectlyEvaluateAsBoolean(CodeBuilder adapter, boolean negate) {
            ImmutableList branches;
            CompositionMode mode;
            if (negate) {
                mode = this.mode == CompositionMode.AND ? CompositionMode.OR : CompositionMode.AND;
                branches = (ImmutableList)this.branches.stream().map(Branch::negate).collect(ImmutableList.toImmutableList());
            } else {
                mode = this.mode;
                branches = this.branches;
            }
            Branch finalBranch = (Branch)Iterables.getLast(branches);
            if (!(finalBranch.brancher instanceof BooleanBrancher) || finalBranch.isNegated) {
                return false;
            }
            Expression finalBoolean = ((BooleanBrancher)finalBranch.brancher).booleanExpression;
            if (mode == CompositionMode.AND) {
                Label ifFalse = new Label();
                for (int i = 0; i < branches.size() - 1; ++i) {
                    ((Branch)branches.get(i)).negate().branchTo(adapter, ifFalse);
                }
                finalBoolean.gen(adapter);
                Label end = new Label();
                adapter.goTo(end);
                adapter.mark(ifFalse);
                adapter.pushBoolean(false);
                adapter.mark(end);
            } else {
                Label ifTrue = new Label();
                for (int i = 0; i < branches.size() - 1; ++i) {
                    ((Branch)branches.get(i)).branchTo(adapter, ifTrue);
                }
                Label end = new Label();
                finalBoolean.gen(adapter);
                adapter.goTo(end);
                adapter.mark(ifTrue);
                adapter.pushBoolean(true);
                adapter.mark(end);
            }
            return true;
        }
    }

    private static enum CompositionMode {
        AND,
        OR;

    }

    private static interface Brancher {
        public void gen(CodeBuilder var1, Label var2, boolean var3);
    }

    private static final class BooleanBrancher
    implements Brancher {
        final Expression booleanExpression;

        BooleanBrancher(Expression booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        @Override
        public void gen(CodeBuilder adapter, Label ifTrue, boolean negated) {
            this.booleanExpression.gen(adapter);
            adapter.ifZCmp(negated ? 153 : 154, ifTrue);
        }
    }

    private static class BranchToBoolean
    extends Expression {
        private final Branch branch;

        BranchToBoolean(Expression.Features features, Branch branch, SourceLocation location) {
            super(Type.BOOLEAN_TYPE, features, location, branch.brancher == NEVER ? Optional.of(branch.isNegated ? BytecodeUtils.CONSTANT_TRUE : BytecodeUtils.CONSTANT_FALSE) : Optional.empty());
            this.branch = branch;
            Preconditions.checkState((!(branch.brancher instanceof BooleanBrancher) || branch.isNegated ? 1 : 0) != 0);
        }

        @Override
        protected void doGen(CodeBuilder adapter) {
            boolean evaluated;
            if (this.branch.brancher == NEVER) {
                if (this.branch.isNegated) {
                    adapter.pushBoolean(true);
                } else {
                    adapter.pushBoolean(false);
                }
                return;
            }
            if (this.branch.brancher instanceof ComposedBrancher && (evaluated = ((ComposedBrancher)this.branch.brancher).maybeDirectlyEvaluateAsBoolean(adapter, this.branch.isNegated))) {
                return;
            }
            Label ifTrue = new Label();
            Label end = new Label();
            this.branch.branchTo(adapter, ifTrue);
            adapter.pushBoolean(false);
            adapter.goTo(end);
            adapter.mark(ifTrue);
            adapter.pushBoolean(true);
            adapter.mark(end);
        }

        @Override
        public BranchToBoolean withSourceLocation(SourceLocation location) {
            Preconditions.checkNotNull((Object)location);
            if (location.equals(this.location)) {
                return this;
            }
            return new BranchToBoolean(this.features(), this.branch, location);
        }

        @Override
        public BranchToBoolean asCheap() {
            if (this.isCheap()) {
                return this;
            }
            return new BranchToBoolean(this.features().plus(Expression.Feature.CHEAP), this.branch, this.location);
        }

        @Override
        public BranchToBoolean asNonJavaNullable() {
            if (this.isNonJavaNullable()) {
                return this;
            }
            return new BranchToBoolean(this.features().plus(Expression.Feature.NON_JAVA_NULLABLE), this.branch, this.location);
        }

        @Override
        public BranchToBoolean asJavaNullable() {
            if (!this.isNonJavaNullable()) {
                return this;
            }
            return new BranchToBoolean(this.features().minus(Expression.Feature.NON_JAVA_NULLABLE), this.branch, this.location);
        }

        @Override
        public BranchToBoolean labelStart(Label label) {
            return new BranchToBoolean(this.features(), this.branch.labelStart(label), this.location);
        }

        @Override
        public BranchToBoolean labelEnd(Label label) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Expression withConstantValue(Expression.ConstantValue constantValue) {
            throw new UnsupportedOperationException();
        }
    }
}

