/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;

public final class InnerClasses {
    private final TypeInfo outer;
    private final Map<TypeInfo, ClassData> innerClasses = new LinkedHashMap<TypeInfo, ClassData>();
    private final Map<TypeInfo, Integer> innerClassesAccessModifiers = new LinkedHashMap<TypeInfo, Integer>();
    private final UniqueNameGenerator classNames = JbcSrcNameGenerators.forClassNames();

    public InnerClasses(TypeInfo outer) {
        this.outer = outer;
    }

    public ImmutableList<ClassData> getInnerClassData() {
        return ImmutableList.copyOf(this.innerClasses.values());
    }

    public TypeInfo registerInnerClass(String simpleName, int accessModifiers) {
        this.classNames.exact(simpleName);
        TypeInfo innerClass = this.outer.innerClass(simpleName);
        this.innerClassesAccessModifiers.put(innerClass, accessModifiers);
        return innerClass;
    }

    public TypeInfo registerInnerClassWithGeneratedName(String simpleName, int accessModifiers) {
        simpleName = this.classNames.generate(simpleName);
        TypeInfo innerClass = this.outer.innerClass(simpleName);
        this.innerClassesAccessModifiers.put(innerClass, accessModifiers);
        return innerClass;
    }

    public void add(ClassData classData) {
        this.checkRegistered(classData.type());
        this.innerClasses.put(classData.type(), classData);
    }

    private void checkRegistered(TypeInfo type) {
        if (!this.classNames.has(type.simpleName())) {
            throw new IllegalArgumentException(String.valueOf(type) + " wasn't registered");
        }
    }

    public void registerAsInnerClass(ClassVisitor visitor, TypeInfo innerClass) {
        this.checkRegistered(innerClass);
        this.doRegister(visitor, innerClass);
    }

    public void registerAllInnerClasses(ClassVisitor visitor) {
        for (Map.Entry<TypeInfo, Integer> entry : this.innerClassesAccessModifiers.entrySet()) {
            TypeInfo innerClass = entry.getKey();
            this.doRegister(visitor, innerClass);
        }
    }

    private void doRegister(ClassVisitor visitor, TypeInfo innerClass) {
        visitor.visitInnerClass(innerClass.internalName(), this.outer.internalName(), innerClass.simpleName(), this.innerClassesAccessModifiers.get(innerClass).intValue());
    }
}

