/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_SaveRestoreState;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_VarKey;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.SaveStateMetaFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class TemplateVariableManager
implements LocalVariableManager {
    private ScopeImpl activeScope;
    private final SimpleLocalVariableManager delegate;
    private static final Handle BOOTSTRAP_SAVE_HANDLE = MethodRef.createPure(SaveStateMetaFactory.class, "bootstrapSaveState", MethodHandles.Lookup.class, String.class, MethodType.class).asHandle();
    private static final Handle BOOTSTRAP_RESTORE_HANDLE = MethodRef.createPure(SaveStateMetaFactory.class, "bootstrapRestoreState", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, Integer.TYPE).asHandle();

    TemplateVariableManager(Type owner, Type[] methodArguments, ImmutableList<String> parameterNames, Label methodBegin, Label methodEnd, boolean isStatic) {
        this.delegate = new SimpleLocalVariableManager(owner, methodArguments, (List<String>)parameterNames, methodBegin, methodEnd, isStatic);
        this.activeScope = new ScopeImpl();
        this.delegate.allActiveVariables().forEach((key, value) -> this.activeScope.variablesByKey.put(VarKey.create(key), new TrivialVariable((Expression)value)));
    }

    public void updateParameterTypes(Type[] parameterTypes, List<String> parameterNames) {
        this.delegate.updateParameterTypes(parameterTypes, parameterNames);
    }

    @Override
    public Scope enterScope() {
        return new ScopeImpl();
    }

    @Override
    public void generateTableEntries(CodeBuilder ga) {
        this.delegate.generateTableEntries(ga);
    }

    @Override
    public Expression getVariable(String name) {
        return this.getVariable(VarKey.create(name));
    }

    Expression getVariable(SyntheticVarName name) {
        return this.getVariable(VarKey.create(name));
    }

    private Expression getVariable(VarKey varKey) {
        return this.activeScope.getVariable(varKey);
    }

    void assertSaveRestoreStateIsEmpty() {
        Preconditions.checkState((boolean)this.activeScope.allVariables().noneMatch(v -> v instanceof Variable));
    }

    private static Type simplifyType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return BytecodeUtils.OBJECT.type();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type;
            }
        }
        throw new AssertionError((Object)("unsupported type: " + String.valueOf(type)));
    }

    SaveRestoreState saveRestoreState(final RenderContextExpression renderContextExpression, final int stateNumber) {
        ImmutableList restoresInOrder = (ImmutableList)this.activeScope.allVariables().filter(v -> !(v instanceof TrivialVariable)).map(v -> (Variable)v).collect(ImmutableList.toImmutableList());
        final ImmutableList storesToPerform = (ImmutableList)restoresInOrder.stream().filter(v -> v.strategy == SaveStrategy.STORE).sorted(Comparator.comparing(v -> v.accessor().resultType().getSort())).collect(ImmutableList.toImmutableList());
        ArrayList<Type> methodTypeParams = new ArrayList<Type>();
        methodTypeParams.add(BytecodeUtils.RENDER_CONTEXT_TYPE);
        methodTypeParams.add(Type.INT_TYPE);
        for (Variable variable2 : storesToPerform) {
            methodTypeParams.add(TemplateVariableManager.simplifyType(variable2.accessor().resultType()));
        }
        final Type saveStateMethodType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])methodTypeParams.toArray(new Type[0]));
        Statement saveState = new Statement(this){

            @Override
            protected void doGen(CodeBuilder cb) {
                renderContextExpression.gen(cb);
                cb.pushInt(stateNumber);
                for (Variable var : storesToPerform) {
                    var.accessor().gen(cb);
                }
                cb.visitInvokeDynamicInsn("save", saveStateMethodType.getDescriptor(), BOOTSTRAP_SAVE_HANDLE, new Object[0]);
            }
        };
        ImmutableMap storeToSlotIndex = (ImmutableMap)IntStream.range(0, storesToPerform.size()).boxed().collect(ImmutableMap.toImmutableMap(arg_0 -> storesToPerform.get(arg_0), index -> index));
        ImmutableList variablesToRestoreFromStorage = (ImmutableList)restoresInOrder.stream().filter(v -> v.strategy == SaveStrategy.STORE).collect(ImmutableList.toImmutableList());
        Optional restoreFromFrame = variablesToRestoreFromStorage.isEmpty() ? Optional.empty() : Optional.of(stackFrameVar -> new Statement(this, (LocalVariable)stackFrameVar, variablesToRestoreFromStorage, saveStateMethodType, storeToSlotIndex){
            final /* synthetic */ LocalVariable val$stackFrameVar;
            final /* synthetic */ ImmutableList val$variablesToRestoreFromStorage;
            final /* synthetic */ Type val$saveStateMethodType;
            final /* synthetic */ ImmutableMap val$storeToSlotIndex;
            {
                this.val$stackFrameVar = localVariable;
                this.val$variablesToRestoreFromStorage = immutableList;
                this.val$saveStateMethodType = type;
                this.val$storeToSlotIndex = immutableMap;
            }

            @Override
            protected void doGen(CodeBuilder cb) {
                this.val$stackFrameVar.loadUnchecked(cb);
                for (int i = 0; i < this.val$variablesToRestoreFromStorage.size(); ++i) {
                    if (i < this.val$variablesToRestoreFromStorage.size() - 1) {
                        cb.dup();
                    }
                    Variable variableToRestore = (Variable)this.val$variablesToRestoreFromStorage.get(i);
                    Type varType = variableToRestore.accessor().resultType();
                    cb.visitInvokeDynamicInsn("restoreLocal", Type.getMethodType((Type)varType, (Type[])new Type[]{BytecodeUtils.STACK_FRAME_TYPE}).getDescriptor(), BOOTSTRAP_RESTORE_HANDLE, new Object[]{this.val$saveStateMethodType, this.val$storeToSlotIndex.get((Object)variableToRestore)});
                    variableToRestore.local.storeUnchecked(cb);
                }
            }
        });
        ImmutableList restoreDerivedVariables = (ImmutableList)restoresInOrder.stream().filter(var -> var.strategy == SaveStrategy.DERIVED).map(v -> v.local.store(v.initExpression)).collect(ImmutableList.toImmutableList());
        return new AutoValue_TemplateVariableManager_SaveRestoreState(saveState, !restoreFromFrame.isPresent() && restoreDerivedVariables.isEmpty() ? Optional.empty() : Optional.of(variable -> Statement.concat(restoreFromFrame.orElse(v -> Statement.NULL_STATEMENT).apply((LocalVariable)variable), Statement.concat((Iterable<? extends Statement>)restoreDerivedVariables))));
    }

    @AutoValue
    static abstract class SaveRestoreState {
        SaveRestoreState() {
        }

        abstract Statement save();

        abstract Optional<Function<LocalVariable, Statement>> restore();
    }

    private class ScopeImpl
    extends Scope {
        final ScopeImpl parent;
        final LocalVariableManager.Scope delegateScope;
        final List<VarKey> activeVariables;
        final Map<VarKey, AbstractVariable> variablesByKey;

        ScopeImpl() {
            this.delegateScope = TemplateVariableManager.this.delegate.enterScope();
            this.activeVariables = new ArrayList<VarKey>();
            this.variablesByKey = new LinkedHashMap<VarKey, AbstractVariable>();
            this.parent = TemplateVariableManager.this.activeScope;
            TemplateVariableManager.this.activeScope = this;
        }

        @Override
        void createTrivial(String name, Expression expression) {
            this.putVariable(VarKey.create(name), new TrivialVariable(expression));
        }

        @Override
        Variable createSynthetic(SyntheticVarName varName, Expression initExpr, SaveStrategy strategy) {
            return this.doCreate("$" + varName.name(), initExpr, VarKey.create(varName), strategy);
        }

        @Override
        Variable create(String name, Expression initExpr, SaveStrategy strategy) {
            return this.doCreate(name, initExpr, VarKey.create(name), strategy);
        }

        @Override
        public LocalVariable createTemporary(String proposedName, Type type) {
            return this.delegateScope.createTemporary(proposedName, type);
        }

        @Override
        public LocalVariable createNamedLocal(String name, Type type) {
            LocalVariable var = this.delegateScope.createNamedLocal(name, type);
            this.putVariable(VarKey.create(name), new TrivialVariable(var));
            return var;
        }

        @Override
        public Statement exitScope() {
            for (VarKey key : this.activeVariables) {
                AbstractVariable var = this.variablesByKey.remove(key);
                if (var != null) continue;
                throw new IllegalStateException("no variable active for key: " + String.valueOf(key));
            }
            TemplateVariableManager.this.activeScope = this.parent;
            return this.delegateScope.exitScope();
        }

        Variable doCreate(String proposedName, Expression initExpr, VarKey key, SaveStrategy strategy) {
            Variable var = new Variable(initExpr, this.delegateScope.createTemporary(proposedName, initExpr.resultType()), strategy);
            this.putVariable(key, var);
            return var;
        }

        void putVariable(VarKey key, AbstractVariable var) {
            AbstractVariable old = this.variablesByKey.put(key, var);
            if (old != null) {
                throw new IllegalStateException("multiple variables active for key: " + String.valueOf(key));
            }
            this.activeVariables.add(key);
        }

        Expression getVariable(VarKey key) {
            AbstractVariable variable = this.variablesByKey.get(key);
            if (variable == null) {
                if (this.parent != null) {
                    return this.parent.getVariable(key);
                }
                throw new IllegalStateException("no variable: '" + String.valueOf(key) + "' is bound. " + String.valueOf(this.variablesByKey.keySet()) + " are in scope");
            }
            return variable.accessor();
        }

        Stream<AbstractVariable> allVariables() {
            Stream<AbstractVariable> direct = this.variablesByKey.values().stream();
            if (this.parent != null) {
                return Streams.concat((Stream[])new Stream[]{this.parent.allVariables(), direct});
            }
            return direct;
        }
    }

    static final class Variable
    extends AbstractVariable {
        private final Expression initExpression;
        private final LocalVariable local;
        private final SaveStrategy strategy;
        private final Statement initializer;

        private Variable(Expression initExpression, LocalVariable local, SaveStrategy strategy) {
            this.initExpression = initExpression;
            if (initExpression.isNonJavaNullable()) {
                local = local.asNonJavaNullable();
            }
            if (initExpression.isNonSoyNullish()) {
                local = local.asNonSoyNullish();
            }
            this.local = local;
            this.initializer = local.initialize(initExpression);
            this.strategy = strategy;
        }

        Statement initializer() {
            return this.initializer;
        }

        @Override
        Expression accessor() {
            return this.local();
        }

        LocalVariable local() {
            return this.local;
        }
    }

    private static final class TrivialVariable
    extends AbstractVariable {
        final Expression accessor;

        TrivialVariable(Expression accessor) {
            this.accessor = accessor;
        }

        @Override
        Expression accessor() {
            return this.accessor;
        }
    }

    private static abstract class AbstractVariable {
        private AbstractVariable() {
        }

        abstract Expression accessor();
    }

    @AutoValue
    static abstract class VarKey {
        VarKey() {
        }

        static VarKey create(String proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.USER_DEFINED, proposedName);
        }

        static VarKey create(SyntheticVarName proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.SYNTHETIC, proposedName);
        }

        abstract Kind kind();

        abstract Object name();

        static enum Kind {
            USER_DEFINED,
            SYNTHETIC;

        }
    }

    static abstract class Scope
    implements LocalVariableManager.Scope {
        private Scope() {
        }

        abstract void createTrivial(String var1, Expression var2);

        abstract Variable createSynthetic(SyntheticVarName var1, Expression var2, SaveStrategy var3);

        abstract Variable create(String var1, Expression var2, SaveStrategy var3);
    }

    static enum SaveStrategy {
        DERIVED,
        STORE;

    }
}

