/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_PrintDirectives_AppendableAndFlushBuffersDepth;
import com.google.template.soy.jbcsrc.AutoValue_PrintDirectives_StreamingDirectiveWithArgs;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import java.util.ArrayList;
import java.util.List;

final class PrintDirectives {
    static boolean areAllPrintDirectivesStreamable(PrintNode node) {
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            if (directiveNode.getPrintDirective() instanceof SoyJbcSrcPrintDirective.Streamable) continue;
            return false;
        }
        return true;
    }

    static boolean areAllPrintDirectivesStreamable(CallNode node) {
        return PrintDirectives.areAllPrintDirectivesStreamable(node.getEscapingDirectives());
    }

    static boolean areAllPrintDirectivesStreamable(MsgFallbackGroupNode node) {
        return PrintDirectives.areAllPrintDirectivesStreamable(node.getEscapingDirectives());
    }

    static boolean areAllPrintDirectivesStreamable(ImmutableList<SoyPrintDirective> escapingDirectives) {
        for (SoyPrintDirective directive : escapingDirectives) {
            if (directive instanceof SoyJbcSrcPrintDirective.Streamable) continue;
            return false;
        }
        return true;
    }

    static AppendableAndFlushBuffersDepth applyStreamingEscapingDirectives(List<SoyPrintDirective> directives, AppendableExpression appendable, JbcSrcPluginContext context) {
        Preconditions.checkArgument((!directives.isEmpty() ? 1 : 0) != 0);
        ArrayList<StreamingDirectiveWithArgs> directivesToApply = new ArrayList<StreamingDirectiveWithArgs>();
        for (SoyPrintDirective directive : directives) {
            directivesToApply.add(StreamingDirectiveWithArgs.create((SoyJbcSrcPrintDirective.Streamable)directive));
        }
        return PrintDirectives.applyStreamingPrintDirectivesTo(directivesToApply, appendable, context);
    }

    static AppendableAndFlushBuffersDepth applyStreamingPrintDirectives(List<PrintDirectiveNode> directives, AppendableExpression appendable, ExpressionCompiler.BasicExpressionCompiler basic, JbcSrcPluginContext renderContext) {
        Preconditions.checkArgument((!directives.isEmpty() ? 1 : 0) != 0);
        ArrayList<StreamingDirectiveWithArgs> directivesToApply = new ArrayList<StreamingDirectiveWithArgs>();
        for (PrintDirectiveNode directive : directives) {
            directivesToApply.add(StreamingDirectiveWithArgs.create((SoyJbcSrcPrintDirective.Streamable)directive.getPrintDirective(), basic.compileToList((List<? extends ExprNode>)directive.getArgs())));
        }
        return PrintDirectives.applyStreamingPrintDirectivesTo(directivesToApply, appendable, renderContext);
    }

    private static AppendableAndFlushBuffersDepth applyStreamingPrintDirectivesTo(List<StreamingDirectiveWithArgs> directivesToApply, AppendableExpression appendable, JbcSrcPluginContext context) {
        Expression currAppendable = appendable;
        int flushBuffersDepth = -1;
        for (StreamingDirectiveWithArgs directiveToApply : Lists.reverse(directivesToApply)) {
            SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions next = directiveToApply.apply(context, currAppendable);
            currAppendable = next.appendable();
            if (!next.closeable() && flushBuffersDepth < 0) continue;
            ++flushBuffersDepth;
        }
        return AppendableAndFlushBuffersDepth.create(AppendableExpression.forExpression(currAppendable.asNonJavaNullable()), flushBuffersDepth);
    }

    private PrintDirectives() {
    }

    @AutoValue
    static abstract class StreamingDirectiveWithArgs {
        StreamingDirectiveWithArgs() {
        }

        static StreamingDirectiveWithArgs create(SoyJbcSrcPrintDirective.Streamable directive) {
            return new AutoValue_PrintDirectives_StreamingDirectiveWithArgs(directive, (ImmutableList<SoyExpression>)ImmutableList.of());
        }

        static StreamingDirectiveWithArgs create(SoyJbcSrcPrintDirective.Streamable directive, List<SoyExpression> arguments) {
            return new AutoValue_PrintDirectives_StreamingDirectiveWithArgs(directive, (ImmutableList<SoyExpression>)ImmutableList.copyOf(arguments));
        }

        abstract SoyJbcSrcPrintDirective.Streamable directive();

        abstract ImmutableList<SoyExpression> arguments();

        SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions apply(JbcSrcPluginContext context, Expression appendable) {
            return this.directive().applyForJbcSrcStreaming(context, appendable, (List<SoyExpression>)this.arguments());
        }
    }

    @AutoValue
    static abstract class AppendableAndFlushBuffersDepth {
        AppendableAndFlushBuffersDepth() {
        }

        static AppendableAndFlushBuffersDepth create(AppendableExpression appendableExpression, int flushDepth) {
            return new AutoValue_PrintDirectives_AppendableAndFlushBuffersDepth(appendableExpression, flushDepth);
        }

        abstract AppendableExpression appendable();

        abstract int flushBuffersDepth();
    }
}

