/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_MsgCompiler_PlaceholderAndEndTag;
import com.google.template.soy.jbcsrc.AutoValue_MsgCompiler_PlaceholderCompiler_Placeholder;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.MsgDefaultConstantFactory;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.StringType;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;

final class MsgCompiler {
    private static final Handle MESSAGE_FACTORY_HANDLE = MethodRef.createPure(MsgDefaultConstantFactory.class, "bootstrapMsgConstant", MethodHandles.Lookup.class, String.class, Class.class, Object[].class).asHandle();
    private final DetachState detachState;
    private final TemplateParameterLookup parameterLookup;
    private final TemplateVariableManager variableManager;
    private final AppendableExpression appendableExpression;
    private final PlaceholderCompiler placeholderCompiler;

    MsgCompiler(DetachState detachState, TemplateParameterLookup parameterLookup, TemplateVariableManager variableManager, AppendableExpression appendableExpression, PlaceholderCompiler placeholderCompiler) {
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.variableManager = (TemplateVariableManager)Preconditions.checkNotNull((Object)variableManager);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.placeholderCompiler = (PlaceholderCompiler)Preconditions.checkNotNull((Object)placeholderCompiler);
    }

    Statement compileMessage(MsgUtils.MsgPartsAndIds partsAndId, MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives, boolean isFallback) {
        Statement printMsg;
        if (msg.isRawTextMsg()) {
            Expression soyMsgDefaultText = isFallback ? null : BytecodeUtils.constant(((SoyMsgRawTextPart)Iterables.getOnlyElement(partsAndId.parts)).getRawText());
            Expression soyMsgPart = msg.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().getBasicSoyMsgPartWithAlternateId(partsAndId.id, soyMsgDefaultText, msg.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().getBasicSoyMsgPart(partsAndId.id, soyMsgDefaultText);
            printMsg = this.handleBasicTranslation(msg, escapingDirectives, soyMsgPart);
        } else {
            Expression soyMsgDefaultParts = isFallback ? null : this.compileDefaultMessagePartsConstant(partsAndId);
            Expression soyMsgParts = msg.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().getSoyMsgPartsWithAlternateId(partsAndId.id, soyMsgDefaultParts, msg.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().getSoyMsgParts(partsAndId.id, soyMsgDefaultParts);
            printMsg = this.handleTranslationWithPlaceholders(msg, escapingDirectives, soyMsgParts, this.parameterLookup.getPluginContext().getULocale(), partsAndId);
        }
        return printMsg.withSourceLocation(msg.getSourceLocation());
    }

    private Expression compileDefaultMessagePartsConstant(MsgUtils.MsgPartsAndIds partsAndId) {
        ImmutableList<Object> constantParts = MsgDefaultConstantFactory.msgToPartsList(partsAndId.parts);
        return BytecodeUtils.constant(BytecodeUtils.IMMUTABLE_LIST_TYPE, new ConstantDynamic("defaultMsg", BytecodeUtils.IMMUTABLE_LIST_TYPE.getDescriptor(), MESSAGE_FACTORY_HANDLE, constantParts.toArray()), Expression.Features.of(Expression.Feature.CHEAP, Expression.Feature.NON_JAVA_NULLABLE));
    }

    private Statement handleBasicTranslation(MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives, Expression soyMsgPart) {
        SoyExpression text = SoyExpression.forString(msg.getEscapingMode() == EscapingMode.ESCAPE_HTML ? MethodRefs.HANDLE_BASIC_TRANSLATION_AND_ESCAPE_HTML.invoke(soyMsgPart) : soyMsgPart);
        for (SoyPrintDirective directive : escapingDirectives) {
            text = this.parameterLookup.getRenderContext().applyPrintDirective(directive, text);
        }
        return this.appendableExpression.appendString(text.coerceToString()).toStatement();
    }

    private Statement handleTranslationWithPlaceholders(MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives, Expression soyMsgParts, Expression locale, MsgUtils.MsgPartsAndIds partsAndId) {
        Statement render;
        Label reattachPoint = new Label();
        MethodRef cstruct = msg.isPlrselMsg() ? MethodRefs.PLRSEL_MSG_RENDERER : MethodRefs.MSG_RENDERER;
        Expression renderer = cstruct.invoke(BytecodeUtils.constant(partsAndId.id), soyMsgParts, locale, BytecodeUtils.constant(msg.getVarNameToRepNodeMap().size()), BytecodeUtils.constant(msg.getEscapingMode() == EscapingMode.ESCAPE_HTML));
        boolean requiresDetachLogic = false;
        for (Map.Entry entry : msg.getVarNameToRepNodeMap().entrySet()) {
            String phName = (String)entry.getKey();
            PlaceholderAndEndTag placeholder = this.compilePlaceholder(msg, phName, (SoyNode.MsgSubstUnitNode)entry.getValue(), this.detachState.createExpressionDetacher(reattachPoint));
            boolean bl = requiresDetachLogic = requiresDetachLogic || placeholder.requiresDetachLogic();
            if (placeholder.endTagToMatch().isPresent()) {
                renderer = renderer.invoke(MethodRefs.MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING, BytecodeUtils.constant(phName), placeholder.expression(), BytecodeUtils.constant(placeholder.endTagToMatch().get()));
                continue;
            }
            renderer = renderer.invoke(MethodRefs.MSG_RENDERER_SET_PLACEHOLDER, BytecodeUtils.constant(phName), placeholder.expression());
        }
        TemplateVariableManager.Scope scope = this.variableManager.enterScope();
        TemplateVariableManager.Variable msgRendererVar = scope.createSynthetic(SyntheticVarName.renderee(), renderer, TemplateVariableManager.SaveStrategy.STORE);
        Statement initMsgRenderer = msgRendererVar.initializer().labelStart(reattachPoint);
        if (PrintDirectives.areAllPrintDirectivesStreamable(escapingDirectives)) {
            Statement initAppendable = Statement.NULL_STATEMENT;
            Statement clearAppendable = Statement.NULL_STATEMENT;
            AppendableExpression appendable = this.appendableExpression;
            if (!escapingDirectives.isEmpty()) {
                PrintDirectives.AppendableAndFlushBuffersDepth wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(escapingDirectives, appendable, this.parameterLookup.getPluginContext());
                TemplateVariableManager.Variable appendableVar = scope.createSynthetic(SyntheticVarName.appendable(), wrappedAppendable.appendable(), TemplateVariableManager.SaveStrategy.STORE);
                initAppendable = appendableVar.initializer();
                appendable = AppendableExpression.forExpression(appendableVar.accessor());
                if (wrappedAppendable.flushBuffersDepth() >= 0) {
                    clearAppendable = appendable.flushBuffers(wrappedAppendable.flushBuffersDepth());
                }
            }
            Expression callRenderAndResolve = msgRendererVar.accessor().invoke(MethodRefs.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, appendable);
            render = Statement.concat(initAppendable, requiresDetachLogic ? this.detachState.detachForRender(callRenderAndResolve) : this.detachState.assertFullyRenderered(callRenderAndResolve), clearAppendable);
        } else {
            Label start = new Label();
            SoyExpression value = SoyExpression.forSoyValue(StringType.getInstance(), (requiresDetachLogic ? this.detachState.createExpressionDetacher(start).resolveSoyValueProvider(msgRendererVar.accessor()) : msgRendererVar.accessor().invoke(MethodRefs.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0])).checkedCast(BytecodeUtils.STRING_DATA_TYPE));
            for (SoyPrintDirective directive : escapingDirectives) {
                value = this.parameterLookup.getRenderContext().applyPrintDirective(directive, value);
            }
            render = this.appendableExpression.appendString(value.unboxAsStringUnchecked()).toStatement().labelStart(start);
        }
        return Statement.concat(initMsgRenderer, render, scope.exitScope());
    }

    private PlaceholderAndEndTag compilePlaceholder(MsgNode originalMsg, String placeholderName, SoyNode.MsgSubstUnitNode substUnitNode, ExpressionDetacher expressionDetacher) {
        if (substUnitNode instanceof MsgPluralNode) {
            return PlaceholderAndEndTag.create(this.placeholderCompiler.compile(((MsgPluralNode)substUnitNode).getExpr(), expressionDetacher));
        }
        if (substUnitNode instanceof MsgSelectNode) {
            return PlaceholderAndEndTag.create(this.placeholderCompiler.compile(((MsgSelectNode)substUnitNode).getExpr(), expressionDetacher));
        }
        if (substUnitNode instanceof MsgPlaceholderNode) {
            return this.compileNormalPlaceholder(originalMsg, placeholderName, (MsgPlaceholderNode)substUnitNode);
        }
        throw new AssertionError((Object)("unexpected child: " + String.valueOf(substUnitNode)));
    }

    private PlaceholderAndEndTag compileNormalPlaceholder(MsgNode originalMsg, String placeholderName, MsgPlaceholderNode placeholder) {
        if (placeholder.numChildren() == 0) {
            return PlaceholderAndEndTag.create(PlaceholderCompiler.Placeholder.create(FieldRef.EMPTY_STRING_DATA.accessor(), false));
        }
        ExtraCodeCompiler prefix = ExtraCodeCompiler.NO_OP;
        ExtraCodeCompiler suffix = ExtraCodeCompiler.NO_OP;
        Optional<String> closeTagPlaceholderNameToMatch = Optional.empty();
        SoyNode.StandaloneNode initialNode = (SoyNode.StandaloneNode)placeholder.getChild(0);
        if (initialNode instanceof MsgHtmlTagNode && placeholder.getParent().getKind() == SoyNode.Kind.VE_LOG_NODE) {
            final VeLogNode veLogNode = (VeLogNode)placeholder.getParent();
            int childIndex = veLogNode.getChildIndex(placeholder);
            if (childIndex == 0) {
                prefix = new ExtraCodeCompiler(this){

                    @Override
                    public boolean requiresDetachLogic(TemplateAnalysis analysis) {
                        return ExpressionCompiler.requiresDetach(analysis, veLogNode.getVeDataExpression());
                    }

                    @Override
                    public Statement compile(ExpressionCompiler exprCompiler, AppendableExpression appendable, DetachState detachStateForExtraCodeCompiler) {
                        Label restartPoint = new Label();
                        SoyExpression veData = exprCompiler.compileSubExpression(veLogNode.getVeDataExpression(), detachStateForExtraCodeCompiler.createExpressionDetacher(restartPoint));
                        return appendable.enterLoggableElement(MethodRefs.CREATE_LOG_STATEMENT.invoke(BytecodeUtils.constant(false), veData)).toStatement().labelStart(restartPoint);
                    }
                };
                String closeTagPlaceholderName = originalMsg.getPlaceholder((MsgPlaceholderNode)veLogNode.getChild(veLogNode.numChildren() - 1)).name();
                if (closeTagPlaceholderName.equals(placeholderName)) {
                    suffix = MsgCompiler::exitLoggableElement;
                } else {
                    closeTagPlaceholderNameToMatch = Optional.of(closeTagPlaceholderName);
                }
            } else if (childIndex == veLogNode.numChildren() - 1) {
                suffix = MsgCompiler::exitLoggableElement;
            }
        }
        return PlaceholderAndEndTag.create(this.placeholderCompiler.compile(placeholderName, initialNode, prefix, suffix), closeTagPlaceholderNameToMatch);
    }

    private static Statement exitLoggableElement(ExpressionCompiler exprCompiler, AppendableExpression appendable, DetachState detachState) {
        return appendable.exitLoggableElement().toStatement();
    }

    @AutoValue
    static abstract class PlaceholderAndEndTag {
        PlaceholderAndEndTag() {
        }

        static PlaceholderAndEndTag create(PlaceholderCompiler.Placeholder placeholder) {
            return PlaceholderAndEndTag.create(placeholder, Optional.empty());
        }

        static PlaceholderAndEndTag create(PlaceholderCompiler.Placeholder placeholder, Optional<String> matchingEndTag) {
            return new AutoValue_MsgCompiler_PlaceholderAndEndTag(placeholder.soyValueProvider(), placeholder.requiresDetachLogicToResolve(), matchingEndTag);
        }

        abstract Expression expression();

        abstract boolean requiresDetachLogic();

        abstract Optional<String> endTagToMatch();
    }

    static interface PlaceholderCompiler {
        public Placeholder compile(ExprRootNode var1, ExpressionDetacher var2);

        public Placeholder compile(String var1, SoyNode.StandaloneNode var2, ExtraCodeCompiler var3, ExtraCodeCompiler var4);

        @AutoValue
        public static abstract class Placeholder {
            static Placeholder create(Expression soyValueProvider, boolean requiresDetachLogicToResolve) {
                soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
                return new AutoValue_MsgCompiler_PlaceholderCompiler_Placeholder(soyValueProvider, requiresDetachLogicToResolve);
            }

            abstract Expression soyValueProvider();

            abstract boolean requiresDetachLogicToResolve();
        }
    }
}

