/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.JbcSrcJavaValue;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.JbcSrcPluginRuntime;
import com.google.template.soy.plugin.internal.JavaPluginExecContext;
import com.google.template.soy.plugin.java.internal.JavaPluginValidator;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class JbcSrcValueFactory
extends JavaValueFactory {
    private final JavaPluginExecContext fnNode;
    private final JavaPluginContext context;
    private final PluginInstanceLookup pluginInstanceLookup;
    private final JavaPluginValidator pluginValidator;
    private final SoyTypeRegistry registry;
    private final ErrorReporter errorReporter;
    private final ExpressionDetacher detacher;

    JbcSrcValueFactory(JavaPluginExecContext fnNode, final JbcSrcPluginContext jbcPluginContext, PluginInstanceLookup pluginInstanceLookup, ErrorReporter errorReporter, SoyTypeRegistry registry, ExpressionDetacher detacher) {
        this.fnNode = fnNode;
        this.pluginInstanceLookup = pluginInstanceLookup;
        this.registry = registry;
        this.errorReporter = errorReporter;
        this.pluginValidator = new JavaPluginValidator(errorReporter, registry);
        this.context = new JavaPluginContext(this){

            @Override
            public JavaValue getULocale() {
                return JbcSrcJavaValue.of(jbcPluginContext.getULocale());
            }

            @Override
            public JavaValue getBidiDir() {
                return JbcSrcJavaValue.of(jbcPluginContext.getBidiGlobalDir());
            }

            @Override
            public JavaValue getAllRequiredCssNamespaces(JavaValue template) {
                JbcSrcJavaValue exprTemplate = (JbcSrcJavaValue)template;
                SoyExpression soyExpression = (SoyExpression)exprTemplate.expr();
                return JbcSrcJavaValue.of(jbcPluginContext.getAllRequiredCssNamespaces(soyExpression));
            }

            @Override
            public JavaValue getAllRequiredCssPaths(JavaValue template) {
                JbcSrcJavaValue exprTemplate = (JbcSrcJavaValue)template;
                SoyExpression soyExpression = (SoyExpression)exprTemplate.expr();
                return JbcSrcJavaValue.of(jbcPluginContext.getAllRequiredCssPaths(soyExpression));
            }
        };
        this.detacher = detacher;
    }

    SoyExpression computeForJavaSource(List<SoyExpression> args) {
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        Preconditions.checkState((this.fnNode.getParamTypes() != null ? 1 : 0) != 0, (Object)"allowed param types must be set");
        Preconditions.checkState((this.fnNode.getParamTypes().size() == args.size() ? 1 : 0) != 0, (String)"wrong # of allowed param types (%s), expected %s", this.fnNode.getParamTypes(), (int)args.size());
        this.pluginValidator.validate(this.fnNode.getFunctionName(), this.fnNode.getSourceFunction(), (List<SoyType>)this.fnNode.getParamTypes(), this.fnNode.getReturnType(), this.fnNode.getSourceLocation(), true);
        if (this.errorReporter.errorsSince(checkpoint)) {
            return SoyExpression.SOY_NULL;
        }
        SoyJavaSourceFunction javaSrcFn = this.fnNode.getSourceFunction();
        return this.toSoyExpression((JbcSrcJavaValue)javaSrcFn.applyForJavaSource(this, (List)args.stream().map(JbcSrcJavaValue::of).collect(ImmutableList.toImmutableList()), this.context));
    }

    @Override
    public JbcSrcJavaValue callStaticMethod(java.lang.reflect.Method method, JavaValue ... params) {
        return this.callPluginMethod(false, MethodRef.create(method, MethodRef.MethodPureness.NON_PURE), JbcSrcValueFactory.toMethodSignature(method), params);
    }

    @Override
    public JbcSrcJavaValue callStaticMethod(MethodSignature methodSignature, JavaValue ... params) {
        return this.callPluginMethod(false, this.getMethodRef(false, methodSignature), methodSignature, params);
    }

    @Override
    public JbcSrcJavaValue callInstanceMethod(java.lang.reflect.Method method, JavaValue ... params) {
        return this.callPluginMethod(true, MethodRef.create(method, MethodRef.MethodPureness.NON_PURE), JbcSrcValueFactory.toMethodSignature(method), params);
    }

    @Override
    public JbcSrcJavaValue callInstanceMethod(MethodSignature methodSignature, JavaValue ... params) {
        return this.callPluginMethod(true, this.getMethodRef(true, methodSignature), methodSignature, params);
    }

    private MethodRef getMethodRef(boolean isInstance, MethodSignature methodSignature) {
        TypeInfo owner = TypeInfo.create(methodSignature.fullyQualifiedClassName(), methodSignature.inInterface());
        Method asmMethod = new Method(methodSignature.methodName(), Type.getType(methodSignature.returnType()), (Type[])methodSignature.arguments().stream().map(Type::getType).toArray(Type[]::new));
        if (isInstance) {
            return methodSignature.inInterface() ? MethodRef.createInterfaceMethod(owner, asmMethod, MethodRef.MethodPureness.NON_PURE) : MethodRef.createInstanceMethod(owner, asmMethod, MethodRef.MethodPureness.NON_PURE);
        }
        return MethodRef.createStaticMethod(owner, asmMethod, MethodRef.MethodPureness.NON_PURE);
    }

    private JbcSrcJavaValue callPluginMethod(boolean isInstance, MethodRef methodRef, MethodSignature methodSignature, JavaValue ... params) {
        Expression methodCall;
        Expression[] adapted = JbcSrcValueFactory.adaptParams(methodSignature, params);
        TypeInfo owner = methodRef.owner();
        if (isInstance) {
            Expression runtime = this.pluginInstanceLookup.getPluginInstance(this.fnNode.getFunctionName()).checkedCast(owner.type());
            methodCall = runtime.invoke(methodRef, adapted);
        } else {
            methodCall = methodRef.invoke(adapted);
        }
        return JbcSrcJavaValue.of(this.tryToWrapInSoyExpression(methodCall), methodSignature);
    }

    private static MethodSignature toMethodSignature(java.lang.reflect.Method method) {
        if (method.getDeclaringClass().isInterface()) {
            return MethodSignature.createInterfaceMethod(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
        }
        return MethodSignature.create(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    @Override
    public JbcSrcJavaValue listOf(List<JavaValue> args) {
        List soyExprs = Lists.transform(args, value -> (SoyExpression)((JbcSrcJavaValue)value).expr());
        return JbcSrcJavaValue.of(SoyExpression.boxListWithSoyNullAsJavaNull(soyExprs));
    }

    @Override
    public JbcSrcJavaValue constant(double value) {
        return JbcSrcJavaValue.of(SoyExpression.forFloat(BytecodeUtils.constant(value)));
    }

    @Override
    public JbcSrcJavaValue constant(long value) {
        return JbcSrcJavaValue.of(SoyExpression.forInt(BytecodeUtils.constant(value)));
    }

    @Override
    public JbcSrcJavaValue constant(String value) {
        return JbcSrcJavaValue.of(SoyExpression.forString(BytecodeUtils.constant(value)));
    }

    @Override
    public JbcSrcJavaValue constant(boolean value) {
        return JbcSrcJavaValue.of(value ? SoyExpression.TRUE : SoyExpression.FALSE);
    }

    @Override
    public JbcSrcJavaValue constantNull() {
        return JbcSrcJavaValue.of(SoyExpression.SOY_NULL);
    }

    private static Expression maybeSoyNullToJavaNull(Expression expr) {
        if (expr.isNonSoyNullish()) {
            return expr;
        }
        return JbcSrcPluginRuntime.NULL_TO_JAVA_NULL.invoke(expr);
    }

    private static Expression maybeSoyNullishToJavaNull(Expression expr) {
        if (expr.isNonSoyNullish()) {
            return expr;
        }
        return JbcSrcPluginRuntime.NULLISH_TO_JAVA_NULL.invoke(expr);
    }

    private static Expression[] adaptParams(MethodSignature method, JavaValue[] userParams) {
        ImmutableList<Class<?>> methodParams = method.arguments();
        Expression[] params = new Expression[userParams.length];
        for (int i = 0; i < userParams.length; ++i) {
            Class methodParam = (Class)methodParams.get(i);
            JbcSrcJavaValue jbcJv = (JbcSrcJavaValue)userParams[i];
            Expression expr = jbcJv.expr();
            params[i] = expr instanceof SoyExpression ? JbcSrcValueFactory.adaptParameter(methodParam, jbcJv) : (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, expr.resultType()) ? JbcSrcValueFactory.maybeSoyNullToJavaNull(expr) : expr);
        }
        return params;
    }

    private static Expression adaptParameter(Class<?> expectedParamType, JbcSrcJavaValue value) {
        final SoyExpression actualParam = (SoyExpression)value.expr();
        if (actualParam.soyRuntimeType().soyType().equals(NullType.getInstance())) {
            return BytecodeUtils.constantNull(Type.getType(expectedParamType)).withSourceLocation(actualParam.location());
        }
        if (expectedParamType == SoyValue.class) {
            return JbcSrcValueFactory.maybeSoyNullToJavaNull(actualParam.box());
        }
        if (expectedParamType == PrimitiveData.class) {
            return JbcSrcValueFactory.maybeSoyNullToJavaNull(actualParam.box()).checkedCast(expectedParamType);
        }
        if (SoyValue.class.isAssignableFrom(expectedParamType)) {
            return JbcSrcValueFactory.maybeSoyNullishToJavaNull(actualParam.box()).checkedCast(expectedParamType);
        }
        if (expectedParamType == Integer.TYPE) {
            return actualParam.unboxAsInt();
        }
        if (expectedParamType == Double.TYPE) {
            return actualParam.coerceToDouble();
        }
        if (Message.class.isAssignableFrom(expectedParamType)) {
            if (expectedParamType.equals(Message.class)) {
                return actualParam.unboxAsMessageOrJavaNull(BytecodeUtils.MESSAGE_TYPE);
            }
            return actualParam.unboxAsMessageOrJavaNull(Type.getType(expectedParamType));
        }
        if (expectedParamType.isEnum() && ProtocolMessageEnum.class.isAssignableFrom(expectedParamType)) {
            if (actualParam.isNonSoyNullish()) {
                return JbcSrcValueFactory.convertToEnum(expectedParamType, actualParam);
            }
            final MethodRef forNumber = JbcSrcValueFactory.getForNumberMethod(expectedParamType);
            return new Expression(forNumber.returnType()){

                @Override
                protected void doGen(CodeBuilder mv) {
                    Label end = new Label();
                    actualParam.gen(mv);
                    BytecodeUtils.coalesceSoyNullishToJavaNull(mv, actualParam.resultType(), end);
                    MethodRefs.SOY_VALUE_LONG_VALUE.invokeUnchecked(mv);
                    mv.cast(Type.LONG_TYPE, Type.INT_TYPE);
                    forNumber.invokeUnchecked(mv);
                    mv.mark(end);
                }
            };
        }
        if (expectedParamType.equals(Boolean.TYPE)) {
            return actualParam.unboxAsBoolean();
        }
        if (expectedParamType.equals(Long.TYPE)) {
            return actualParam.unboxAsLong();
        }
        if (expectedParamType.equals(String.class)) {
            return actualParam.unboxAsStringOrJavaNull();
        }
        if (expectedParamType.equals(List.class)) {
            return actualParam.unboxAsListOrJavaNull();
        }
        throw new AssertionError((Object)("Unable to convert parameter to " + String.valueOf(expectedParamType)));
    }

    private static Expression convertToEnum(Class<?> enumType, SoyExpression e) {
        return JbcSrcValueFactory.getForNumberMethod(enumType).invoke(BytecodeUtils.numericConversion(e.unboxAsLong(), Type.INT_TYPE));
    }

    private static MethodRef getForNumberMethod(Class<?> enumType) {
        return MethodRef.createPure(enumType, "forNumber", Integer.TYPE);
    }

    private static String nameFromDescriptor(Class<?> protoType) {
        try {
            return ((Descriptors.GenericDescriptor)protoType.getDeclaredMethod("getDescriptor", new Class[0]).invoke(null, new Object[0])).getFullName();
        }
        catch (ReflectiveOperationException roe) {
            throw new IllegalStateException("Invalid protoType: " + String.valueOf(protoType), roe);
        }
    }

    private Expression tryToWrapInSoyExpression(Expression expr) {
        switch (expr.resultType().getSort()) {
            case 1: {
                return SoyExpression.forBool(expr);
            }
            case 5: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(expr, Type.LONG_TYPE));
            }
            case 7: {
                return SoyExpression.forInt(expr);
            }
            case 8: {
                return SoyExpression.forFloat(expr);
            }
            case 10: {
                if (!expr.resultType().equals((Object)BytecodeUtils.STRING_TYPE)) break;
                return SoyExpression.forString(expr);
            }
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SoyExpression toSoyExpression(JbcSrcJavaValue pluginReturnValue) {
        SoyType expectedType = this.fnNode.getReturnType();
        Expression expr = pluginReturnValue.expr();
        if (expr instanceof SoyExpression) {
            return (SoyExpression)expr;
        }
        MethodSignature method = pluginReturnValue.methodInfo();
        Class<?> type = method != null ? method.returnType() : BytecodeUtils.classFromAsmType(expr.resultType());
        if (List.class.isAssignableFrom(type)) {
            if (expectedType instanceof ListType) {
                return SoyExpression.forList((ListType)expectedType, expr);
            }
            if (expectedType.getKind() == SoyType.Kind.UNKNOWN) return SoyExpression.forList(ListType.of(UnknownType.getInstance()), expr);
            if (expectedType.getKind() != SoyType.Kind.ANY) throw new IllegalStateException("Invalid type: " + String.valueOf(expectedType));
            return SoyExpression.forList(ListType.of(UnknownType.getInstance()), expr);
        }
        if (Map.class.isAssignableFrom(type)) {
            if (expectedType instanceof MapType) {
                return SoyExpression.forSoyValue(expectedType, JbcSrcPluginRuntime.BOX_JAVA_MAP_AS_SOY_MAP.invoke(expr));
            }
            if (expectedType instanceof LegacyObjectMapType) {
                return SoyExpression.forSoyValue(expectedType, JbcSrcPluginRuntime.BOX_JAVA_MAP_AS_SOY_LEGACY_OBJECT_MAP.invoke(expr));
            }
            if (!(expectedType instanceof RecordType)) throw new IllegalStateException("java map cannot be converted to: " + String.valueOf(expectedType));
            return SoyExpression.forSoyValue(expectedType, JbcSrcPluginRuntime.BOX_JAVA_MAP_AS_SOY_RECORD.invoke(expr));
        }
        if (SoyValue.class.isAssignableFrom(type)) {
            return SoyExpression.forSoyValue(expectedType, this.nullGuard(expr));
        }
        if (Future.class.isAssignableFrom(type)) {
            return SoyExpression.forSoyValue(expectedType, this.detacher.resolveSoyValueProvider(expr.invoke(JbcSrcPluginRuntime.CONVERT_FUTURE_TO_SOY_VALUE_PROVIDER, new Expression[0])));
        }
        if (Message.class.isAssignableFrom(type)) {
            return SoyExpression.forProto(SoyRuntimeType.getUnboxedType(this.soyTypeForProtoOrEnum(type)).get(), expr);
        }
        if (!type.isEnum()) throw new IllegalStateException("invalid type: " + String.valueOf(type));
        if (!ProtocolMessageEnum.class.isAssignableFrom(type)) throw new IllegalStateException("invalid type: " + String.valueOf(type));
        return SoyExpression.forInt(BytecodeUtils.numericConversion(MethodRefs.PROTOCOL_ENUM_GET_NUMBER.invoke(expr), Type.LONG_TYPE));
    }

    private SoyType soyTypeForProtoOrEnum(Class<?> type) {
        return this.registry.getProtoRegistry().getProtoType(JbcSrcValueFactory.nameFromDescriptor(type));
    }

    private Expression nullGuard(Expression delegate) {
        Preconditions.checkArgument((boolean)BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, delegate.resultType()));
        return JbcSrcPluginRuntime.JAVA_NULL_TO_SOY_NULL.invoke(delegate);
    }

    static interface PluginInstanceLookup {
        public Expression getPluginInstance(String var1);
    }
}

