/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.ConstantsCompiler;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.JbcSrcExternRuntime;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.JavaImplNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class ExternCompiler {
    private final ExternNode extern;
    private final SoyClassWriter writer;

    ExternCompiler(ExternNode extern, SoyClassWriter writer) {
        this.extern = extern;
        this.writer = writer;
    }

    public void compile() {
        int i;
        Method memberMethod = ExternCompiler.buildMemberMethod(this.extern.getIdentifier().identifier(), this.extern.getType());
        if (!this.extern.getJavaImpl().isPresent()) {
            Statement.throwExpression(JbcSrcExternRuntime.NO_EXTERN_JAVA_IMPL.invoke(new Expression[0])).writeMethod(this.methodAccess(), memberMethod, this.writer);
            return;
        }
        JavaImplNode javaImpl = this.extern.getJavaImpl().get();
        int declaredMethodArgs = this.extern.getType().getParameters().size();
        ImmutableList.Builder paramNamesBuilder = ImmutableList.builder();
        paramNamesBuilder.add((Object)"$renderContext");
        for (int i2 = 0; i2 < declaredMethodArgs; ++i2) {
            paramNamesBuilder.add((Object)("p" + (i2 + 1)));
        }
        ImmutableList paramNames = paramNamesBuilder.build();
        TypeInfo externClass = TypeInfo.create(javaImpl.className(), javaImpl.isInterface());
        TypeInfo returnType = ExternCompiler.getTypeInfoLoadedIfPossible(javaImpl.returnType());
        TypeInfo[] paramTypesInfos = (TypeInfo[])javaImpl.params().stream().map(ExternCompiler::getTypeInfoLoadedIfPossible).toArray(TypeInfo[]::new);
        Type[] paramTypes = (Type[])Arrays.stream(paramTypesInfos).map(TypeInfo::type).toArray(Type[]::new);
        final Label start = new Label();
        final Label end = new Label();
        final TemplateVariableManager paramSet = new TemplateVariableManager(TypeInfo.createClass(Names.javaClassNameFromSoyNamespace(this.extern.getNearestAncestor(SoyFileNode.class).getNamespace())).type(), memberMethod.getArgumentTypes(), (ImmutableList<String>)paramNames, start, end, true);
        Expression renderContext = paramSet.getVariable("$renderContext");
        ConstantsCompiler.ConstantVariables vars = new ConstantsCompiler.ConstantVariables(paramSet, new RenderContextExpression(renderContext));
        Method externMethod = new Method(javaImpl.methodName(), returnType.type(), paramTypes);
        ArrayList<Expression> adaptedParams = new ArrayList<Expression>();
        if (!javaImpl.isStatic()) {
            adaptedParams.add(vars.getRenderContext().getPluginInstance(javaImpl.className()).checkedCast(externClass.type()));
        }
        for (i = 0; i < declaredMethodArgs; ++i) {
            adaptedParams.add(ExternCompiler.adaptParameter(paramSet.getVariable((String)paramNames.get(i + 1)), paramTypesInfos[i], ((FunctionType.Parameter)this.extern.getType().getParameters().get(i)).getType()));
        }
        for (i = declaredMethodArgs; i < javaImpl.params().size(); ++i) {
            adaptedParams.add(ExternCompiler.adaptImplicitParameter(vars, paramTypesInfos[i]));
        }
        MethodRef extMethodRef = javaImpl.isStatic() ? MethodRef.createStaticMethod(externClass, externMethod, MethodRef.MethodPureness.NON_PURE) : (javaImpl.isInterface() ? MethodRef.createInterfaceMethod(externClass, externMethod, MethodRef.MethodPureness.NON_PURE) : MethodRef.createInstanceMethod(externClass, externMethod, MethodRef.MethodPureness.NON_PURE));
        final Expression body = ExternCompiler.adaptReturnType(memberMethod.getReturnType(), this.extern.getType().getReturnType(), extMethodRef.invoke(adaptedParams));
        new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(start);
                body.gen(adapter);
                adapter.mark(end);
                adapter.returnValue();
                paramSet.generateTableEntries(adapter);
            }
        }.writeMethod(this.methodAccess(), memberMethod, this.writer);
    }

    private int methodAccess() {
        return (this.extern.isExported() ? 1 : 0) | 8;
    }

    static SoyRuntimeType getRuntimeType(SoyType type) {
        SoyType nonNullable = SoyTypes.tryRemoveNullish(type);
        SoyRuntimeType runtimeType = SoyRuntimeType.getUnboxedType(nonNullable).orElseGet(() -> SoyRuntimeType.getBoxedType(nonNullable));
        if (!nonNullable.equals(type) && BytecodeUtils.isPrimitive(runtimeType.runtimeType())) {
            runtimeType = SoyRuntimeType.getBoxedType(type);
        }
        return runtimeType;
    }

    static Method buildMemberMethod(String symbol, FunctionType type) {
        Type[] args = (Type[])Streams.concat((Stream[])new Stream[]{Stream.of(BytecodeUtils.RENDER_CONTEXT_TYPE), type.getParameters().stream().map(p -> ExternCompiler.getRuntimeType(p.getType()).runtimeType())}).toArray(Type[]::new);
        return new Method(symbol, ExternCompiler.getRuntimeType(type.getReturnType()).runtimeType(), args);
    }

    private static TypeInfo getTypeInfoLoadedIfPossible(String s) {
        try {
            return TypeInfo.create(MethodSignature.forName(s));
        }
        catch (ClassNotFoundException e) {
            return TypeInfo.create(s, false);
        }
    }

    private static Expression adaptParameter(Expression param, TypeInfo javaTypeInfo, SoyType soyType) {
        Type javaType = javaTypeInfo.type();
        SoyExpression actualParam = param instanceof SoyExpression ? (SoyExpression)param : SoyExpression.forRuntimeType(ExternCompiler.getRuntimeType(soyType), param);
        boolean soyTypeBoxed = actualParam.soyRuntimeType().isBoxed();
        boolean isObject = javaType.equals((Object)BytecodeUtils.OBJECT.type());
        if (javaType.equals((Object)BytecodeUtils.SOY_VALUE_TYPE) || javaType.equals((Object)BytecodeUtils.PRIMITIVE_DATA_TYPE)) {
            return actualParam.boxWithSoyNullAsJavaNull().checkedCast(javaType);
        }
        if (javaTypeInfo.classOptional().isPresent() && SoyValue.class.isAssignableFrom(javaTypeInfo.classOptional().get())) {
            return actualParam.boxWithSoyNullishAsJavaNull().checkedCast(javaType);
        }
        if (javaType.equals((Object)Type.INT_TYPE)) {
            return JbcSrcExternRuntime.LONG_TO_INT.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.BOXED_INTEGER_TYPE)) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_BOXED_INTEGER.invoke(actualParam);
            }
            return MethodRefs.BOX_INTEGER.invoke(JbcSrcExternRuntime.LONG_TO_INT.invoke(actualParam));
        }
        if (javaType.equals((Object)Type.DOUBLE_TYPE)) {
            return actualParam.coerceToDouble();
        }
        if (javaType.equals((Object)BytecodeUtils.BOXED_DOUBLE_TYPE)) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_BOXED_DOUBLE.invoke(actualParam);
            }
            return MethodRefs.BOX_DOUBLE.invoke(actualParam.coerceToDouble());
        }
        if (javaType.equals((Object)Type.FLOAT_TYPE)) {
            return BytecodeUtils.numericConversion(actualParam.coerceToDouble(), Type.FLOAT_TYPE);
        }
        if (javaType.equals((Object)BytecodeUtils.BOXED_FLOAT_TYPE)) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_BOXED_FLOAT.invoke(actualParam);
            }
            return MethodRefs.BOX_FLOAT.invoke(BytecodeUtils.numericConversion(actualParam.coerceToDouble(), Type.FLOAT_TYPE));
        }
        if (javaType.equals((Object)BytecodeUtils.NUMBER_TYPE)) {
            return actualParam.unboxAsNumberOrJavaNull();
        }
        SoyType nonNullableSoyType = SoyTypes.tryRemoveNullish(soyType);
        if (nonNullableSoyType.getKind() == SoyType.Kind.MESSAGE) {
            return actualParam;
        }
        if (nonNullableSoyType.getKind() == SoyType.Kind.PROTO) {
            return actualParam.checkedCast(ProtoUtils.messageRuntimeType(((SoyProtoType)nonNullableSoyType).getDescriptor()).type());
        }
        if (soyType.getKind() == SoyType.Kind.PROTO_ENUM) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_ENUM.invoke(actualParam, BytecodeUtils.constant(BytecodeUtils.getTypeForClassName(javaType.getClassName())));
            }
            return MethodRef.createStaticMethod(javaTypeInfo, new Method("forNumber", javaType, new Type[]{Type.INT_TYPE}), MethodRef.MethodPureness.PURE).invoke(BytecodeUtils.numericConversion(actualParam.unboxAsLong(), Type.INT_TYPE));
        }
        if (javaType.equals((Object)BytecodeUtils.SAFE_URL_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_SAFE_URL.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.SAFE_HTML_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_SAFE_HTML.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.TRUSTED_RESOURCE_URL_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_TRUSTED_RESOURCE_URL.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.SAFE_URL_PROTO_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_SAFE_URL_PROTO.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.TRUSTED_RESOURCE_PROTO_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_TRUSTED_RESOURCE_URL_PROTO.invoke(actualParam);
        }
        if (javaType.equals((Object)BytecodeUtils.SAFE_HTML_PROTO_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_SAFE_HTML_PROTO.invoke(actualParam);
        }
        if (javaType.equals((Object)Type.BOOLEAN_TYPE)) {
            return actualParam.unboxAsBoolean();
        }
        if (javaType.equals((Object)BytecodeUtils.BOXED_BOOLEAN_TYPE)) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_BOXED_BOOLEAN.invoke(actualParam);
            }
            return MethodRefs.BOX_BOOLEAN.invoke(actualParam.unboxAsBoolean());
        }
        if (javaType.equals((Object)Type.LONG_TYPE)) {
            return actualParam.unboxAsLong();
        }
        if (javaType.equals((Object)BytecodeUtils.BOXED_LONG_TYPE)) {
            if (soyTypeBoxed) {
                return JbcSrcExternRuntime.SOY_VALUE_TO_BOXED_LONG.invoke(actualParam);
            }
            return MethodRefs.BOX_LONG.invoke(actualParam.unboxAsLong());
        }
        if (javaType.equals((Object)BytecodeUtils.STRING_TYPE)) {
            return actualParam.unboxAsStringOrJavaNull();
        }
        if (!isObject && BytecodeUtils.isDefinitelyAssignableFrom(javaType, BytecodeUtils.IMMUTABLE_LIST_TYPE)) {
            SoyType elmType = SoyTypes.getListElementType(nonNullableSoyType);
            SoyExpression unboxedList = actualParam.isBoxed() ? actualParam.unboxAsListOrJavaNull() : actualParam;
            switch (elmType.getKind()) {
                case INT: {
                    return JbcSrcExternRuntime.LIST_UNBOX_INTS.invoke(unboxedList);
                }
                case FLOAT: {
                    return JbcSrcExternRuntime.LIST_UNBOX_FLOATS.invoke(unboxedList);
                }
                case STRING: {
                    return JbcSrcExternRuntime.LIST_UNBOX_STRINGS.invoke(unboxedList);
                }
                case BOOL: {
                    return JbcSrcExternRuntime.LIST_UNBOX_BOOLS.invoke(unboxedList);
                }
                case PROTO: {
                    return JbcSrcExternRuntime.LIST_UNBOX_PROTOS.invoke(unboxedList);
                }
                case PROTO_ENUM: {
                    String javaClass = JavaQualifiedNames.getClassName(((SoyProtoEnumType)elmType).getDescriptor());
                    return JbcSrcExternRuntime.LIST_UNBOX_ENUMS.invoke(unboxedList, BytecodeUtils.constant(BytecodeUtils.getTypeForClassName(javaClass)));
                }
                case UNION: {
                    if (!SoyTypes.NUMBER_TYPE.equals(elmType)) break;
                    return JbcSrcExternRuntime.LIST_UNBOX_NUMBERS.invoke(unboxedList);
                }
            }
            throw new AssertionError((Object)"ValidateExternsPass should prevent this.");
        }
        if (javaType.equals((Object)BytecodeUtils.MAP_TYPE) || javaType.equals((Object)BytecodeUtils.IMMUTABLE_MAP_TYPE)) {
            if (nonNullableSoyType.getKind() == SoyType.Kind.RECORD) {
                return JbcSrcExternRuntime.UNBOX_RECORD.invoke(actualParam);
            }
            SoyType keyType = SoyTypes.getMapKeysType(nonNullableSoyType);
            SoyType valueType = SoyTypes.getMapValuesType(nonNullableSoyType);
            return JbcSrcExternRuntime.UNBOX_MAP.invoke(actualParam, BytecodeUtils.constant(BytecodeUtils.getTypeForSoyType(keyType)), BytecodeUtils.constant(BytecodeUtils.getTypeForSoyType(valueType)));
        }
        if (javaType.equals((Object)BytecodeUtils.OBJECT.type())) {
            if (BytecodeUtils.isPrimitive(actualParam.soyRuntimeType().runtimeType())) {
                return BytecodeUtils.boxJavaPrimitive(actualParam);
            }
            return actualParam.isBoxed() ? JbcSrcExternRuntime.UNBOX_OBJECT.invoke(actualParam) : actualParam;
        }
        throw new AssertionError((Object)String.format("Unable to convert parameter of Soy type %s to java type %s.", soyType, javaType));
    }

    private static Expression adaptImplicitParameter(ConstantsCompiler.ConstantVariables vars, TypeInfo javaTypeInfo) {
        switch (javaTypeInfo.className()) {
            case "com.google.template.soy.data.Dir": {
                return vars.getRenderContext().getBidiGlobalDirDir();
            }
            case "com.google.template.soy.plugin.java.RenderCssHelper": {
                return vars.getRenderContext().getRenderCssHelper();
            }
            case "com.ibm.icu.util.ULocale": {
                return vars.getRenderContext().getULocale();
            }
        }
        throw new IllegalArgumentException(javaTypeInfo.className());
    }

    static Expression adaptReturnType(Type returnType, SoyType soyReturnType, Expression externCall) {
        Type externType = externCall.resultType();
        if (externType.equals((Object)BytecodeUtils.BOXED_INTEGER_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_INTEGER.invoke(externCall);
        }
        if (externType.equals((Object)Type.INT_TYPE)) {
            return BytecodeUtils.numericConversion(externCall, Type.LONG_TYPE);
        }
        if (externType.equals((Object)BytecodeUtils.BOXED_LONG_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_LONG.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.BOXED_DOUBLE_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_DOUBLE.invoke(externCall);
        }
        if (externType.equals((Object)Type.FLOAT_TYPE)) {
            return BytecodeUtils.numericConversion(externCall, Type.DOUBLE_TYPE);
        }
        if (externType.equals((Object)BytecodeUtils.BOXED_FLOAT_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_FLOAT.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.BOXED_BOOLEAN_TYPE)) {
            return JbcSrcExternRuntime.UNBOX_BOOLEAN.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.OBJECT.type()) || externType.equals((Object)BytecodeUtils.NUMBER_TYPE)) {
            Preconditions.checkState((soyReturnType.getKind() != SoyType.Kind.MAP ? 1 : 0) != 0);
            return JbcSrcExternRuntime.CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.MAP_TYPE, externType)) {
            if (soyReturnType.getKind() == SoyType.Kind.MAP) {
                externCall = JbcSrcExternRuntime.MARK_AS_SOY_MAP.invoke(externCall);
            }
            return JbcSrcExternRuntime.CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.ITERABLE_TYPE, externType)) {
            return JbcSrcExternRuntime.LIST_BOX_VALUES.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.SAFE_URL_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_SAFE_URL_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.SAFE_URL_PROTO_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_SAFE_URL_PROTO_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.TRUSTED_RESOURCE_PROTO_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_TRUSTED_RESOURCE_URL_PROTO_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.SAFE_HTML_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_SAFE_HTML_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.SAFE_HTML_PROTO_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_SAFE_HTML_PROTO_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (externType.equals((Object)BytecodeUtils.TRUSTED_RESOURCE_URL_TYPE)) {
            return JbcSrcExternRuntime.CONVERT_TRUSTED_RESOURCE_URL_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        if (soyReturnType.getKind() == SoyType.Kind.PROTO_ENUM) {
            return BytecodeUtils.numericConversion(MethodRefs.PROTOCOL_ENUM_GET_NUMBER.invoke(externCall), Type.LONG_TYPE);
        }
        if (BytecodeUtils.SOY_VALUE_TYPE.equals((Object)ExternCompiler.getRuntimeType(soyReturnType).runtimeType())) {
            if (BytecodeUtils.isPrimitive(externCall.resultType())) {
                externCall = BytecodeUtils.boxJavaPrimitive(externCall.resultType(), externCall);
            }
            return JbcSrcExternRuntime.CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER.invoke(externCall);
        }
        return externCall;
    }
}

